/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;

public class ReportEngineTest
extends EngineCase {
    protected HashMap supportedMap = null;
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/ReportEngineTest.rptdesign";
    static final String REPORT_DESIGN = "ReportEngineTest.rptdesign";

    public void setUp() {
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.initSupportedMap();
    }

    public void tearDown() {
        this.removeFile(REPORT_DESIGN);
    }

    public void testGetConfig() {
        EngineConfig config = new EngineConfig();
        config.setTempDir("tempdir");
        org.eclipse.birt.report.engine.api.ReportEngine engine = new org.eclipse.birt.report.engine.api.ReportEngine(config);
        EngineConfig configGet = engine.getConfig();
        ReportEngineTest.assertEquals((String)config.getTempDir(), (String)configGet.getTempDir());
        engine.shutdown();
    }

    public void testOpenReportDesign() {
        try {
            String rootPath = new File("").toURL().toString();
            String goldenReportName = rootPath + "/ReportEngineTest.rptdesign";
            org.eclipse.birt.report.engine.api.ReportEngine engine = new org.eclipse.birt.report.engine.api.ReportEngine(new EngineConfig());
            IReportRunnable runnable = engine.openReportDesign(REPORT_DESIGN);
            ReportEngineTest.assertEquals((String)goldenReportName, (String)URLDecoder.decode(runnable.getReportName(), "utf-8"));
            engine.shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportEngineTest.fail();
        }
    }

    public void testCreateGetParameterDefinitionTask() {
        try {
            org.eclipse.birt.report.engine.api.ReportEngine engine = new org.eclipse.birt.report.engine.api.ReportEngine(new EngineConfig());
            IReportRunnable runnable = engine.openReportDesign(REPORT_DESIGN);
            IGetParameterDefinitionTask paramDefnTask = engine.createGetParameterDefinitionTask(runnable);
            IParameterDefnBase paramDefn = paramDefnTask.getParameterDefn("param");
            ReportEngineTest.assertTrue((boolean)(paramDefn instanceof ScalarParameterDefn));
            ReportEngineTest.assertTrue((paramDefn.getParameterType() == 0 ? 1 : 0) != 0);
            ReportEngineTest.assertTrue((boolean)"defaultValue".equals(paramDefnTask.getDefaultValue(paramDefn)));
            ScalarParameterDefn scalarParameter = (ScalarParameterDefn)paramDefn;
            Map userProperties = scalarParameter.getUserPropertyValues();
            ReportEngineTest.assertEquals((int)2, (int)userProperties.size());
            ReportEngineTest.assertEquals((Object)5, userProperties.get("expression"));
            ReportEngineTest.assertEquals((Object)"string", userProperties.get("string"));
            ReportEngineTest.assertEquals((String)"5", (String)scalarParameter.getUserPropertyValue("expression"));
            ReportEngineTest.assertEquals((String)"string", (String)scalarParameter.getUserPropertyValue("string"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportEngineTest.fail();
        }
    }

    public void testParameterDefinition() {
        try {
            org.eclipse.birt.report.engine.api.ReportEngine engine = new org.eclipse.birt.report.engine.api.ReportEngine(new EngineConfig());
            IReportRunnable runnable = engine.openReportDesign(REPORT_DESIGN);
            IGetParameterDefinitionTask paramDefnTask = engine.createGetParameterDefinitionTask(runnable);
            IParameterDefnBase paramDefn = paramDefnTask.getParameterDefn("param");
            ReportEngineTest.assertTrue((boolean)(paramDefn instanceof ScalarParameterDefn));
            ReportEngineTest.assertTrue((paramDefn.getParameterType() == 0 ? 1 : 0) != 0);
            ReportEngineTest.assertTrue((boolean)"defaultValue".equals(paramDefnTask.getDefaultValue(paramDefn)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportEngineTest.fail();
        }
    }

    public void testGetSupportedFormats() {
        try {
            org.eclipse.birt.report.engine.api.ReportEngine engine = new org.eclipse.birt.report.engine.api.ReportEngine(new EngineConfig());
            String[] supportedFormats = engine.getSupportedFormats();
            for (String key : this.supportedMap.keySet()) {
                boolean flag = true;
                int index = 0;
                while (index < supportedFormats.length) {
                    if (supportedFormats[index].equals(key)) {
                        flag = false;
                    }
                    ++index;
                }
                ReportEngineTest.assertFalse((boolean)flag);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportEngineTest.fail();
        }
    }

    public void testGetEmitterInfo() {
        try {
            org.eclipse.birt.report.engine.api.ReportEngine engine = new org.eclipse.birt.report.engine.api.ReportEngine(new EngineConfig());
            EmitterInfo[] infos = engine.getEmitterInfo();
            int index = 0;
            int size = infos.length;
            while (index < size) {
                ReportEngineTest.assertTrue((infos[index].getEmitter() != null ? 1 : 0) != 0);
                ReportEngineTest.assertTrue((infos[index].getFormat() != null && infos[index].getFormat().length() > 0 ? 1 : 0) != 0);
                ReportEngineTest.assertTrue((infos[index].getID() != null && infos[index].getID().length() > 0 ? 1 : 0) != 0);
                ReportEngineTest.assertTrue((infos[index].getMimeType() != null && infos[index].getMimeType().length() > 0 ? 1 : 0) != 0);
                ReportEngineTest.assertTrue((infos[index].getNamespace() != null && infos[index].getNamespace().length() > 0 ? 1 : 0) != 0);
                ++index;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportEngineTest.fail();
        }
    }

    public void testGetMIMEType() {
        try {
            org.eclipse.birt.report.engine.api.ReportEngine engine = new org.eclipse.birt.report.engine.api.ReportEngine(new EngineConfig());
            String[] supportedFormats = engine.getSupportedFormats();
            for (Map.Entry entry : this.supportedMap.entrySet()) {
                String value = (String)entry.getValue();
                boolean flag = true;
                int index = 0;
                while (index < supportedFormats.length) {
                    if (engine.getMIMEType(supportedFormats[index]).equals(value)) {
                        flag = false;
                    }
                    ++index;
                }
                ReportEngineTest.assertFalse((boolean)flag);
            }
            engine.destroy();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportEngineTest.fail();
        }
    }

    public void testCloseDocument() throws EngineException {
        ReportEngine engine = new ReportEngine(new EngineConfig());
        IReportDocument document1 = this.createReportDocument(engine, "reportdocument1");
        IReportDocument document2 = this.createReportDocument(engine, "reportdocument2");
        this.checkOpenedDocument(engine, document1, document2);
        document1.close();
        this.checkOpenedDocument(engine, document2);
        document2.close();
        this.checkOpenedDocument(engine, new IReportDocument[0]);
        IReportDocument document3 = this.createReportDocument(engine, "reportdocument3");
        this.checkOpenedDocument(engine, document3);
        engine.destroy();
        this.checkOpenedDocument(engine, new IReportDocument[0]);
        int i = 1;
        while (i <= 3) {
            this.removeFile("reportdocument" + i);
            ++i;
        }
    }

    private void checkOpenedDocument(ReportEngine engine, IReportDocument ... documents) {
        Iterator iterator = engine.getOpenedDocuments();
        int i = 0;
        while (i < documents.length) {
            ReportEngineTest.assertTrue((boolean)iterator.hasNext());
            ReportEngineTest.assertEquals((Object)documents[i], iterator.next());
            ++i;
        }
        ReportEngineTest.assertFalse((boolean)iterator.hasNext());
    }

    private IReportDocument createReportDocument(ReportEngine engine, String reportDocument) throws EngineException {
        IReportRunnable report = engine.openReportDesign(REPORT_DESIGN);
        try (IRunTask task = engine.createRunTask(report);){
            task.run(reportDocument);
            IReportDocument iReportDocument = engine.openReportDocument(reportDocument);
            return iReportDocument;
        }
    }

    protected void initSupportedMap() {
        String[] goldenFormats = new String[]{"html", "pdf"};
        String[] goldenMIMEType = new String[]{"text/html", "application/pdf"};
        ReportEngineTest.assertTrue((goldenFormats.length == goldenMIMEType.length ? 1 : 0) != 0);
        this.supportedMap = new HashMap();
        int size = goldenFormats.length;
        int index = 0;
        while (index < size) {
            this.supportedMap.put(goldenFormats[index], goldenMIMEType[index]);
            ++index;
        }
    }
}

