/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.filter;

import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.oda.profile.internal.ProfileCategoryUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.navigator.CommonViewer;

public class ProfileFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String odaDataSourceId = null;
        if (!(viewer instanceof CommonViewer)) {
            if (!(element instanceof CPWizardNode)) {
                return true;
            }
            String wizardProviderId = ((CPWizardNode)element).getProvider().getId();
            ICategory profileCategory = ProfileCategoryUtil.getCategory((String)wizardProviderId);
            if (profileCategory != null && wizardProviderId.equalsIgnoreCase(profileCategory.getId())) {
                odaDataSourceId = wizardProviderId;
            }
        } else if (element instanceof ICategory) {
            String categoryId;
            odaDataSourceId = categoryId = ((ICategory)element).getId();
        }
        if (odaDataSourceId == null) {
            return true;
        }
        ExtensionManifest manifest = this.getElementOdaManifest(odaDataSourceId);
        if (manifest == null) {
            return true;
        }
        return !manifest.isDeprecated() && !manifest.isWrapper();
    }

    private ExtensionManifest getElementOdaManifest(String odaDataSourceId) {
        ExtensionManifest manifest = null;
        try {
            manifest = ManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
        }
        catch (Exception exception) {}
        return manifest;
    }
}

