/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class VariableElementParseTest
extends BaseTestCase {
    private static final String FILE_NAME = "VariableElementParseTest.xml";
    private static final String DUPLICATE_NAME_FILE = "DuplicatedVariableNameTest.xml";
    private static final String VARIABLE_ELEMENT_IN_EXTENDED_ELEMENT = "VariableElementInExtendedElement.xml";

    public void testParse() throws Exception {
        this.openDesign(FILE_NAME);
        ExtendedItemHandle action1 = (ExtendedItemHandle)this.designHandle.findElement("action1");
        List variables = action1.getListProperty("variables");
        VariableElementHandle var1 = (VariableElementHandle)variables.get(0);
        VariableElementParseTest.assertEquals((String)"variable1", (String)var1.getVariableName());
        VariableElementParseTest.assertEquals((String)"expression for variable", (String)var1.getValue());
        VariableElementParseTest.assertEquals((String)"report", (String)var1.getType());
        var1.setVariableName("new variable1");
        var1.setValue("new expression for variable");
        var1.setType("page");
        this.save();
        VariableElementParseTest.assertTrue((boolean)this.compareFile("VariableElementParseTest_golden.xml"));
    }

    public void testDuplicatedVariableName() throws Exception {
        try {
            this.openDesign(DUPLICATE_NAME_FILE);
            VariableElementParseTest.fail();
        }
        catch (DesignFileException e) {
            VariableElementParseTest.assertEquals((String)"Error.DesignFileException.SYNTAX_ERROR", (String)e.getErrorCode());
        }
        this.openDesign(VARIABLE_ELEMENT_IN_EXTENDED_ELEMENT);
        VariableElementParseTest.assertNotNull((Object)this.designHandle);
    }
}

