/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.parser.ParserTestCase;

public class MultiViewParseTest
extends ParserTestCase {
    private static final String INPUT_FILE = "MultiViewParseTest.xml";
    private static final String GOLDEN_FILE = "MultiViewParseTest_golden.xml";

    public void testParser() throws Exception {
        this.openDesign(INPUT_FILE);
        TableHandle table1 = (TableHandle)this.designHandle.findElement("MyTable1");
        MultiViewsHandle view1 = (MultiViewsHandle)table1.getProperty("multiViews");
        MultiViewParseTest.assertNotNull((Object)view1);
        List views = view1.getListProperty("views");
        MultiViewParseTest.assertEquals((int)2, (int)views.size());
        ExtendedItemHandle box1 = (ExtendedItemHandle)views.get(0);
        MultiViewParseTest.assertEquals((String)"firstDataSet", (String)box1.getDataSet().getName());
        PropertyHandle prop = box1.getPropertyHandle("dataSet");
        MultiViewParseTest.assertTrue((boolean)prop.isReadOnly());
        prop = box1.getPropertyHandle("filter");
        MultiViewParseTest.assertTrue((boolean)prop.isReadOnly());
    }

    public void testWriter() throws Exception {
        this.openDesign(INPUT_FILE);
        TableHandle table2 = this.designHandle.getElementFactory().newTableItem("table2", 3);
        this.designHandle.getBody().add((DesignElementHandle)table2);
        table2.setDataSet(this.designHandle.findDataSet("firstDataSet"));
        MultiViewsHandle view2 = this.designHandle.getElementFactory().newMultiView();
        table2.getPropertyHandle("multiViews").add((DesignElementHandle)view2);
        ExtendedItemHandle box3 = this.designHandle.getElementFactory().newExtendedItem("box3", "TestingBox");
        view2.add("views", (DesignElementHandle)box3);
        view2.setCurrentViewIndex(0);
        MultiViewParseTest.assertEquals((String)"firstDataSet", (String)box3.getDataSet().getName());
        this.save();
        MultiViewParseTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE));
    }
}

