/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.AbstractMetaTest;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaDataReader;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.metadata.MetadataTestUtil;
import org.eclipse.birt.report.model.metadata.ObjectDefn;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.util.XMLParserException;

public class MetaLoggerTest
extends AbstractMetaTest {
    private IMetaLogger logger = null;
    private List errorList = null;
    private static final int METAREADER_EXCEPTION = 0;
    private static final int METADATA_EXCEPTION = 1;

    @Override
    protected void tearDown() throws Exception {
    }

    public MetaLoggerTest() {
        MetaLogManager.shutDown();
    }

    @Override
    protected void setUp() throws Exception {
        this.errorList = null;
    }

    protected void clearup() {
        if (this.logger != null) {
            MetaLogManager.removeLogger((IMetaLogger)this.logger);
        }
        this.logger = null;
    }

    private void loadMeta(String fileName) {
        block2: {
            ThreadResources.setLocale((ULocale)ULocale.getDefault());
            try {
                MetaDataDictionary.reset();
                this.loadMetaData(MetaLoggerTest.class.getResourceAsStream("input/" + fileName));
            }
            catch (MetaDataParserException e) {
                if (!(e.getException() instanceof XMLParserException)) break block2;
                this.errorList = ((XMLParserException)e.getException()).getErrorList();
            }
        }
    }

    public void test_FILE_NOT_FOUND() throws Exception {
        MetaDataDictionary.reset();
        try {
            MetaDataReader.read((String)"input/none-exsit.def");
        }
        catch (MetaDataParserException e) {
            MetaLoggerTest.assertEquals((String)"FILE_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void test_PARSER_ERROR() {
        try {
            this.loadMetaData(MetaLoggerTest.class.getResourceAsStream("input/none-exsit.def"));
        }
        catch (MetaDataParserException e) {
            MetaLoggerTest.assertEquals((String)"PARSER_ERROR", (String)e.getErrorCode());
        }
    }

    public void test_NAME_REQUIRED() {
        this.loadMeta("romTest2.def");
        MetaLoggerTest.assertEquals((int)13, (int)this.errorList.size());
    }

    public void test_DISPLAY_NAME_ID_REQUIRED() {
        this.loadMeta("romTest3.def");
        MetaLoggerTest.assertEquals((int)8, (int)this.errorList.size());
    }

    public void test_MULTIPLE_CARDINALITY_REQUIRED() {
        this.loadMeta("romTest4.def");
        MetaLoggerTest.assertEquals((int)3, (int)this.errorList.size());
        this.assertErrorCode("MULTIPLE_CARDINALITY_REQUIRED", 0, 0);
        this.assertErrorCode("MULTIPLE_CARDINALITY_REQUIRED", 1, 0);
    }

    public void test_TYPE_REQUIRED() {
        this.loadMeta("romTest5.def");
        this.assertErrorCode("TYPE_REQUIRED", 0, 0);
        this.assertErrorCode("TYPE_REQUIRED", 1, 0);
        MetaLoggerTest.assertEquals((int)3, (int)this.errorList.size());
    }

    public void test_INVALID_NAME_SPACE() {
        this.loadMeta("romTest6.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("INVALID_NAME_SPACE", 0, 0);
    }

    public void test_XML_NAME_REQUIRED() {
        this.loadMeta("romTest7.def");
        this.assertErrorCode("XML_NAME_REQUIRED", 0, 0);
        MetaLoggerTest.assertEquals((int)2, (int)this.errorList.size());
    }

    public void test_INVALID_DEFAULT() {
        this.loadMeta("romTest8.def");
        this.assertErrorCode("INVALID_DEFAULT", 0, 0);
        MetaLoggerTest.assertEquals((int)2, (int)this.errorList.size());
    }

    public void test_INVALID_TYPE() {
        this.loadMeta("romTest9.def");
        this.assertErrorCode("INVALID_TYPE", 0, 0);
        this.assertErrorCode("INVALID_TYPE", 1, 0);
        MetaLoggerTest.assertEquals((int)3, (int)this.errorList.size());
    }

    public void test_GROUP_NAME_ID_REQUIRED() {
        this.loadMeta("romTest11.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("GROUP_NAME_ID_REQUIRED", 0, 0);
    }

    public void test_INVALID_CHOICE_TYPE() {
        this.loadMeta("romTest12.def");
        MetaLoggerTest.assertEquals((int)3, (int)this.errorList.size());
        this.assertErrorCode("INVALID_CHOICE_TYPE", 0, 0);
        this.assertErrorCode("INVALID_CHOICE_TYPE", 1, 0);
    }

    public void test_CHOICE_TYPE_REQUIRED() {
        this.loadMeta("romTest13.def");
        MetaLoggerTest.assertEquals((int)3, (int)this.errorList.size());
        this.assertErrorCode("CHOICE_TYPE_REQUIRED", 0, 0);
        this.assertErrorCode("CHOICE_TYPE_REQUIRED", 1, 0);
    }

    public void test_STRUCT_TYPE_REQUIRED() {
        this.loadMeta("romTest14.def");
        MetaLoggerTest.assertEquals((int)3, (int)this.errorList.size());
        this.assertErrorCode("STRUCT_TYPE_REQUIRED", 0, 0);
        this.assertErrorCode("STRUCT_TYPE_REQUIRED", 1, 0);
    }

    public void test_INVALID_STRUCT_TYPE() {
        this.loadMeta("romTest15.def");
        MetaLoggerTest.assertEquals((int)2, (int)this.errorList.size());
        this.assertErrorCode("INVALID_STRUCT_TYPE", 0, 0);
        this.assertErrorCode("INVALID_STRUCT_TYPE", 1, 0);
    }

    public void test_ELEMENT_REF_TYPE_REQUIRED() {
        this.loadMeta("romTest16.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("ELEMENT_REF_TYPE_REQUIRED", 0, 0);
    }

    public void test_MISSING_ELEMENT_NAME() {
        ElementDefn newElement = new ElementDefn();
        try {
            MetadataTestUtil.addElementDefn((MetaDataDictionary)MetaDataDictionary.getInstance(), (ElementDefn)newElement);
            MetaLoggerTest.fail();
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"MISSING_ELEMENT_NAME", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Missing element name when adding an element to the meta-data dictionary. Error code:MISSING_ELEMENT_NAME", (String)e.getMessage().trim());
        }
    }

    public void test_DUPLICATE_ELEMENT_NAME() {
        this.loadMeta("romTest17.def");
        MetaLoggerTest.assertEquals((int)2, (int)this.errorList.size());
        this.assertErrorCode("DUPLICATE_ELEMENT_NAME", 0, 1);
        MetaDataDictionary.reset();
        ElementDefn elementA = new ElementDefn();
        MetadataTestUtil.setName((ObjectDefn)elementA, (String)"Name");
        ElementDefn elementB = new ElementDefn();
        MetadataTestUtil.setName((ObjectDefn)elementB, (String)"Name");
        try {
            MetadataTestUtil.addElementDefn((MetaDataDictionary)MetaDataDictionary.getInstance(), (ElementDefn)elementA);
            MetadataTestUtil.addElementDefn((MetaDataDictionary)MetaDataDictionary.getInstance(), (ElementDefn)elementB);
            MetaLoggerTest.fail();
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"DUPLICATE_ELEMENT_NAME", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Duplicate element names when adding the element [Name] to the meta-data dictionary. Error code:DUPLICATE_ELEMENT_NAME", (String)e.getMessage().trim());
        }
    }

    public void test_MISSING_STYLE_NAME() {
        PredefinedStyle style = new PredefinedStyle();
        try {
            MetadataTestUtil.addPredefinedStyle((MetaDataDictionary)MetaDataDictionary.getInstance(), (PredefinedStyle)style);
            MetaLoggerTest.fail();
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"MISSING_STYLE_NAME", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Missing style name when adding a predefined style to the meta-data dictionary. Error code:MISSING_STYLE_NAME", (String)e.getMessage().trim());
        }
    }

    public void test_DUPLICATE_STYLE_NAME() {
        this.loadMeta("romTest18.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("DUPLICATE_STYLE_NAME", 0, 1);
        MetaDataDictionary.reset();
        ElementDefn elementA = new ElementDefn();
        MetadataTestUtil.setName((ObjectDefn)elementA, (String)"Name");
        ElementDefn elementB = new ElementDefn();
        MetadataTestUtil.setName((ObjectDefn)elementB, (String)"Name");
        try {
            MetadataTestUtil.addElementDefn((MetaDataDictionary)MetaDataDictionary.getInstance(), (ElementDefn)elementA);
            MetadataTestUtil.addElementDefn((MetaDataDictionary)MetaDataDictionary.getInstance(), (ElementDefn)elementB);
            MetaLoggerTest.fail();
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"DUPLICATE_ELEMENT_NAME", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Duplicate element names when adding the element [Name] to the meta-data dictionary. Error code:DUPLICATE_ELEMENT_NAME", (String)e.getMessage().trim());
        }
    }

    public void test_STYLE_TYPE_MISSING() {
        this.loadMeta("romTest19.def");
        MetaLoggerTest.assertEquals((int)59, (int)this.errorList.size());
        this.assertErrorCode("STYLE_TYPE_MISSING", 0, 1);
    }

    public void test_DUPLICATE_PROPERTY() {
        this.loadMeta("romTest20.def");
        MetaLoggerTest.assertEquals((int)3, (int)this.errorList.size());
        this.assertErrorCode("DUPLICATE_PROPERTY", 0, 1);
        this.assertErrorCode("DUPLICATE_PROPERTY", 1, 1);
    }

    public void test_ELEMENT_PARENT_NOT_FOUND() {
        this.loadMeta("romTest21.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("ELEMENT_PARENT_NOT_FOUND", 0, 1);
    }

    public void test_ILLEGAL_STYLE_PROPS() {
        this.loadMeta("romTest22.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("ILLEGAL_STYLE_PROPS", 0, 1);
        this.loadMeta("romTest23.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("ILLEGAL_STYLE_PROPS", 0, 1);
    }

    public void test_ILLEGAL_ABSTRACT_ELEMENT() {
        this.loadMeta("romTest24.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("ILLEGAL_ABSTRACT_ELEMENT", 0, 1);
    }

    public void test_STYLE_PROP_NOT_FOUND() {
        this.loadMeta("romTest25.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("STYLE_PROP_NOT_FOUND", 0, 1);
    }

    public void test_PROP_TYPE_ERROR() {
        SystemPropertyDefn propDefn = new SystemPropertyDefn();
        propDefn.setName("Property1");
        try {
            MetadataTestUtil.buildPropertyDefn((PropertyDefn)propDefn);
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"PROP_TYPE_ERROR", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:PropertyType of the property [Property1] has not been set. ( propDefn.getType() == null ) Error code:PROP_TYPE_ERROR", (String)e.getMessage().trim());
        }
    }

    public void test_MISSING_PROP_CHOICES() {
        SystemPropertyDefn propDefn = new SystemPropertyDefn();
        propDefn.setName("Property1");
        propDefn.setType(MetaDataDictionary.getInstance().getPropertyType(5));
        try {
            MetadataTestUtil.buildPropertyDefn((PropertyDefn)propDefn);
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"MISSING_PROP_CHOICES", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Missing ChoiceSet for choice type property [Property1]. Error code:MISSING_PROP_CHOICES", (String)e.getMessage().trim());
        }
    }

    public void test_MISSING_SLOT_TYPE() {
        this.loadMeta("romTest26.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("MISSING_SLOT_TYPE", 0, 1);
    }

    public void test_MISSING_SLOT_NAME() {
        this.loadMeta("romTest27.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("MISSING_SLOT_NAME", 0, 1);
    }

    public void test_INVALID_SLOT_TYPE() {
        this.loadMeta("romTest28.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("INVALID_SLOT_TYPE", 0, 1);
    }

    public void test_ELEMENT_NAME_CONST() {
        this.loadMeta("romTest29.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("ELEMENT_NAME_CONST", 0, 1);
    }

    public void test_MISSING_CHOICE_SET_NAME() {
        ChoiceSet choices1 = new ChoiceSet(null);
        try {
            MetadataTestUtil.addChoiceSet((MetaDataDictionary)MetaDataDictionary.getInstance(), (ChoiceSet)choices1);
            MetaLoggerTest.fail();
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"MISSING_CHOICE_SET_NAME", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Missing choice set name when adding a Choice Set to the meta-data dictionary. Error code:MISSING_CHOICE_SET_NAME", (String)e.getMessage().trim());
        }
    }

    public void test_DUPLICATE_CHOICE_SET_NAME() {
        ChoiceSet choices1 = new ChoiceSet("choices1");
        ChoiceSet choices2 = new ChoiceSet("choices1");
        try {
            MetadataTestUtil.addChoiceSet((MetaDataDictionary)MetaDataDictionary.getInstance(), (ChoiceSet)choices1);
            MetadataTestUtil.addChoiceSet((MetaDataDictionary)MetaDataDictionary.getInstance(), (ChoiceSet)choices2);
            MetaLoggerTest.fail();
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"DUPLICATE_CHOICE_SET_NAME", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Duplicate choice set names when adding the choice set [choices1] to the meta-data dictionary. Error code:DUPLICATE_CHOICE_SET_NAME", (String)e.getMessage().trim());
        }
    }

    public void test_MISSING_STRUCT_NAME() {
        StructureDefn structDefn = new StructureDefn(null);
        try {
            MetadataTestUtil.addStructureDefn((MetaDataDictionary)MetaDataDictionary.getInstance(), (StructureDefn)structDefn);
            MetaLoggerTest.fail();
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"MISSING_STRUCT_NAME", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Missing structure name when adding a structure to the meta-data dictionary. Error code:MISSING_STRUCT_NAME", (String)e.getMessage().trim());
        }
    }

    public void test_DUPLICATE_STRUCT_NAME() {
        StructureDefn structDefn1 = new StructureDefn("struct");
        StructureDefn structDefn2 = new StructureDefn("struct");
        try {
            MetadataTestUtil.addStructureDefn((MetaDataDictionary)MetaDataDictionary.getInstance(), (StructureDefn)structDefn1);
            MetadataTestUtil.addStructureDefn((MetaDataDictionary)MetaDataDictionary.getInstance(), (StructureDefn)structDefn2);
            MetaLoggerTest.fail();
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"DUPLICATE_STRUCT_NAME", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Duplicate structure names when adding the structure [struct] to the meta-data dictionary. Error code:DUPLICATE_STRUCT_NAME", (String)e.getMessage().trim());
        }
    }

    public void test_MISSING_STRUCT_DEFN() {
        this.loadMeta("rom.def");
        SystemPropertyDefn prop = new SystemPropertyDefn();
        prop.setName("prop1");
        prop.setType(MetaDataDictionary.getInstance().getPropertyType(16));
        prop.setDetails(null);
        prop.setOwner((ObjectDefn)((ElementDefn)MetaDataDictionary.getInstance().getElement("Table")));
        try {
            MetadataTestUtil.buildPropertyDefn((PropertyDefn)prop);
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"MISSING_STRUCT_DEFN", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Missing structure definition for structure list type property [prop1] in [Table]. Error code:MISSING_STRUCT_DEFN", (String)e.getMessage().trim());
        }
    }

    public void test_MISSING_ELEMENT_TYPE() {
        SystemPropertyDefn prop = new SystemPropertyDefn();
        prop.setName("prop1");
        prop.setType(MetaDataDictionary.getInstance().getPropertyType(15));
        prop.setDetails(null);
        try {
            MetadataTestUtil.buildPropertyDefn((PropertyDefn)prop);
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"MISSING_ELEMENT_TYPE", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Missing element type for elementRef property [prop1]. Error code:MISSING_ELEMENT_TYPE", (String)e.getMessage().trim());
        }
    }

    public void test_UNDEFINED_ELEMENT_TYPE() {
        SystemPropertyDefn prop = new SystemPropertyDefn();
        prop.setName("prop1");
        prop.setType(MetaDataDictionary.getInstance().getPropertyType(15));
        prop.setDetails((Object)"none-exsit-element-ref");
        try {
            MetadataTestUtil.buildPropertyDefn((PropertyDefn)prop);
        }
        catch (MetaDataException e) {
            MetaLoggerTest.assertEquals((String)"UNDEFINED_ELEMENT_TYPE", (String)e.getErrorCode());
            MetaLoggerTest.assertEquals((String)"Message:Element [none-exsit-element-ref] specified by property [prop1] is not defined. Error code:UNDEFINED_ELEMENT_TYPE", (String)e.getMessage().trim());
        }
    }

    public void test_UNNAMED_ELEMENT_TYPE() {
        this.loadMeta("romTest30.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("UNNAMED_ELEMENT_TYPE", 0, 1);
    }

    public void test_INCONSISTENT_PROP_TYPE() {
        this.loadMeta("romTest31.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("INCONSISTENT_PROP_TYPE", 0, 1);
    }

    public void test_MISSING_JAVA_CLASS() {
        this.loadMeta("romTest32.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("MISSING_JAVA_CLASS", 0, 1);
    }

    public void test_JAVA_CLASS_INITIALIZE_ERROR() {
        this.loadMeta("romTest33.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("JAVA_CLASS_INITIALIZE_ERROR", 0, 1);
    }

    public void test_JAVA_CLASS_JAVA_CLASS_LOAD_ERROR() {
        this.loadMeta("romTest34.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("JAVA_CLASS_LOAD_ERROR", 0, 1);
    }

    public void test_INVALID_ELEMENT_JAVA_CLASS() {
        this.loadMeta("romTest35.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("INVALID_ELEMENT_JAVA_CLASS", 0, 1);
    }

    public void test_DUPLICATE_METHOD_NAME() {
        this.loadMeta("romTest36.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("DUPLICATE_ELEMENT_NAME", 0, 1);
    }

    public void test_DUPLICATE_ARGUMENT_NAME() {
        this.loadMeta("romTest37.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("DUPLICATE_ARGUMENT_NAME", 0, 1);
    }

    public void test_RESTRICTION_NOT_ALLOWED() {
        this.loadMeta("romTest38.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("RESTRICTION_NOT_ALLOWED", 0, 0);
    }

    public void test_INVALID_RESTRICTION() {
        this.loadMeta("romTest39.def");
        MetaLoggerTest.assertEquals((int)2, (int)this.errorList.size());
        this.assertErrorCode("INVALID_RESTRICTION", 0, 0);
        this.assertErrorCode("INVALID_RESTRICTION", 1, 0);
    }

    public void test_INVALID_DEFAULT_VALUE() {
        this.loadMeta("romTest40.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("INVALID_DEFAULT_VALUE", 0, 1);
    }

    public void test_INVALID_DEFAULT_VALUE2() {
        this.loadMeta("romTest41.def");
        MetaLoggerTest.assertEquals((int)1, (int)this.errorList.size());
        this.assertErrorCode("INVALID_DEFAULT_VALUE", 0, 1);
    }

    private void assertErrorCode(String expected, int index, int type) {
        assert (type == 0 || type == 1);
        this.assertErrorCode(expected, index, index, type);
    }

    private void assertErrorCode(String expected, int from, int to, int type) {
        assert (this.errorList.size() > to);
        assert (from <= to);
        assert (from >= 0);
        int i = from;
        while (i < to) {
            if (type == 0) {
                MetaLoggerTest.assertEquals((String)expected, (String)((MetaDataParserException)((Object)this.errorList.get(i))).getErrorCode());
            } else if (type == 1) {
                MetaLoggerTest.assertEquals((String)expected, (String)((MetaDataException)((Object)((MetaDataParserException)((Object)this.errorList.get(i))).getException())).getErrorCode());
            }
            ++i;
        }
    }
}

