/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetParserException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StyleSheetLoaderTest
extends BaseTestCase {
    private String fileName = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        SessionHandle session = new DesignEngine(new DesignConfig()).newSessionHandle(null);
        this.designHandle = session.createDesign();
    }

    private CssStyleSheetHandle loadStyleSheet(String fileName) throws Exception {
        fileName = "input/" + (String)fileName;
        InputStream is = this.getResourceAStream((String)fileName);
        return this.designHandle.openCssStyleSheet(is);
    }

    public void testCssStyleSheetFileName() throws Exception {
        this.openDesign("BlankStyleSheetLoaderTest.xml");
        this.fileName = "base.css";
        CssStyleSheetHandle sheetHandle = this.designHandle.openCssStyleSheet(this.fileName);
        StyleSheetLoaderTest.assertEquals((String)"base.css", (String)sheetHandle.getFileName());
    }

    public void testParserForAllProperties() throws Exception {
        this.fileName = "base.css";
        Iterator styles = this.loadStyleSheet(this.fileName).getStyleIterator();
        StyleHandle style1 = (StyleHandle)styles.next();
        StyleHandle style2 = (StyleHandle)styles.next();
        StyleHandle style3 = (StyleHandle)styles.next();
        StyleSheetLoaderTest.assertFalse((boolean)styles.hasNext());
        StyleSheetLoaderTest.assertEquals((String)"fullstyle", (String)style1.getName());
        StyleSheetLoaderTest.assertEquals((String)"table", (String)style2.getName());
        StyleSheetLoaderTest.assertEquals((String)"\"Bitstream Vera Sans\", \"Tahoma\", \"Verdana\", \"Myriad Web\", \"Syntax\", sans-serif", (String)style1.getFontFamilyHandle().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"2em", (String)style1.getFontSize().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"italic", (String)style1.getFontStyle());
        StyleSheetLoaderTest.assertEquals((String)"small-caps", (String)style1.getFontVariant());
        StyleSheetLoaderTest.assertEquals((String)"bold", (String)style1.getFontWeight());
        StyleSheetLoaderTest.assertEquals((String)"justify", (String)style1.getTextAlign());
        StyleSheetLoaderTest.assertEquals((String)"2em", (String)style1.getTextIndent().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"underline", (String)style1.getTextUnderline());
        StyleSheetLoaderTest.assertEquals((String)"overline", (String)style1.getTextOverline());
        StyleSheetLoaderTest.assertEquals((String)"line-through", (String)style1.getTextLineThrough());
        StyleSheetLoaderTest.assertEquals((String)"1pt", (String)style1.getLetterSpacing().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"2pt", (String)style1.getWordSpacing().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"uppercase", (String)style1.getTextTransform());
        StyleSheetLoaderTest.assertEquals((String)"pre", (String)style1.getWhiteSpace());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style1.getMarginBottom().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style1.getMarginLeft().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style1.getMarginRight().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style1.getMarginTop().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style1.getPaddingBottom().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style1.getPaddingLeft().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style1.getPaddingRight().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style1.getPaddingTop().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"#004F93", (String)style1.getColor().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"black", (String)style1.getBackgroundColor().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"images/header", (String)style1.getBackgroundImage());
        StyleSheetLoaderTest.assertEquals((String)"no-repeat", (String)style1.getBackgroundRepeat());
        StyleSheetLoaderTest.assertEquals((String)"scroll", (String)style1.getBackgroundAttachment());
        StyleSheetLoaderTest.assertEquals((String)"50%", (String)style1.getBackGroundPositionX().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"top", (String)style1.getBackGroundPositionY().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1", (String)style1.getOrphans());
        StyleSheetLoaderTest.assertEquals((String)"3", (String)style1.getWidows());
        StyleSheetLoaderTest.assertEquals((String)"inline", (String)style1.getDisplay());
        StyleSheetLoaderTest.assertEquals((String)"always", (String)style1.getPageBreakBefore());
        StyleSheetLoaderTest.assertEquals((String)"always", (String)style1.getPageBreakAfter());
        StyleSheetLoaderTest.assertEquals((String)"auto", (String)style1.getPageBreakInside());
        StyleSheetLoaderTest.assertEquals((String)"middle", (String)style1.getVerticalAlign());
        StyleSheetLoaderTest.assertEquals((String)"120%", (String)style1.getLineHeight().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"#445566", (String)style1.getBorderBottomColor().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"solid", (String)style1.getBorderBottomStyle());
        StyleSheetLoaderTest.assertEquals((String)"10px", (String)style1.getBorderBottomWidth().getDisplayValue());
        StyleSheetLoaderTest.assertEquals((String)"test", (String)style3.getName());
        StyleSheetLoaderTest.assertEquals((String)"contain", (String)style3.getBackgroundWidth().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"auto", (String)style3.getBackgroundHeight().getStringValue());
    }

    public void testStyleIterator() throws Exception {
        this.fileName = "base.css";
        CssStyleSheetHandle styleSheetHandle = this.loadStyleSheet(this.fileName);
        StyleSheetLoaderTest.assertNotNull((Object)styleSheetHandle);
        Iterator iter = styleSheetHandle.getStyleIterator();
        int i = 0;
        while (iter.hasNext()) {
            SharedStyleHandle styleHandle = (SharedStyleHandle)iter.next();
            switch (i++) {
                case 0: {
                    StyleSheetLoaderTest.assertEquals((String)"fullstyle", (String)styleHandle.getName());
                    break;
                }
                case 1: {
                    StyleSheetLoaderTest.assertEquals((String)"table", (String)styleHandle.getName());
                }
            }
        }
    }

    public void testStyleIterator1() throws Exception {
        this.fileName = "base1.css";
        CssStyleSheetHandle styleSheetHandle = this.loadStyleSheet(this.fileName);
        StyleSheetLoaderTest.assertNotNull((Object)styleSheetHandle);
        Iterator iter = styleSheetHandle.getStyleIterator();
        int i = 0;
        while (iter.hasNext()) {
            SharedStyleHandle styleHandle = (SharedStyleHandle)iter.next();
            switch (i++) {
                case 0: {
                    StyleSheetLoaderTest.assertEquals((String)"test4", (String)styleHandle.getName());
                    break;
                }
                case 1: {
                    StyleSheetLoaderTest.assertEquals((String)"test6", (String)styleHandle.getName());
                }
            }
        }
    }

    public void testWrongAtKeyWord() throws Exception {
        this.fileName = "wrong_1.css";
        Iterator styles = this.loadStyleSheet(this.fileName).getStyleIterator();
        StyleSheetLoaderTest.assertNotNull(styles.next());
        StyleSheetLoaderTest.assertFalse((boolean)styles.hasNext());
    }

    public void testWrongSelector() throws Exception {
        this.fileName = "wrong_2.css";
        Iterator styles = this.loadStyleSheet(this.fileName).getStyleIterator();
        StyleSheetLoaderTest.assertNotNull(styles.next());
        StyleSheetLoaderTest.assertFalse((boolean)styles.hasNext());
    }

    public void testPropertyCombination() throws Exception {
        this.fileName = "property_combination.css";
        Iterator styles = this.loadStyleSheet(this.fileName).getStyleIterator();
        this.isSame(styles, "fontFamily", "\"Bitstream Vera Sans\", \"Tahoma\", \"Verdana\", \"Myriad Web\", \"Syntax\", sans-serif");
        this.isSame(styles, "fontSize", "2em");
        this.isSame(styles, "fontStyle", "italic");
        this.isSame(styles, "fontVariant", "small-caps");
        this.isSame(styles, "fontWeight", "bold");
    }

    public void testShortHand() throws Exception {
        this.fileName = "property_shorthand.css";
        Iterator styles = this.loadStyleSheet(this.fileName).getStyleIterator();
        StyleHandle style = (StyleHandle)styles.next();
        StyleSheetLoaderTest.assertEquals((String)"table", (String)style.getName());
        StyleSheetLoaderTest.assertFalse((boolean)styles.hasNext());
        StyleSheetLoaderTest.assertEquals((String)"\"Bitstream Vera Sans\", \"Tahoma\", \"Verdana\", \"Myriad Web\", \"Syntax\", sans-serif", (String)style.getFontFamilyHandle().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"2em", (String)style.getFontSize().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"italic", (String)style.getFontStyle());
        StyleSheetLoaderTest.assertEquals((String)"small-caps", (String)style.getFontVariant());
        StyleSheetLoaderTest.assertEquals((String)"bold", (String)style.getFontWeight());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style.getMarginBottom().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style.getMarginLeft().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style.getMarginRight().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style.getMarginTop().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style.getPaddingBottom().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style.getPaddingLeft().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style.getPaddingRight().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"1em", (String)style.getPaddingTop().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"black", (String)style.getBackgroundColor().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"images/header", (String)style.getBackgroundImage());
        StyleSheetLoaderTest.assertEquals((String)"no-repeat", (String)style.getBackgroundRepeat());
        StyleSheetLoaderTest.assertEquals((String)"scroll", (String)style.getBackgroundAttachment());
        StyleSheetLoaderTest.assertEquals((String)"50%", (String)style.getBackGroundPositionX().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"top", (String)style.getBackGroundPositionY().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"120%", (String)style.getLineHeight().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"#445566", (String)style.getBorderBottomColor().getStringValue());
        StyleSheetLoaderTest.assertEquals((String)"solid", (String)style.getBorderBottomStyle());
        StyleSheetLoaderTest.assertEquals((String)"10px", (String)style.getBorderBottomWidth().getStringValue());
    }

    public void testWarnings() throws Exception {
        this.fileName = "wrong.css";
        CssStyleSheetHandle styleSheet = this.loadStyleSheet(this.fileName);
        Iterator styles = styleSheet.getStyleIterator();
        StyleHandle style = (StyleHandle)styles.next();
        StyleSheetLoaderTest.assertEquals((String)"fullstyle", (String)style.getName());
        List errors = styleSheet.getWarnings(style.getName());
        StyleSheetLoaderTest.assertEquals((int)4, (int)errors.size());
        StyleSheetParserException e = (StyleSheetParserException)errors.get(0);
        StyleSheetLoaderTest.assertEquals((String)"Error.StyleSheetParserException.INVALID_SHORT_HAND_CSSPROPERTY_VALUE", (String)e.getErrorCode());
        StyleSheetLoaderTest.assertEquals((String)"font", (String)e.getCSSPropertyName());
        StyleSheetLoaderTest.assertEquals((String)"2em small-caps \"Bitstream Vera Sans\", Tahoma, Verdana, \"Myriad Web\", Syntax, sans-serif", (String)e.getCSSValue());
        e = (StyleSheetParserException)errors.get(1);
        StyleSheetLoaderTest.assertEquals((String)"Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", (String)e.getErrorCode());
        StyleSheetLoaderTest.assertEquals((String)"background-image", (String)e.getCSSPropertyName());
        StyleSheetLoaderTest.assertEquals((String)"u(images/header)", (String)e.getCSSValue());
        e = (StyleSheetParserException)errors.get(2);
        StyleSheetLoaderTest.assertEquals((String)"Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", (String)e.getErrorCode());
        StyleSheetLoaderTest.assertEquals((String)"background-size", (String)e.getCSSPropertyName());
        StyleSheetLoaderTest.assertEquals((String)"test1", (String)e.getCSSValue());
        e = (StyleSheetParserException)errors.get(3);
        StyleSheetLoaderTest.assertEquals((String)"Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", (String)e.getErrorCode());
        StyleSheetLoaderTest.assertEquals((String)"background-size", (String)e.getCSSPropertyName());
        StyleSheetLoaderTest.assertEquals((String)"test2", (String)e.getCSSValue());
        style = (StyleHandle)styles.next();
        StyleSheetLoaderTest.assertEquals((String)"table", (String)style.getName());
        errors = styleSheet.getWarnings(style.getName());
        StyleSheetLoaderTest.assertEquals((int)5, (int)errors.size());
        e = (StyleSheetParserException)errors.get(4);
        StyleSheetLoaderTest.assertEquals((String)"Error.StyleSheetParserException.PROPERTY_NOT_SUPPORTED", (String)e.getErrorCode());
        StyleSheetLoaderTest.assertEquals((String)"wrongproperty", (String)e.getCSSPropertyName());
        StyleSheetLoaderTest.assertEquals((String)"value", (String)e.getCSSValue());
        List unsupportedStyles = styleSheet.getUnsupportedStyles();
        StyleSheetLoaderTest.assertEquals((String)"table:link", (String)((String)unsupportedStyles.get(0)));
    }

    public void testParserErrors() throws Exception {
        this.fileName = "wrong_3.css";
        CssStyleSheetHandle styleSheet = this.loadStyleSheet(this.fileName);
        List warnings = styleSheet.getStyleSheet().getWarnings();
        StyleSheetLoaderTest.assertEquals((int)1, (int)warnings.size());
        StyleSheetLoaderTest.assertEquals((String)"org.eclipse.birt.report.model.api.css.StyleSheetParserException: The style \"wrong_style\" is not supported.", (String)warnings.get(0).toString());
        StyleSheetLoaderTest.assertEquals((int)0, (int)styleSheet.getParserFatalErrors().size());
        StyleSheetLoaderTest.assertEquals((int)0, (int)styleSheet.getParserErrors().size());
    }

    private void isSame(Iterator<StyleHandle> styles, String propName, Object value) {
        while (styles.hasNext()) {
            StyleHandle style = styles.next();
            StyleSheetLoaderTest.assertEquals((Object)value, (Object)style.getStringProperty(propName));
        }
    }
}

