/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class SlotHandleTest
extends BaseTestCase {
    String fileName = "Improved_test4.xml";

    public SlotHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(SlotHandleTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        this.removeResource();
        this.copyResource_INPUT(this.fileName, this.fileName);
        SessionHandle sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = sessionHandle.createDesign();
        this.design = this.designHandle.getDesign();
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testcanContainGroupName() throws SemanticException {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = this.sessionHandle.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle table = factory.newTableItem("table", 1);
        TableGroupHandle tableGroup = table.getElementFactory().newTableGroup();
        tableGroup.setName("Group1");
        SlotHandle slot = table.getSlot(1);
        SlotHandleTest.assertTrue((boolean)slot.canContain((DesignElementHandle)tableGroup));
        table.getGroups().add((DesignElementHandle)tableGroup);
        SlotHandleTest.assertFalse((boolean)slot.canContain((DesignElementHandle)tableGroup));
        tableGroup = table.getElementFactory().newTableGroup();
        tableGroup.setName("Group2");
        SlotHandleTest.assertTrue((boolean)slot.canContain((DesignElementHandle)tableGroup));
    }

    public void testcanContainSimpleMasterPage() throws Exception {
        this.openDesign(this.fileName);
        SimpleMasterPageHandle mHandle = (SimpleMasterPageHandle)this.designHandle.findMasterPage("Page1");
        SlotHandleTest.assertNotNull((String)"should not be null", (Object)mHandle);
        SlotHandle slot = mHandle.getPageHeader();
        GridHandle grid = mHandle.getElementFactory().newGridItem("grid");
        SlotHandleTest.assertEquals((int)1, (int)slot.getCount());
        SlotHandleTest.assertEquals((String)"text_1", (String)slot.get(0).getName());
        SlotHandleTest.assertFalse((boolean)slot.canContain((DesignElementHandle)grid));
        slot = mHandle.getPageFooter();
        SlotHandleTest.assertEquals((int)1, (int)slot.getCount());
        SlotHandleTest.assertEquals((String)"text_2", (String)slot.get(0).getName());
        SlotHandleTest.assertFalse((boolean)slot.canContain((DesignElementHandle)grid));
    }
}

