/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.RepositoryBundleContainer;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.shared.target.EditRepositoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.IEditBundleContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class SelectRepositoryContentPage
extends WizardPage
implements IEditBundleContainerPage {
    private final EditRepositoryContainerPage repositoryPage;
    private String lastLocation;
    private CheckboxTableViewer viewer;
    private Collection<Requirement> requirements;
    private final Set<Resource> selected = ConcurrentHashMap.newKeySet();

    protected SelectRepositoryContentPage(EditRepositoryContainerPage repositoryPage) {
        super("SelectRepositoryContentPage");
        this.repositoryPage = repositoryPage;
        this.setTitle(Messages.SelectRepositoryContentPage_Title);
        this.setDescription(Messages.SelectRepositoryContentPage_Description);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            try {
                String location;
                RepositoryBundleContainer container = this.repositoryPage.getBundleContainer();
                if (this.requirements == null) {
                    this.requirements = new HashSet<Requirement>(container.getRequirements());
                }
                if (this.lastLocation != (location = container.getLocation(true))) {
                    this.getContainer().run(true, true, monitor -> {
                        try {
                            ResourcesRepository repository = container.getRepository(monitor);
                            this.selected.clear();
                            List resources = repository.getResources();
                            repository.findProviders(this.requirements).values().stream().flatMap(Collection::stream).map(Capability::getResource).distinct().forEach(this.selected::add);
                            if (this.viewer != null) {
                                this.viewer.getControl().getDisplay().execute(() -> {
                                    if (this.viewer.getControl().isDisposed()) {
                                        return;
                                    }
                                    this.viewer.setInput((Object)resources);
                                });
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                this.setErrorMessage(null);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getStatus().getMessage());
            }
            catch (InvocationTargetException e) {
                this.setErrorMessage(e.getMessage());
            }
            catch (InterruptedException e) {
                return;
            }
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof Resource) {
                    Resource resource = (Resource)element;
                    return SelectRepositoryContentPage.this.selected.contains(resource);
                }
                return false;
            }
        });
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private Image pluginImage;

            public String getText(Object element) {
                if (element instanceof Resource) {
                    Resource resource = (Resource)element;
                    return resource.toString();
                }
                return "";
            }

            public Image getImage(Object element) {
                Resource resource;
                if (element instanceof Resource && ResourceUtils.getBundleCapability((Resource)(resource = (Resource)element)) != null) {
                    if (this.pluginImage == null) {
                        this.pluginImage = PDEPluginImages.DESC_PLUGIN_OBJ.createImage();
                        SelectRepositoryContentPage.this.viewer.getControl().addDisposeListener(e -> this.pluginImage.dispose());
                    }
                    return this.pluginImage;
                }
                return null;
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Resource resource;
                Requirement requirement;
                Object element = event.getElement();
                if (element instanceof Resource && (requirement = SelectRepositoryContentPage.this.getRequirement(resource = (Resource)element)) != null) {
                    if (event.getChecked()) {
                        SelectRepositoryContentPage.this.selected.add(resource);
                        SelectRepositoryContentPage.this.requirements.add(requirement);
                    } else {
                        SelectRepositoryContentPage.this.selected.remove(resource);
                        SelectRepositoryContentPage.this.requirements.remove(requirement);
                    }
                }
            }
        });
        this.setControl(this.viewer.getControl());
    }

    protected Requirement getRequirement(Resource resource) {
        ResourceUtils.IdentityCapability identity = ResourceUtils.getIdentityCapability((Resource)resource);
        String v = identity.version().toString();
        return CapReqBuilder.createSimpleRequirement((String)identity.getNamespace(), (String)identity.osgi_identity(), (String)String.format("[%s,%s]", v, v)).setResource(resource).buildRequirement();
    }

    @Override
    public ITargetLocation getBundleContainer() {
        RepositoryBundleContainer container = this.repositoryPage.getBundleContainer();
        return new RepositoryBundleContainer(container.getUri(), this.requirements == null ? container.getRequirements() : List.copyOf(this.requirements));
    }

    @Override
    public void storeSettings() {
    }
}

