/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import junit.framework.TestCase;
import org.eclipse.birt.report.designer.util.FixTableLayoutCalculator;

public class FixTableLayoutCalculatorTest
extends TestCase {
    FixTableLayoutCalculator calculator;

    protected void setUp() throws Exception {
        this.calculator = new FixTableLayoutCalculator();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCalWidthCase1() {
        String[] width = new String[]{"33", "33", "34"};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.doCheck();
    }

    private void doCheck() {
        float amt = 0.0f;
        int[] width = this.calculator.getIntColWidth();
        int i = 0;
        while (i < width.length) {
            amt += (float)width[i];
            System.out.println("the result is " + width[i]);
            ++i;
        }
        System.out.println("the difference is " + (amt - 100.0f));
        FixTableLayoutCalculatorTest.assertFalse((Math.abs(amt - 100.0f) > 1.0f ? 1 : 0) != 0);
    }

    private void doCheck(float minSize, float tableWidth) {
        int[] width = this.calculator.getIntColWidth();
        if (!(minSize * (float)width.length > tableWidth)) {
            this.doCheck();
        } else {
            float amt = 0.0f;
            int i = 0;
            while (i < width.length) {
                amt += (float)width[i];
                System.out.println("the result is " + width[i]);
                ++i;
            }
        }
    }

    public void testCalWidthCase2() {
        String[] width = new String[]{"33", "33", "33"};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.doCheck();
    }

    public void testCalWidthCase3() {
        String[] width = new String[]{"40%", "20", "20"};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.doCheck();
    }

    public void testCalWidthCase4() {
        String[] width = new String[]{"40%", "40%", "20%"};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.doCheck();
    }

    public void testCalWidthCase5() {
        String[] width = new String[]{"40%", "30", "20%"};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.doCheck();
    }

    public void testCalWidthCase6() {
        String[] width = new String[]{"40", "", "90"};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(6.0f);
        this.doCheck();
    }

    public void testCalWidthCase7() {
        String[] width = new String[]{"40%", "90%", "30%"};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(20.0f);
        this.doCheck();
    }

    public void testCalWidthCase8() {
        String[] width = new String[]{"20%", "20%", ""};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(3.0f);
        this.doCheck();
    }

    public void testCalWidthCase9() {
        String[] width = new String[]{"20", "20", ""};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(5.0f);
        this.doCheck();
    }

    public void testCalWidthCase10() {
        String[] width = new String[]{"20", "20", "", "20", "20", "", "20", "20", ""};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(10.0f);
        this.doCheck();
    }

    public void testCalWidthCase11() {
        String[] width = new String[]{"3", "3", "", "20%", "10%", "", "10%", "20", ""};
        this.calculator.setTableWidth(10.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(10.0f);
        this.doCheck(10.0f, 10.0f);
    }

    public void testCalWidthCase12() {
        String[] width = new String[]{"3.3333", "3.3332", "11.9098"};
        this.calculator.setTableWidth(100.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(10.0f);
        this.doCheck(10.0f, 10.0f);
    }

    public void testCalWidthCase13() {
        String[] width = new String[]{"3.3333", "3.3332", "11.9098"};
        this.calculator.setTableWidth(19.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(10.0f);
        this.doCheck(10.0f, 10.0f);
    }

    public void testCalWidthCase14() {
        String[] width = new String[]{"3.3333a", "3.3332", "11.9098"};
        this.calculator.setTableWidth(19.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(10.0f);
        try {
            this.doCheck(10.0f, 10.0f);
            FixTableLayoutCalculatorTest.fail((String)"shoule catch the exception");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void testCalWidthCase15() {
        String[] width = new String[]{"20", "30", "11.9098"};
        this.calculator.setTableWidth(30.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(15.0f);
        try {
            this.doCheck(10.0f, 10.0f);
        }
        catch (NumberFormatException e) {
            FixTableLayoutCalculatorTest.fail((String)"catch the exception");
            e.printStackTrace();
        }
    }

    public void testCalWidthCase16() {
        String[] width = new String[]{"20", "30", "11.9098"};
        this.calculator.setTableWidth(0.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(15.0f);
        try {
            this.doCheck(10.0f, 10.0f);
        }
        catch (NumberFormatException e) {
            FixTableLayoutCalculatorTest.fail((String)"catch the exception");
            e.printStackTrace();
        }
    }

    public void testCalWidthCase17() {
        String[] width = new String[]{"20", "30", "40"};
        this.calculator.setTableWidth(0.0f);
        this.calculator.setDefinedColWidth(width);
        this.calculator.setColMinSize(15.0f);
        try {
            this.doCheck(10.0f, 10.0f);
        }
        catch (NumberFormatException e) {
            FixTableLayoutCalculatorTest.fail((String)"catch the exception");
            e.printStackTrace();
        }
    }
}

