/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.util.IOUtil;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class IOUtilTest
extends TestCase {
    private Object[] testValues;

    public IOUtilTest() {
        Object[] objectArray = new Object[14];
        objectArray[0] = new Integer(1);
        objectArray[1] = new Float(1.0f);
        objectArray[2] = new Double(1.0);
        objectArray[3] = new BigDecimal("1.12");
        objectArray[4] = new Timestamp(System.currentTimeMillis());
        objectArray[5] = new Time(System.currentTimeMillis());
        objectArray[6] = new Date(System.currentTimeMillis());
        objectArray[7] = new Boolean(false);
        objectArray[8] = "This is a test";
        objectArray[9] = new byte[0];
        objectArray[10] = new byte[]{1, 2, 3};
        objectArray[11] = new ArrayList();
        objectArray[12] = new HashMap();
        this.testValues = objectArray;
    }

    @Test
    public void testRWInt() throws IOException {
        int[] nArray = new int[5];
        nArray[0] = 1;
        nArray[1] = 1000;
        nArray[3] = -1;
        nArray[4] = -1000;
        int[] testValues = nArray;
        int size = 1000;
        ByteArrayOutputStream bos = null;
        byte[] content = null;
        ByteArrayInputStream bis = null;
        int i = 0;
        while (i < testValues.length) {
            bos = new ByteArrayOutputStream(1000);
            IOUtil.writeInt((OutputStream)bos, (int)testValues[i]);
            content = bos.toByteArray();
            bis = new ByteArrayInputStream(content);
            IOUtilTest.assertEquals((int)testValues[i], (int)IOUtil.readInt((InputStream)bis));
            ++i;
        }
    }

    @Test
    public void testRWBool() throws IOException {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] testValues = blArray;
        int size = 1000;
        ByteArrayOutputStream bos = null;
        byte[] content = null;
        ByteArrayInputStream bis = null;
        int i = 0;
        while (i < testValues.length) {
            bos = new ByteArrayOutputStream(1000);
            IOUtil.writeBool((OutputStream)bos, (boolean)testValues[i]);
            content = bos.toByteArray();
            bis = new ByteArrayInputStream(content);
            IOUtilTest.assertEquals((boolean)testValues[i], (boolean)IOUtil.readBool((InputStream)bis));
            ++i;
        }
    }

    @Test
    public void testRWFloat() throws IOException {
        float[] testValues = new float[]{1.1f, 0.0f, -1.0f, -1.1f};
        int size = 1000;
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        byte[] content = null;
        ByteArrayInputStream bis = null;
        DataInputStream dis = null;
        int i = 0;
        while (i < testValues.length) {
            bos = new ByteArrayOutputStream(1000);
            dos = new DataOutputStream(bos);
            IOUtil.writeFloat((DataOutputStream)dos, (float)testValues[i]);
            content = bos.toByteArray();
            bis = new ByteArrayInputStream(content);
            dis = new DataInputStream(bis);
            IOUtilTest.assertEquals((Object)new Float(testValues[i]), (Object)new Float(IOUtil.readFloat((DataInputStream)dis)));
            ++i;
        }
    }

    @Test
    public void testRWDouble() throws IOException {
        double[] testValues = new double[]{1.1, 0.0, -1.0, -1.1};
        int size = 1000;
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        byte[] content = null;
        ByteArrayInputStream bis = null;
        DataInputStream dis = null;
        int i = 0;
        while (i < testValues.length) {
            bos = new ByteArrayOutputStream(1000);
            dos = new DataOutputStream(bos);
            IOUtil.writeDouble((DataOutputStream)dos, (double)testValues[i]);
            content = bos.toByteArray();
            bis = new ByteArrayInputStream(content);
            dis = new DataInputStream(bis);
            IOUtilTest.assertEquals((Object)new Double(testValues[i]), (Object)new Double(IOUtil.readDouble((DataInputStream)dis)));
            ++i;
        }
    }

    @Test
    public void testRWLong() throws IOException {
        long[] lArray = new long[4];
        lArray[0] = 1L;
        lArray[1] = 1000L;
        lArray[3] = -1L;
        long[] testValues = lArray;
        int size = 1000;
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        byte[] content = null;
        ByteArrayInputStream bis = null;
        DataInputStream dis = null;
        int i = 0;
        while (i < testValues.length) {
            bos = new ByteArrayOutputStream(1000);
            dos = new DataOutputStream(bos);
            IOUtil.writeLong((DataOutputStream)dos, (long)testValues[i]);
            content = bos.toByteArray();
            bis = new ByteArrayInputStream(content);
            dis = new DataInputStream(bis);
            IOUtilTest.assertEquals((long)testValues[i], (long)IOUtil.readLong((DataInputStream)dis));
            ++i;
        }
    }

    @Test
    public void testRWString() throws IOException {
        String[] stringArray = new String[5];
        stringArray[1] = "";
        stringArray[2] = "G";
        stringArray[3] = "GU";
        stringArray[4] = "GUI";
        String[] testValues = stringArray;
        int size = 1000;
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        byte[] content = null;
        ByteArrayInputStream bis = null;
        DataInputStream dis = null;
        int i = 0;
        while (i < testValues.length) {
            bos = new ByteArrayOutputStream(1000);
            dos = new DataOutputStream(bos);
            IOUtil.writeString((DataOutputStream)dos, (String)testValues[i]);
            content = bos.toByteArray();
            bis = new ByteArrayInputStream(content);
            dis = new DataInputStream(bis);
            IOUtilTest.assertEquals((String)testValues[i], (String)IOUtil.readString((DataInputStream)dis));
            ++i;
        }
    }

    @Test
    public void testRWBytes() throws IOException {
        byte[] testValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        int size = 1000;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        DataOutputStream dos = new DataOutputStream(bos);
        IOUtil.writeBytes((DataOutputStream)dos, (byte[])testValues);
        byte[] content = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        DataInputStream dis = new DataInputStream(bis);
        byte[] readValues = IOUtil.readBytes((DataInputStream)dis);
        IOUtilTest.assertEquals((int)testValues.length, (int)readValues.length);
        int i = 0;
        while (i < testValues.length) {
            IOUtilTest.assertEquals((byte)testValues[i], (byte)readValues[i]);
            ++i;
        }
    }

    @Test
    public void testRWObject() throws IOException {
        int size = 1000;
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        byte[] content = null;
        ByteArrayInputStream bis = null;
        DataInputStream dis = null;
        int i = 0;
        while (i < this.testValues.length) {
            bos = new ByteArrayOutputStream(1000);
            dos = new DataOutputStream(bos);
            IOUtil.writeObject((DataOutputStream)dos, (Object)this.testValues[i]);
            content = bos.toByteArray();
            bis = new ByteArrayInputStream(content);
            dis = new DataInputStream(bis);
            if (!(this.testValues[i] instanceof byte[])) {
                IOUtilTest.assertEquals((Object)this.testValues[i], (Object)IOUtil.readObject((DataInputStream)dis));
            } else {
                byte[] bytes = (byte[])this.testValues[i];
                byte[] readBytes = (byte[])IOUtil.readObject((DataInputStream)dis);
                int j = 0;
                while (j < bytes.length) {
                    IOUtilTest.assertEquals((byte)bytes[j], (byte)readBytes[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    @Test
    public void testRWLongString() throws IOException, FileNotFoundException {
        String begin = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdThe first several words for test";
        StringBuilder buffer = new StringBuilder(begin);
        int i = 1;
        while (i < 65537) {
            buffer.append(i);
            ++i;
        }
        boolean correct = true;
        int size = 600000;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(600000);
        DataOutputStream dos = new DataOutputStream(bos);
        IOUtil.writeString((DataOutputStream)dos, (String)buffer.toString());
        byte[] content = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        DataInputStream dis = new DataInputStream(bis);
        String ret = IOUtil.readString((DataInputStream)dis);
        StringBuilder buf = new StringBuilder(ret);
        if (buf.length() != buffer.length()) {
            correct = false;
        } else {
            int i2 = 1;
            while (i2 < buf.length()) {
                if (buffer.charAt(i2) != buf.charAt(i2)) {
                    correct = false;
                    break;
                }
                ++i2;
            }
        }
        IOUtilTest.assertTrue((String)"I/O failed!!", (boolean)correct);
        int size2 = 600005;
        bos = new ByteArrayOutputStream(600005);
        dos = new DataOutputStream(bos);
        IOUtil.writeObject((DataOutputStream)dos, (Object)ret);
        content = bos.toByteArray();
        bis = new ByteArrayInputStream(content);
        dis = new DataInputStream(bis);
        Object obj = IOUtil.readObject((DataInputStream)dis);
        IOUtilTest.assertTrue((String)"IOUtil test failed!!", (boolean)((String)obj).startsWith(begin));
        buf = new StringBuilder((String)obj);
        if (buf.length() != buffer.length()) {
            correct = false;
        } else {
            int i3 = 1;
            while (i3 < buf.length()) {
                if (buffer.charAt(i3) != buf.charAt(i3)) {
                    correct = false;
                    break;
                }
                ++i3;
            }
        }
        IOUtilTest.assertTrue((String)"IOUtil test failed!!", (boolean)correct);
    }

    @Test
    public void testRWList() throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < this.testValues.length) {
            list.add(this.testValues[i]);
            ++i;
        }
        int size = 1000;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        DataOutputStream dos = new DataOutputStream(bos);
        IOUtil.writeList((DataOutputStream)dos, list);
        byte[] content = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        DataInputStream dis = new DataInputStream(bis);
        List readList = IOUtil.readList((DataInputStream)dis);
        IOUtilTest.assertTrue((readList != null ? 1 : 0) != 0);
        IOUtilTest.assertTrue((list.size() == readList.size() ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < this.testValues.length) {
            if (!(this.testValues[i2] instanceof byte[])) {
                IOUtilTest.assertEquals((Object)this.testValues[i2], readList.get(i2));
            } else {
                byte[] bytes = (byte[])this.testValues[i2];
                byte[] readBytes = (byte[])readList.get(i2);
                int j = 0;
                while (j < bytes.length) {
                    IOUtilTest.assertEquals((byte)bytes[j], (byte)readBytes[j]);
                    ++j;
                }
            }
            ++i2;
        }
    }

    @Test
    public void testRWMap() throws IOException {
        Object[] testKeys = this.testValues;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int i = 0;
        while (i < this.testValues.length) {
            map.put(testKeys[i], this.testValues[i]);
            ++i;
        }
        int size = 1000;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        DataOutputStream dos = new DataOutputStream(bos);
        IOUtil.writeMap((DataOutputStream)dos, map);
        byte[] content = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        DataInputStream dis = new DataInputStream(bis);
        Map readMap = IOUtil.readMap((DataInputStream)dis);
        IOUtilTest.assertTrue((readMap != null ? 1 : 0) != 0);
        for (Map.Entry ob : map.entrySet()) {
            Object value = map.get(ob);
            Object readValue = readMap.get(ob);
            if (!(value instanceof byte[])) {
                IOUtilTest.assertEquals(value, readValue);
                continue;
            }
            byte[] bytes = (byte[])value;
            byte[] readBytes = (byte[])readValue;
            int j = 0;
            while (j < bytes.length) {
                IOUtilTest.assertEquals((byte)bytes[j], (byte)readBytes[j]);
                ++j;
            }
        }
    }

    @Test
    public void testNativeDate() throws IOException {
        int size = 1000;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        DataOutputStream dos = new DataOutputStream(bos);
        Context cx = Context.enter();
        ImporterTopLevel sharedScope = new ImporterTopLevel(cx);
        Object ob = cx.evaluateString((Scriptable)sharedScope, "new Date", null, -1, null);
        IOUtil.writeObject((DataOutputStream)dos, (Object)ob);
        byte[] content = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        DataInputStream dis = new DataInputStream(bis);
        Object ob2 = IOUtil.readObject((DataInputStream)dis);
        IOUtilTest.assertTrue((boolean)(ob instanceof IdScriptableObject));
        IOUtilTest.assertTrue((boolean)(ob2 instanceof IdScriptableObject));
        IOUtilTest.assertEquals((Object)JavascriptEvalUtil.convertJavascriptValue((Object)ob), (Object)JavascriptEvalUtil.convertJavascriptValue((Object)ob2));
        Context.exit();
    }

    @Test
    public void testNativeJavaObject() throws IOException {
        int size = 1000;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        DataOutputStream dos = new DataOutputStream(bos);
        Context cx = Context.enter();
        ImporterTopLevel sharedScope = new ImporterTopLevel(cx);
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("key1", "value1");
        source.put("key2", "value2");
        Object ob = Context.javaToJS(source, (Scriptable)sharedScope);
        IOUtil.writeObject((DataOutputStream)dos, (Object)ob);
        byte[] content = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        DataInputStream dis = new DataInputStream(bis);
        Object ob2 = IOUtil.readObject((DataInputStream)dis);
        IOUtilTest.assertTrue((boolean)(ob2 instanceof HashMap));
        IOUtilTest.assertEquals(source, (Object)ob2);
        Context.exit();
    }
}

