/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.ArchiveUtilTest;
import org.eclipse.birt.core.archive.FolderArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FolderToArchiveTest
extends TestCase {
    private String[] entryNames = new String[]{"/.metadata", "/abc.txt", "/abc.txt/abc.txt", "/d:/dataset%%20.txt", "//host/e:/../<>|$@.", "//", "///"};

    @Before
    @After
    public void removeDirectory() {
        ArchiveUtil.deleteAllFiles((File)new File("./utest"));
    }

    @Test
    public void testSave() throws IOException {
        this.createFolderArchive("utest/test.folder");
        ArchiveUtil.convertFolderArchive((String)"utest/test.folder", (String)"utest/test.archive");
        this.checkArchive("utest/test.archive");
    }

    private void createFolderArchive(String folder) throws IOException {
        ArchiveUtilTest.removeFile(new File(folder));
        try (FolderArchiveFile archive = new FolderArchiveFile(folder);){
            archive.setSystemId("systemId");
            archive.setDependId("dependedId");
            String[] stringArray = this.entryNames;
            int n = this.entryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String entryName = stringArray[n2];
                try (ArchiveEntry entry = archive.createEntry(entryName);){
                    byte[] bytes = entryName.getBytes("utf-8");
                    entry.write(0L, bytes, 0, bytes.length);
                }
                ++n2;
            }
        }
    }

    private void checkArchive(String file) throws IOException {
        try (ArchiveFile af = new ArchiveFile(file, "r");){
            FolderToArchiveTest.assertEquals((String)"systemId", (String)af.getSystemId());
            FolderToArchiveTest.assertEquals((String)"dependedId", (String)af.getDependId());
            List entries = af.listEntries("/");
            FolderToArchiveTest.assertEquals((int)this.entryNames.length, (int)entries.size());
            String[] stringArray = this.entryNames;
            int n = this.entryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String entryName = stringArray[n2];
                try (ArchiveEntry entry = af.openEntry(entryName);){
                    byte[] golden = entryName.getBytes("utf-8");
                    FolderToArchiveTest.assertEquals((long)golden.length, (long)entry.getLength());
                    byte[] bytes = new byte[golden.length];
                    entry.read(0L, bytes, 0, bytes.length);
                    Assert.assertArrayEquals((byte[])golden, (byte[])bytes);
                }
                ++n2;
            }
        }
    }
}

