/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.script.model;

import java.io.File;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugElement;
import org.eclipse.birt.report.debug.internal.script.model.ScriptLineBreakpoint;
import org.eclipse.birt.report.debug.internal.script.model.ScriptValue;
import org.eclipse.birt.report.debug.internal.ui.script.editor.DebugJsInput;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.sourcelookup.ScriptLocalFileStorage;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorInput;

public class ScriptModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    private static final String EDITOR_ID = "org.eclipse.birt.report.debug.internal.ui.script.editor.DebugJsEditor";

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getValueString();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        listener.detailComputed(value, detail);
    }

    public void setAttribute(String attribute, Object value) {
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof ScriptLocalFileStorage || element instanceof ILineBreakpoint) {
            return EDITOR_ID;
        }
        return null;
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof ScriptLocalFileStorage) {
            ScriptLocalFileStorage storage = (ScriptLocalFileStorage)((Object)element);
            return new DebugJsInput(storage.getFile(), storage.getModelIdentifier());
        }
        if (element instanceof ScriptLineBreakpoint) {
            ScriptLineBreakpoint breakPoint = (ScriptLineBreakpoint)((Object)element);
            String str = breakPoint.getFileName();
            return new DebugJsInput(new File(str), breakPoint.getSubName());
        }
        return null;
    }

    public String getText(Object element) {
        try {
            if (element instanceof ScriptDebugElement) {
                return ((ScriptDebugElement)((Object)element)).getDisplayName();
            }
            if (element instanceof IExpression) {
                return this.getExpressionText((IExpression)element);
            }
            if (element instanceof ScriptLineBreakpoint) {
                ScriptLineBreakpoint breakPoint = (ScriptLineBreakpoint)((Object)element);
                int index = breakPoint.getFileName().lastIndexOf(File.separator);
                String str = breakPoint.getFileName().substring(index + 1);
                return str + " [line: " + breakPoint.getScriptLineNumber() + "] - " + breakPoint.getDisplayName();
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return super.getText(element);
    }

    private String getExpressionText(IExpression expression) throws DebugException {
        String valueString;
        StringBuilder buff = new StringBuilder();
        IValue javaValue = expression.getValue();
        buff.append("\"" + expression.getExpressionText() + "\"");
        if (javaValue != null && (valueString = this.getValueText(javaValue)).length() > 0) {
            buff.append("= ");
            buff.append(valueString);
        }
        return buff.toString();
    }

    private String getValueText(IValue value) throws DebugException {
        String refTypeName = value.getReferenceTypeName();
        String valueString = value.getValueString();
        boolean isString = false;
        StringBuilder buffer = new StringBuilder();
        if (!isString && refTypeName.length() > 0) {
            String qualTypeName = refTypeName;
            buffer.append(qualTypeName);
            buffer.append(' ');
        }
        if (valueString != null && (isString || valueString.length() > 0)) {
            if (isString) {
                buffer.append('\"');
            }
            buffer.append(valueString);
            if (isString) {
                buffer.append('\"');
            }
        }
        return buffer.toString();
    }

    public String getVariableText(ScriptValue var) {
        try {
            return var.getValueString();
        }
        catch (DebugException e) {
            return null;
        }
    }
}

