/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.actions.NoneAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public abstract class MenuUpdateAction
extends SelectionAction {
    private MenuManager menu;
    private List actionItems;

    public MenuUpdateAction(IWorkbenchPart part) {
        super(part);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Action [" + String.valueOf(((Object)((Object)this)).getClass()) + "] >> Run ...");
        }
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() == null) {
            return;
        }
        if (this.menu != null) {
            this.actionItems = this.getItems();
            this.menu.removeAll();
            for (DynamicItemAction action : this.actionItems) {
                if (action != null) {
                    action.setSelection(this.getSelection());
                    this.menu.add((IAction)action);
                    continue;
                }
                this.menu.add((IContributionItem)new Separator());
            }
            if (this.menu.getItems().length == 0) {
                this.menu.add((IAction)NoneAction.getInstance());
            }
            this.menu.update(true);
        }
    }

    public void updateMenu(MenuManager menu) {
        this.menu = menu;
        this.run();
    }

    protected abstract List getItems();

    public static abstract class DynamicItemAction
    extends Action {
        protected Logger logger = Logger.getLogger(DynamicItemAction.class.getName());
        private ISelection selection;

        protected DynamicItemAction() {
        }

        protected DynamicItemAction(String text) {
            super(text);
        }

        protected DynamicItemAction(String text, int style) {
            super(text, style);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        protected ISelection getSelection() {
            return this.selection;
        }
    }
}

