/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.script;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.script.JSCompletionProcessor;
import org.eclipse.birt.report.designer.internal.ui.script.JSScanner;
import org.eclipse.birt.report.designer.internal.ui.script.JSSyntaxContext;
import org.eclipse.birt.report.designer.internal.ui.script.NonRuleBasedDamagerRepairer;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;

public class JSSourceViewerConfiguration
extends SourceViewerConfiguration {
    private RuleBasedScanner scanner;
    protected JSSyntaxContext context;

    public JSSourceViewerConfiguration() {
        this(new JSSyntaxContext());
    }

    public JSSourceViewerConfiguration(JSSyntaxContext context) {
        this.context = context;
    }

    public static Color getColorByCategory(String categoryColor) {
        return JSSourceViewerConfiguration.getRgbString(categoryColor);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__js_comment", "__js_keyword", "__js_string", "__js_method", "__js_object"};
    }

    protected RuleBasedScanner getDefaultScanner() {
        if (this.scanner == null) {
            this.scanner = new JSScanner();
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)UIUtil.getAttributeFor("org.eclipse.birt.report.designer.ui.preference.expression.content.color.preferencestore")));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer commentRepairer = new NonRuleBasedDamagerRepairer(UIUtil.getAttributeFor("org.eclipse.birt.report.designer.ui.preference.expression.comment.color.preferencestore"));
        reconciler.setDamager((IPresentationDamager)commentRepairer, "__js_comment");
        reconciler.setRepairer((IPresentationRepairer)commentRepairer, "__js_comment");
        NonRuleBasedDamagerRepairer stringRepairer = new NonRuleBasedDamagerRepairer(UIUtil.getAttributeFor("org.eclipse.birt.report.designer.ui.preference.expression.string.color.preferencestore"));
        reconciler.setDamager((IPresentationDamager)stringRepairer, "__js_string");
        reconciler.setRepairer((IPresentationRepairer)stringRepairer, "__js_string");
        NonRuleBasedDamagerRepairer keywordRepairer = new NonRuleBasedDamagerRepairer(UIUtil.getAttributeFor("org.eclipse.birt.report.designer.ui.preference.expression.keyword.color.preferencestore"));
        reconciler.setDamager((IPresentationDamager)keywordRepairer, "__js_keyword");
        reconciler.setRepairer((IPresentationRepairer)keywordRepairer, "__js_keyword");
        NonRuleBasedDamagerRepairer methodRepairer = new NonRuleBasedDamagerRepairer(UIUtil.getAttributeFor("org.eclipse.birt.report.designer.ui.preference.expression.method.color.preferencestore"));
        reconciler.setDamager((IPresentationDamager)methodRepairer, "__js_method");
        reconciler.setRepairer((IPresentationRepairer)methodRepairer, "__js_method");
        NonRuleBasedDamagerRepairer objectRepairer = new NonRuleBasedDamagerRepairer(UIUtil.getAttributeFor("org.eclipse.birt.report.designer.ui.preference.expression.object.color.preferencestore"));
        reconciler.setDamager((IPresentationDamager)objectRepairer, "__js_object");
        reconciler.setRepairer((IPresentationRepairer)objectRepairer, "__js_object");
        return reconciler;
    }

    private static Color getRgbString(String name) {
        if ("commentColor".equals(name)) {
            return ReportColorConstants.JSCOMMENTCOLOR;
        }
        if ("stringColor".equals(name)) {
            return ReportColorConstants.JSSTRINGCOLOR;
        }
        if ("keywordColor".equals(name)) {
            return ReportColorConstants.JSKEYWORDCOLOR;
        }
        if ("methodColor".equals(name)) {
            return ReportColorConstants.JSMETHODCOLOR;
        }
        if ("objectColor".equals(name)) {
            return ReportColorConstants.JSOBJECTCOLOR;
        }
        if ("linenumberColor".equals(name)) {
            return ReportColorConstants.JSLINENUMBERCOLOR;
        }
        return ReportColorConstants.ReportForeground;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new JSCompletionProcessor(this.context), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        return assistant;
    }

    public void resetScannerColor() {
        if (this.scanner != null) {
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)UIUtil.getAttributeFor("org.eclipse.birt.report.designer.ui.preference.expression.content.color.preferencestore")));
        }
    }

    public static void updateSourceFont(SourceViewer sourceViewer) {
        sourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
    }
}

