/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ReportDesignHandleTest
extends BaseTestCase {
    public ReportDesignHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ReportDesignHandleTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/ReportDesignHandleTest.xml");
        this.copyInputToFile("input/ReportDesignHandleTest_css.xml");
        this.copyInputToFile("input/ReportDesignHandleTest_css1.css");
        this.openDesign("ReportDesignHandleTest.xml");
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testReportDesignOtherMethods() {
        ReportDesignHandleTest.assertFalse((boolean)this.designHandle.isEnableACL());
        try {
            this.designHandle.setEnableACL(true);
        }
        catch (SemanticException e) {
            e.printStackTrace();
        }
        ReportDesignHandleTest.assertTrue((boolean)this.designHandle.isEnableACL());
    }

    public void testFindCssHandle() throws DesignFileException {
        this.openDesign("ReportDesignHandleTest_css.xml");
        IncludedCssStyleSheetHandle includeCssHandle = this.designHandle.findIncludedCssStyleSheetHandleByFileName("ReportDesignHandleTest_css.css");
        ReportDesignHandleTest.assertNotNull((Object)includeCssHandle);
        ReportDesignHandleTest.assertEquals((String)"ReportDesignHandleTest_css.css", (String)includeCssHandle.getFileName());
        CssStyleSheetHandle cssHandle = this.designHandle.findCssStyleSheetHandleByFileName("ReportDesignHandleTest_css.css");
        ReportDesignHandleTest.assertNull((Object)cssHandle);
        cssHandle = this.designHandle.findCssStyleSheetHandleByFileName("ReportDesignHandleTest_css1.css");
        ReportDesignHandleTest.assertNotNull((Object)cssHandle);
        ReportDesignHandleTest.assertEquals((String)"ReportDesignHandleTest_css1.css", (String)cssHandle.getFileName());
        includeCssHandle = this.designHandle.findIncludedCssStyleSheetHandleByFileName("test2.css");
        ReportDesignHandleTest.assertNull((Object)includeCssHandle);
        cssHandle = this.designHandle.findCssStyleSheetHandleByFileName("test2.css");
        ReportDesignHandleTest.assertNull((Object)cssHandle);
    }
}

