/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_123377
extends BaseTestCase {
    private static final String INPUT1 = "regression_123377_lib1.xml";
    private static final String INPUT2 = "regression_123377_lib2.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/regression_123377_lib1.xml");
        this.copyInputToFile("input/regression_123377_lib2.xml");
    }

    public void test_regression_123377() throws DesignFileException, SemanticException, IOException {
        String lib1Input = this.getTempFolder() + "/input/regression_123377_lib1.xml";
        String lib2Input = this.getTempFolder() + "/input/regression_123377_lib2.xml";
        String lib1Output = this.genOutputFile(INPUT1);
        String lib2Output = this.genOutputFile(INPUT2);
        this.copyFile(lib1Input, lib1Output);
        this.copyFile(lib2Input, lib2Output);
        SessionHandle sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        LibraryHandle lib1 = sessionHandle.openLibrary(lib1Output);
        LibraryHandle lib2 = sessionHandle.openLibrary(lib2Output);
        lib1.includeLibrary(this.getTempFolder() + "/input/regression_123377_lib1.xml", "regression_123377_lib2");
        lib1.saveAs(INPUT1);
    }
}

