/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class TableItemHandleTest
extends BaseTestCase {
    public TableItemHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TableItemHandleTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSuppressDuplicatesProp() throws Exception {
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = session.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        RowHandle row = this.designHandle.getElementFactory().newTableRow(3);
        TableItemHandleTest.assertFalse((boolean)row.suppressDuplicates());
        row.setSuppressDuplicates(true);
        TableItemHandleTest.assertTrue((boolean)row.suppressDuplicates());
        this.designHandle.getCommandStack().undo();
        TableItemHandleTest.assertFalse((boolean)row.suppressDuplicates());
        this.designHandle.getCommandStack().redo();
        TableItemHandleTest.assertTrue((boolean)row.suppressDuplicates());
    }

    public void testACL_table() throws SemanticException {
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = session.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        TableHandle table1 = this.designHandle.getElementFactory().newTableItem("table1", 1, 1, 1, 1);
        this.designHandle.getBody().add((DesignElementHandle)table1);
        String acl = "rule1";
        table1.setACLExpression(acl);
        table1.setCascadeACL(true);
        TableItemHandleTest.assertTrue((boolean)table1.cascadeACL());
        TableItemHandleTest.assertEquals((String)acl, (String)table1.getACLExpression());
    }
}

