/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.GradientImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.MarkerLineImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_94138
extends ChartTestCase {
    private static String GOLDEN = "Reg_94138.jpg";
    private static String OUTPUT = "Reg_94138.jpg";
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_94138();
    }

    public Regression_94138() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_94138.createBarChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void test_regression_94138() throws Exception {
        Regression_94138 st = new Regression_94138();
        Regression_94138.assertTrue((boolean)st.compareImages(GOLDEN, OUTPUT));
    }

    public static final Chart createBarChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.setType("Bar Chart");
        cwaBar.getTitle().getLabel().getCaption().setValue("\u6d4b\u8bd5");
        cwaBar.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot p = cwaBar.getPlot();
        p.getOutline().setStyle(LineStyle.DASH_DOTTED_LITERAL);
        p.getOutline().setColor(ColorDefinitionImpl.create((int)214, (int)100, (int)12));
        p.getOutline().setVisible(true);
        p.setBackground((Fill)ColorDefinitionImpl.CREAM());
        p.setAnchor(Anchor.NORTH_LITERAL);
        p.getClientArea().setBackground((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)0, (int)255), (ColorDefinition)ColorDefinitionImpl.create((int)255, (int)253, (int)200), (double)-35.0, (boolean)false));
        p.getClientArea().getOutline().setVisible(true);
        Legend lg = cwaBar.getLegend();
        lg.getText().getFont().setSize(16.0f);
        lg.getInsets().set(10.0, 5.0, 0.0, 0.0);
        lg.getOutline().setStyle(LineStyle.DOTTED_LITERAL);
        lg.getOutline().setColor(ColorDefinitionImpl.create((int)214, (int)100, (int)12));
        lg.getOutline().setVisible(true);
        lg.setBackground((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (ColorDefinition)ColorDefinitionImpl.create((int)255, (int)255, (int)225), (double)-35.0, (boolean)false));
        lg.setAnchor(Anchor.SOUTH_LITERAL);
        lg.setItemType(LegendItemType.SERIES_LITERAL);
        lg.getClientArea().setBackground((Fill)ColorDefinitionImpl.ORANGE());
        lg.setPosition(Position.BELOW_LITERAL);
        lg.setOrientation(Orientation.HORIZONTAL_LITERAL);
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        xAxisPrimary.getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)17, (int)37, (int)223), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Sales Growth");
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        yAxisPrimary.setPercent(true);
        MarkerLine ml = MarkerLineImpl.create((Axis)yAxisPrimary, (DataElement)NumberDataElementImpl.create((double)60.0));
        ml.setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)17, (int)37, (int)223), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56});
        NumberDataSet dsNumericValues2 = NumberDataSetImpl.create((Object)new double[]{15.29, -14.53, -47.05, 32.55});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsStringValue);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        BarSeries bs = (BarSeries)BarSeriesImpl.create();
        bs.setSeriesIdentifier((Object)"Actuate");
        bs.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        bs.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        bs.getLabel().setVisible(true);
        bs.setDataSet((DataSet)dsNumericValues1);
        bs.setStacked(true);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.GREEN());
        sdY.getSeries().add((Object)bs);
        BarSeries bs2 = (BarSeries)BarSeriesImpl.create();
        bs2.setSeriesIdentifier((Object)"Micorsoft");
        bs2.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        bs2.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        bs2.getLabel().setVisible(true);
        bs2.setDataSet((DataSet)dsNumericValues2);
        bs2.setStacked(true);
        SeriesDefinition sdY2 = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY2);
        sdY2.getSeriesPalette().update((Fill)ColorDefinitionImpl.YELLOW());
        sdY2.getSeries().add((Object)bs2);
        return cwaBar;
    }
}

