/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer.testutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class TraceLogTesterUtil {
    private static TraceLogTesterUtil sm_instance = null;

    public static TraceLogTesterUtil getInstance() {
        if (sm_instance == null) {
            sm_instance = new TraceLogTesterUtil();
        }
        return sm_instance;
    }

    private TraceLogTesterUtil() {
    }

    String findInstallationDirectory(String dataSourceId) {
        String extensionPoint = "org.eclipse.datatools.connectivity.oda.dataSource";
        return this.findInstallationDirectory(dataSourceId, "org.eclipse.datatools.connectivity.oda.dataSource");
    }

    String findInstallationDirectory(String dataSourceId, String extensionPoint) {
        URL url;
        try {
            ExtensionManifest manifest = ManifestExplorer.getInstance().getExtensionManifest(dataSourceId, extensionPoint);
            url = manifest.getDriverLocation();
        }
        catch (Exception e) {
            return "./";
        }
        return url != null ? url.getPath() : "./";
    }

    public boolean matchLogPatternsInFile(String fileName, String[] patterns) throws IOException {
        BufferedReader fileBufReader = new BufferedReader(new FileReader(fileName));
        boolean foundMatch = false;
        int i = 0;
        while (i < patterns.length) {
            String line;
            String logPatternStr = "[0-9]+\t[^\t]+\t\t" + patterns[i] + "[^\t]+";
            Pattern searchPattern = Pattern.compile(logPatternStr);
            foundMatch = false;
            while (!foundMatch && (line = fileBufReader.readLine()) != null) {
                foundMatch = searchPattern.matcher(line).matches();
            }
            if (!foundMatch) {
                fileBufReader.close();
                return false;
            }
            ++i;
        }
        fileBufReader.close();
        return foundMatch;
    }

    public void clearDirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            boolean deleted = files[i].delete();
            if (!deleted) {
                throw new IOException("Cannot delete file: " + files[i].getName());
            }
            ++i;
        }
    }
}

