/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JarFile;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.ui.PlatformUI;

public class JdbcDriverConfigUtil {
    static {
        Map map = Utility.getPreferenceStoredMap("Deleted Jar List");
        Set entrySet = map.entrySet();
        Iterator it = entrySet.iterator();
        if (it.hasNext()) {
            Map.Entry entry2 = it.next();
            for (Map.Entry entry2 : entrySet) {
                JarFile jarFile = (JarFile)entry2.getValue();
                jarFile.deleteJarFromODADir();
            }
        }
        Utility.setPreferenceStoredMap("Deleted Jar List", new HashMap());
    }

    private JdbcDriverConfigUtil() {
    }

    public static List getDriverFiles() {
        try {
            List fileList = OdaJdbcDriver.getDriverFileList();
            Map deletedJars = Utility.getPreferenceStoredMap("Deleted Jar List");
            ArrayList<File> filteredFileList = new ArrayList<File>();
            int i = 0;
            while (i < fileList.size()) {
                File f = (File)fileList.get(i);
                if (!deletedJars.containsKey(f.getName())) {
                    filteredFileList.add(f);
                }
                ++i;
            }
            return filteredFileList;
        }
        catch (IOException | OdaException e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
            return null;
        }
    }
}

