/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.util.StringUtil;

public abstract class ReferenceValue {
    public static final String NAMESPACE_DELIMITER = ".";
    String libraryNamespace;
    String name;
    Object resolved;

    public ReferenceValue(String namespace, String theName) {
        assert (theName != null);
        this.name = theName;
        this.libraryNamespace = namespace;
    }

    public ReferenceValue(String namespace, Object value) {
        assert (value != null);
        this.resolved = value;
        this.libraryNamespace = namespace;
    }

    public abstract String getName();

    public abstract void resolve(Object var1);

    public void unresolved(String theName) {
        this.resolved = null;
        this.name = theName;
    }

    public boolean isResolved() {
        assert (this.name == null || this.resolved == null);
        return this.resolved != null;
    }

    public boolean isSet() {
        return this.name != null || this.resolved != null;
    }

    public String getLibraryNamespace() {
        return this.libraryNamespace;
    }

    public String getQualifiedReference() {
        return StringUtil.buildQualifiedReference(this.getLibraryNamespace(), this.getName());
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getQualifiedReference();
        }
        return super.toString();
    }

    public void setLibraryNamespace(String libraryNamespace) {
        this.libraryNamespace = libraryNamespace;
    }

    public abstract Object copy();
}

