/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.ParameterMetaData;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParameterMetaDataTest {
    private Connection conn = null;
    private Statement stmt = null;
    private ParameterMetaData Pmd = null;
    private java.sql.Connection jdbcConn = null;
    private PreparedStatement jdbcPreparedStmt = null;
    private java.sql.ParameterMetaData jdbcPmd = null;

    @Before
    public void parameterMetaDataSetUp() throws Exception {
        TestUtil.createTestData();
        String sql = "insert into \"test_oda_jdbc\" values(?,?,?,?,?,?,?)";
        Date datenow = new Date(System.currentTimeMillis());
        Time timenow = new Time(System.currentTimeMillis());
        Timestamp timestampnow = new Timestamp(System.currentTimeMillis());
        this.conn = TestUtil.openConnection();
        this.stmt = (Statement)this.conn.newQuery("");
        this.stmt.prepare(sql);
        this.stmt.setBigDecimal(1, new BigDecimal(0));
        this.stmt.setDate(2, datenow);
        this.stmt.setDouble(3, 1.01);
        this.stmt.setInt(4, 11);
        this.stmt.setString(5, "0asdas");
        this.stmt.setTime(6, timenow);
        this.stmt.setTimestamp(7, timestampnow);
        this.stmt.execute();
        this.Pmd = (ParameterMetaData)this.stmt.getParameterMetaData();
        this.jdbcConn = TestUtil.openJDBCConnection();
        this.jdbcPreparedStmt = this.jdbcConn.prepareStatement(sql);
        this.jdbcPreparedStmt.setBigDecimal(1, new BigDecimal(110));
        this.jdbcPreparedStmt.setDate(2, datenow);
        this.jdbcPreparedStmt.setDouble(3, 1.012);
        this.jdbcPreparedStmt.setInt(4, 111);
        this.jdbcPreparedStmt.setString(5, "asdasd");
        this.jdbcPreparedStmt.setTime(6, timenow);
        this.jdbcPreparedStmt.setTimestamp(7, timestampnow);
        this.jdbcPreparedStmt.execute();
        this.jdbcPmd = this.jdbcPreparedStmt.getParameterMetaData();
    }

    @After
    public void parameterMetaDataTearDown() throws Exception {
        this.conn.close();
        this.stmt.close();
        this.jdbcConn.close();
        this.jdbcPreparedStmt.close();
        TestUtil.deleteTestData();
    }

    @Test
    public void testGetParameterCount() throws Exception {
        Assert.assertEquals((long)this.Pmd.getParameterCount(), (long)this.jdbcPmd.getParameterCount());
    }

    @Test
    public void testGetParameterMode() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            Assert.assertEquals((long)this.Pmd.getParameterMode(i), (long)this.jdbcPmd.getParameterMode(i));
            ++i;
        }
    }

    @Test
    public void testGetParameterType() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            Assert.assertEquals((long)this.Pmd.getParameterType(i), (long)this.jdbcPmd.getParameterType(i));
            ++i;
        }
    }

    @Test
    public void testGetParameterTypeName() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            Assert.assertEquals((Object)this.Pmd.getParameterTypeName(i), (Object)this.jdbcPmd.getParameterTypeName(i));
            ++i;
        }
    }

    @Test
    public void testGetPrecision() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            Assert.assertEquals((long)this.Pmd.getPrecision(i), (long)this.jdbcPmd.getPrecision(i));
            ++i;
        }
    }

    @Test
    public void testGetScale() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            Assert.assertEquals((long)this.Pmd.getScale(i), (long)this.jdbcPmd.getScale(i));
            ++i;
        }
    }

    @Test
    public void testIsNullable() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            int result = 2;
            if (this.Pmd.isNullable(i) == 2) {
                result = 1;
            }
            if (this.Pmd.isNullable(i) == 1) {
                result = 0;
            }
            Assert.assertEquals((long)result, (long)this.jdbcPmd.isNullable(i));
            ++i;
        }
    }
}

