/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.junit.Assert;
import org.junit.Test;
import testutil.ConfigText;

public class QueryCacheTest
extends APITestCase {
    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Binding.TestData.TableName"), ConfigText.getString("Binding.TestData.TableSQL"), ConfigText.getString("Binding.TestData.TestDataFileName"));
    }

    @Test
    public void testBasicCache() throws Exception {
        QueryDefinition query = new QueryDefinition(true);
        query.setDataSetName(this.dataSet.getName());
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        this.outputQueryResult(it, new String[]{"CITY", "AMOUNT"});
        this.checkOutputFile();
    }

    @Test
    public void testBasicCache1() throws Exception {
        QueryDefinition query = new QueryDefinition(true);
        query.setDataSetName(this.dataSet.getName());
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        Assert.assertEquals((Object)it.getValue("CITY"), (Object)"Beijing");
        Assert.assertEquals((Object)it.getValue("AMOUNT"), (Object)7000);
        it.next();
        Assert.assertEquals((Object)it.getValue("CITY"), (Object)"Beijing");
        Assert.assertEquals((Object)it.getValue("AMOUNT"), (Object)7000);
        it.next();
        Assert.assertEquals((Object)it.getValue("CITY"), (Object)"New York");
        Assert.assertEquals((Object)it.getValue("AMOUNT"), (Object)100);
    }

    @Test
    public void testCacheEmptyResultSet() throws Exception {
        QueryDefinition query = new QueryDefinition(true);
        query.setDataSetName(this.dataSet.getName());
        query.setCacheQueryResults(true);
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        queryResults.getResultIterator().close();
    }

    @Test
    public void testCacheEmptyResultSet1() throws Exception {
        QueryDefinition query = new QueryDefinition(true);
        query.setDataSetName(this.dataSet.getName());
        query.setCacheQueryResults(true);
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        Assert.assertEquals((Object)it.getValue("CITY"), null);
        Assert.assertEquals((Object)it.getValue("AMOUNT"), null);
        Assert.assertEquals((Object)it.next(), (Object)false);
    }

    @Test
    public void testSubqueryCache() throws Exception {
        QueryDefinition query = new QueryDefinition(true);
        query.setDataSetName(this.dataSet.getName());
        query.setCacheQueryResults(true);
        SubqueryDefinition sub = new SubqueryDefinition("test", (IBaseQueryDefinition)query);
        sub.setApplyOnGroupFlag(false);
        query.addSubquery(sub);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        IResultIterator it = queryResults.getResultIterator();
        while (it.next()) {
            it.getSecondaryIterator(new ScriptContext(), "test").close();
        }
        it.close();
        String id = queryResults.getID();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        newQuery.addSubquery(sub);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        while (it.next()) {
            IResultIterator subIt = it.getSecondaryIterator(new ScriptContext(), "test");
            while (subIt.next()) {
            }
            subIt.close();
        }
        it.close();
    }

    @Test
    public void testUseDetailsCache() throws Exception {
        QueryDefinition query = new QueryDefinition(true);
        query.setDataSetName(this.dataSet.getName());
        query.setCacheQueryResults(true);
        query.setUsesDetails(false);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        this.outputQueryResult(result.getResultIterator(), new String[]{"CITY", "AMOUNT"});
        this.checkOutputFile();
    }

    @Test
    public void testSerializableJavaObjectCache() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        ScriptExpression se = new ScriptExpression("new java.lang.StringBuffer(\"ss\")");
        se.setDataType(11);
        Binding b = new Binding("serializable", (IBaseExpression)se);
        b.setDataType(11);
        query.addBinding((IBinding)b);
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = queryResults.getResultIterator();
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        IResultMetaData meta = it.getResultMetaData();
        int count = 0;
        while (it.next()) {
            Object value = it.getValue("serializable");
            Assert.assertTrue((boolean)(value instanceof StringBuffer));
            Assert.assertEquals((Object)"ss", (Object)value.toString());
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        it.close();
    }

    @Test
    public void testUnserializableJavaObjectCache() throws Exception {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(this.dataSet.getName());
        ScriptExpression se = new ScriptExpression("new java.lang.ThreadGroup(\"ss\")");
        se.setDataType(11);
        Binding b = new Binding("unserializable", (IBaseExpression)se);
        b.setDataType(11);
        query.addBinding((IBinding)b);
        query.setCacheQueryResults(true);
        IQueryResults queryResults = this.dataEngine.prepare((IQueryDefinition)query).execute(null);
        String id = queryResults.getID();
        IResultIterator it = null;
        try {
            it = queryResults.getResultIterator();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Assert.assertTrue((boolean)false);
        it.close();
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.setQueryResultsID(id);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)newQuery);
        IQueryResults result = pq.execute(null);
        it = result.getResultIterator();
        IResultMetaData meta = it.getResultMetaData();
        int count = 0;
        while (it.next()) {
            Object value = it.getValue("unserializable");
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        it.close();
    }
}

