/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.actions;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.actions.SelectNodeAction;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.CurrentNodeSelectionTransformer;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Tool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ViewTool;

public abstract class SelectNodeToolAction
extends SelectNodeAction {
    protected NodeManager nodeManager_;
    protected Tool selectedTool_;

    public SelectNodeToolAction(Controller controller, NodeManager nodeManager) {
        super(controller, nodeManager);
        this.nodeManager_ = nodeManager;
        this.selectedTool_ = null;
    }

    public final NodeManager getNodeManager() {
        return this.nodeManager_;
    }

    @Override
    protected boolean processLinkParameters(HttpServletRequest request) {
        boolean result = super.processLinkParameters(request);
        String toolIdString = request.getParameter("toolId");
        String viewIdString = request.getParameter("viewId");
        String viewToolIdString = request.getParameter("viewToolId");
        try {
            Integer.parseInt(toolIdString);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.propertyTable_.put("toolId", toolIdString);
        try {
            int viewId = Integer.parseInt(viewIdString);
            this.propertyTable_.put("viewId", viewIdString);
            if (viewId != -1) {
                Integer.parseInt(viewToolIdString);
                this.propertyTable_.put("viewToolId", viewToolIdString);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    @Override
    public boolean run() {
        int nodeId = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        if (!this.isStaleNode(nodeId)) {
            this.makeNodeVisible(this.nodeManager_.getNode(nodeId));
            this.setSelectedNodeId(nodeId);
            this.selectedNode_ = this.nodeManager_.getSelectedNode();
            int toolId = Integer.parseInt((String)this.propertyTable_.get("toolId"));
            ToolManager toolManager = this.selectedNode_.getToolManager();
            toolManager.setSelectedToolId(toolId);
            this.selectedTool_ = toolManager.getSelectedTool();
            String viewIdString = (String)this.propertyTable_.get("viewId");
            if (viewIdString != null) {
                int viewId = Integer.parseInt(viewIdString);
                this.setSelectedViewId(viewId);
                if (viewId != -1) {
                    String viewToolIdString = (String)this.propertyTable_.get("viewToolId");
                    ViewTool viewTool = (ViewTool)this.selectedTool_;
                    if (viewToolIdString != null) {
                        int viewToolId = Integer.parseInt(viewToolIdString);
                        ToolManager viewToolManager = this.selectedNode_.getViewToolManager();
                        if (viewToolManager == null) {
                            if (!this.isHistoryAction()) {
                                viewToolManager = viewTool.createToolManager(viewId);
                                viewToolId = viewToolManager.getSelectedToolId();
                            } else {
                                this.setStaleBreadCrumb();
                                return false;
                            }
                        }
                        viewToolManager.setSelectedToolId(viewToolId);
                    }
                }
            } else {
                this.setSelectedViewId(-1);
            }
            this.addToHistory(this.getPerspectiveId(), this.getActionLinkForHistory());
            return true;
        }
        this.setStaleBreadCrumb();
        return false;
    }

    @Override
    public ITransformer[] getTransformers() {
        return new ITransformer[]{new CurrentNodeSelectionTransformer(this.controller_)};
    }

    public final Tool getSelectedViewTool() {
        if (this.propertyTable_.get("viewId") != null) {
            return this.selectedNode_.getViewToolManager().getSelectedTool();
        }
        return null;
    }

    public final Tool getSelectedTool() {
        return this.selectedTool_;
    }

    public abstract String getPropertiesContentVar();

    public abstract String getPropertiesContentPage();

    public String getStatusContentVar() {
        return null;
    }

    public String getStatusContentPage() {
        return null;
    }

    @Override
    public abstract int getPerspectiveId();
}

