/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util.declaration;

import org.eclipse.wst.css.core.internal.contentmodel.PropCMProperty;
import org.eclipse.wst.css.core.internal.parserz.CSSTextParser;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.css.core.internal.util.declaration.IShorthandAdapter;

public class ListStyleShorthandAdapter
implements IShorthandAdapter {
    @Override
    public boolean expand(String source, CSSPropertyContext dest) {
        CSSTextParser parser = new CSSTextParser(2, source);
        CSSTextToken[] tokens = parser.getTokens();
        if (tokens.length <= 0) {
            return false;
        }
        String image = "";
        String pos = "";
        String type = "";
        PropCMProperty propPos = PropCMProperty.getInstanceOf("list-style-position");
        PropCMProperty propType = PropCMProperty.getInstanceOf("list-style-type");
        PropCMProperty propImage = PropCMProperty.getInstanceOf("list-style-image");
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                if (propPos.canHave(tokens[i].image)) {
                    pos = tokens[i].image;
                } else {
                    if (propType.canHave(tokens[i].image)) {
                        type = tokens[i].image;
                    }
                    if (propImage.canHave(tokens[i].image)) {
                        image = tokens[i].image;
                    }
                }
            } else if (tokens[i].kind == "DECLARATION_VALUE_URI") {
                image = tokens[i].image;
            }
            ++i;
        }
        dest.set(propPos.getName(), pos);
        dest.set(propType.getName(), type);
        dest.set(propImage.getName(), image);
        return true;
    }

    @Override
    public String extract(String source, PropCMProperty propDest) {
        CSSTextParser parser = new CSSTextParser(2, source);
        CSSTextToken[] tokens = parser.getTokens();
        if (tokens.length <= 0) {
            return null;
        }
        String image = null;
        String pos = null;
        String type = null;
        PropCMProperty propPos = PropCMProperty.getInstanceOf("list-style-position");
        PropCMProperty propType = PropCMProperty.getInstanceOf("list-style-type");
        PropCMProperty propImage = PropCMProperty.getInstanceOf("list-style-image");
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                if (propPos.canHave(tokens[i].image)) {
                    pos = tokens[i].image;
                } else {
                    if (propType.canHave(tokens[i].image)) {
                        type = tokens[i].image;
                    }
                    if (propImage.canHave(tokens[i].image)) {
                        image = tokens[i].image;
                    }
                }
            } else if (tokens[i].kind == "DECLARATION_VALUE_URI") {
                image = tokens[i].image;
            }
            ++i;
        }
        if (propPos == propDest) {
            return pos;
        }
        if (propType == propDest) {
            return type;
        }
        if (propImage == propDest) {
            return image;
        }
        return null;
    }
}

