/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.jst.jsp.core.internal.java.XMLJSPRegionHelper;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

class JSPIncludeRegionHelper
extends XMLJSPRegionHelper {
    public JSPIncludeRegionHelper(JSPTranslator translator, boolean appendAsIndirectSource) {
        super(translator, appendAsIndirectSource);
    }

    @Override
    protected boolean isJSPStartRegion(IStructuredDocumentRegion sdRegion) {
        String type = sdRegion.getFirstRegion().getType();
        return type == "XML_TAG_OPEN" || type == "JSP_DECLARATION_OPEN" || type == "JSP_EXPRESSION_OPEN" || type == "JSP_SCRIPTLET_OPEN" || type == "JSP_DIRECTIVE_OPEN" || type == "JSP_DIRECTIVE_NAME";
    }

    @Override
    protected boolean isDeclaration(String tagName) {
        return tagName.equalsIgnoreCase("jsp:declaration") || tagName.equalsIgnoreCase("<%!");
    }

    @Override
    protected boolean isExpression(String tagName) {
        return tagName.equalsIgnoreCase("jsp:expression") || tagName.equalsIgnoreCase("<%=");
    }

    @Override
    protected boolean isScriptlet(String tagName) {
        return tagName.equalsIgnoreCase("jsp:scriptlet") || tagName.equalsIgnoreCase("<%");
    }

    @Override
    protected boolean isIncludeDirective(String tagName) {
        return tagName.equalsIgnoreCase("jsp:directive.include") || tagName.equalsIgnoreCase("include");
    }

    @Override
    protected boolean isTaglibDirective(String tagName) {
        return tagName.equalsIgnoreCase("jsp:directive.taglib") || tagName.equalsIgnoreCase("taglib");
    }

    @Override
    protected boolean isPageDirective(String tagName) {
        return tagName.equalsIgnoreCase("jsp:directive.page") || tagName.equalsIgnoreCase("page");
    }

    @Override
    protected String getRegionName(IStructuredDocumentRegion sdRegion) {
        ITextRegion nameRegion = null;
        String nameStr = "";
        int size = sdRegion.getRegions().size();
        if (size > 1) {
            nameRegion = sdRegion.getRegions().get(1);
        } else if (size == 1) {
            nameRegion = sdRegion.getRegions().get(0);
        }
        if (nameRegion != null) {
            nameStr = this.fTextToParse.substring(sdRegion.getStartOffset(nameRegion), sdRegion.getTextEndOffset(nameRegion));
        }
        return nameStr.trim();
    }

    @Override
    protected void processOtherRegions(IStructuredDocumentRegion sdRegion) {
        this.processIncludeDirective(sdRegion);
        this.processPageDirective(sdRegion);
    }

    @Override
    protected void prepareText(IStructuredDocumentRegion sdRegion) {
        this.fStrippedText = this.fTextBefore = this.fTextToParse.substring(sdRegion.getStartOffset(), sdRegion.getEndOffset());
    }
}

