/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.i18n;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.ULocale;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.eclipse.birt.report.model.core.CachedBundles;
import org.eclipse.birt.report.model.core.ResourceHelper;

class ResourceHandle {
    protected static final ResourceHandle defaultBundle = new ResourceHandle();
    protected PropertyResourceBundle resources;
    private static final String BUNDLE_NAME = "Messages";

    ResourceHandle() {
        ULocale emptyLocale = new ULocale("", "");
        String bundleName = BUNDLE_NAME;
        List<String> resourceFiles = ResourceHelper.getHelper(bundleName).getMessageFilenames(emptyLocale);
        URL fileURL = ResourceHandle.class.getResource(resourceFiles.get(0));
        assert (fileURL != null);
        this.resources = CachedBundles.populateBundle(fileURL);
        assert (this.resources != null);
    }

    ResourceHandle(ULocale locale) {
        String bundleName = BUNDLE_NAME;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        List<String> resourceFiles = ResourceHelper.getHelper(bundleName).getMessageFilenames(locale, false);
        int i = 0;
        while (i < resourceFiles.size()) {
            PropertyResourceBundle tmpBundle;
            String tmpFileName = resourceFiles.get(i);
            URL fileURL = ResourceHandle.class.getResource(tmpFileName);
            if (fileURL != null && (tmpBundle = CachedBundles.populateBundle(fileURL)) != null) {
                this.resources = tmpBundle;
                break;
            }
            ++i;
        }
        if (this.resources == null) {
            this.resources = ResourceHandle.defaultBundle.resources;
        }
    }

    public String getMessage(String key) {
        if (key == null) {
            return null;
        }
        String retMsg = null;
        try {
            retMsg = this.resources.getString(key);
        }
        catch (MissingResourceException e) {
            retMsg = null;
        }
        if (retMsg != null) {
            return retMsg;
        }
        try {
            retMsg = ResourceHandle.defaultBundle.resources.getString(key);
        }
        catch (MissingResourceException e) {
            assert (false) : key + " not found in resource bundle";
            return key;
        }
        return retMsg;
    }

    public String getMessage(String key, Object[] arguments) {
        String message = this.getMessage(key);
        return MessageFormat.format((String)message, (Object[])arguments);
    }
}

