/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.romdoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.birt.doc.romdoc.DocObject;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;

public class DocSlot
extends DocObject {
    ISlotDefn defn;
    String contentInfo;

    public DocSlot(ISlotDefn slot) {
        this.defn = slot;
    }

    @Override
    public String getName() {
        return this.defn.getName();
    }

    public String getCardinality() {
        return this.defn.isMultipleCardinality() ? "Multiple" : "Single";
    }

    public String getDisplayName() {
        return this.defn.getDisplayName();
    }

    public String getContents() {
        ArrayList<IElementDefn> list = new ArrayList<IElementDefn>(((SlotDefn)this.defn).getContentElements());
        Collections.sort(list, new ElementComparator());
        Iterator<IElementDefn> iter = list.iterator();
        StringBuilder contents = new StringBuilder();
        while (iter.hasNext()) {
            ElementDefn element = (ElementDefn)iter.next();
            if (contents.length() > 0) {
                contents.append(", ");
            }
            contents.append("<a href=\"");
            contents.append(element.getName());
            contents.append(".html\">");
            contents.append(element.getName());
            contents.append("</a>");
        }
        if (this.defn.isMultipleCardinality()) {
            contents.insert(0, "List of ");
        }
        return contents.toString();
    }

    public void setContentInfo(String value) {
        this.contentInfo = value;
    }

    public String getContentInfo() {
        return this.contentInfo;
    }

    public String getSince() {
        return this.defn.getSince();
    }

    public String getXmlName() {
        return this.defn.getXmlName();
    }

    public String getStyle() {
        Object style = this.defn.getSelector();
        if (style == null) {
            return "None";
        }
        Object target = style;
        if (((String)style).endsWith("-n")) {
            target = ((String)style).substring(0, ((String)style).length() - 1) + "1";
            style = ((String)style).substring(0, ((String)style).length() - 1) + "<i>n</i>";
        }
        StringBuilder link = new StringBuilder();
        link.append("<a href=\"../styles.html#");
        link.append((String)target);
        link.append("\">");
        link.append((String)style);
        link.append("</a>");
        return link.toString();
    }

    public boolean hasStyle() {
        return this.defn.getSelector() != null;
    }

    protected static class ElementComparator
    implements Comparator {
        protected ElementComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            ElementDefn e1 = (ElementDefn)arg0;
            ElementDefn e2 = (ElementDefn)arg1;
            return e1.getName().compareTo(e2.getName());
        }
    }
}

