/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.widgets.Display;

public class MetricUtility {
    public static final org.eclipse.swt.graphics.Point dpi = Display.getDefault().getDPI();

    public static Point inchToPixel(double x, double y) {
        int xpixel = (int)MetricUtility.inchToPixel(x);
        int ypixel = (int)MetricUtility.inchToPixel(y);
        return new Point(xpixel, ypixel);
    }

    public static double inchToPixel(double x) {
        return x * (double)MetricUtility.dpi.x;
    }

    public static double pixelToPixelInch(int x) {
        return (double)x / (double)MetricUtility.dpi.x;
    }

    public static void updateDimension(DimensionHandle dim, double pixelSize) throws SemanticException {
        MetricUtility.updateDimension(dim, pixelSize, dim.getUnits());
    }

    public static void updateDimension(DimensionHandle dim, double pixelSize, String targetUnit) throws SemanticException {
        if (targetUnit == null) {
            targetUnit = dim.getDefaultUnit();
        }
        if ("px".equals(targetUnit)) {
            dim.setValue((Object)new DimensionValue(pixelSize, "px"));
        } else if (DimensionUtil.isAbsoluteUnit((String)targetUnit)) {
            double inchSize = MetricUtility.pixelToPixelInch((int)pixelSize);
            dim.setValue((Object)DimensionUtil.convertTo((double)inchSize, (String)"in", (String)targetUnit));
        } else {
            double inchSize = MetricUtility.pixelToPixelInch((int)pixelSize);
            dim.setValue((Object)new DimensionValue(inchSize, "in"));
        }
    }
}

