/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.viewer;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.ui.controller.InputParameterDialog;
import org.eclipse.birt.report.designer.ui.preview.editors.SWTAbstractViewer;
import org.eclipse.birt.report.designer.ui.preview.parameter.AbstractParamGroup;
import org.eclipse.birt.report.designer.ui.preview.parameter.ScalarParam;
import org.eclipse.birt.report.designer.ui.preview.static_html.StaticHTMLPrviewPlugin;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.viewer.HyperlinkEngineConfig;
import org.eclipse.birt.report.designer.ui.viewer.ReportLocationListener;
import org.eclipse.birt.report.designer.ui.viewer.TOCContentProvider;
import org.eclipse.birt.report.designer.ui.viewer.TOCLableProvider;
import org.eclipse.birt.report.designer.ui.viewer.job.AbstractJob;
import org.eclipse.birt.report.designer.ui.viewer.job.AbstractUIJob;
import org.eclipse.birt.report.designer.ui.viewer.job.RenderJobRule;
import org.eclipse.birt.report.designer.ui.viewer.job.RenderJobRunner;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class StaticHTMLViewer
extends SWTAbstractViewer {
    private static final String TITLE_MESSAGE = "Showing page {0} of {1}";
    private final HTMLRenderOption renderOption = new HTMLRenderOption();
    private final EngineConfig engineConfig = new HyperlinkEngineConfig();
    private final IRenderOption drillRenderOption = new RenderOption();
    private Browser browser = null;
    private long currentPageNum = 1L;
    private long totalPageNum = 0L;
    private boolean isTocUpdate;
    private boolean isDrillThrough = false;
    private String reportDesignFile;
    private String reportDocumentFile;
    private Map paramValues = new HashMap();
    private String outputLocation;
    private boolean hasParas;
    private boolean isInitialize = false;
    private boolean assignParamValues = false;
    private FormToolkit toolkit;
    private Form form;
    private SashForm sashForm;
    private Composite browserContainer;
    private List inputParameters;
    private Action paramAction;
    private Action tocAction;
    private Action navFirstAction;
    private Action navPreAction;
    private Action navNextAction;
    private Action navLastAction;
    private Action navGoAction;
    private Action reRunReportAction;
    private Text goPageInput;
    private TreeViewer tocViewer;

    public void init() {
        super.init();
        this.configEngine();
    }

    protected void configEngine() {
        HTMLRenderOption emitterConfig = new HTMLRenderOption();
        emitterConfig.setActionHandler((IHTMLActionHandler)new HTMLActionHandler(){

            public String getURL(IAction actionDefn, Object context) {
                if (actionDefn.getType() == 3) {
                    return "birt://" + URLEncoder.encode(super.getURL(actionDefn, context));
                }
                return super.getURL(actionDefn, context);
            }
        });
        this.engineConfig.getEmitterConfigs().put("html", emitterConfig);
    }

    protected void configRender() {
        this.renderOption.setOutputFormat("html");
        this.renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.html");
    }

    public Control createUI(Composite parent) {
        if (parent == null) {
            return null;
        }
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.form.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        this.form.setImage(StaticHTMLPrviewPlugin.getDefault().getImageRegistry().get("form_title.gif"));
        this.toolkit.decorateFormHeading(this.form);
        this.form.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.form.getBody().setLayout((Layout)layout);
        this.reRunReportAction = new Action("Re-run the report", 1){

            public void run() {
                StaticHTMLViewer.this.render();
            }
        };
        this.reRunReportAction.setToolTipText("Re-run the report");
        this.reRunReportAction.setImageDescriptor(StaticHTMLPrviewPlugin.getDefault().getImageRegistry().getDescriptor("preview.gif"));
        this.form.getToolBarManager().add((org.eclipse.jface.action.IAction)this.reRunReportAction);
        this.paramAction = new Action("Enter parameter", 1){

            public void run() {
                StaticHTMLViewer.this.render();
            }
        };
        this.paramAction.setToolTipText("Open Parameters Dialog");
        this.paramAction.setImageDescriptor(StaticHTMLPrviewPlugin.getDefault().getImageRegistry().getDescriptor("parameter.gif"));
        this.form.getToolBarManager().add((org.eclipse.jface.action.IAction)this.paramAction);
        this.tocAction = new Action("TOC", 8){

            public void run() {
                if (StaticHTMLViewer.this.sashForm.getMaximizedControl() != null) {
                    StaticHTMLViewer.this.sashForm.setMaximizedControl(null);
                    this.setChecked(true);
                } else {
                    StaticHTMLViewer.this.sashForm.setMaximizedControl((Control)StaticHTMLViewer.this.browserContainer);
                    this.setChecked(false);
                }
            }
        };
        this.tocAction.setToolTipText("Show TOC");
        this.tocAction.setImageDescriptor(StaticHTMLPrviewPlugin.getDefault().getImageRegistry().getDescriptor("Toc.gif"));
        this.tocAction.setChecked(false);
        this.form.getToolBarManager().add((org.eclipse.jface.action.IAction)this.tocAction);
        this.form.getToolBarManager().add((IContributionItem)new Separator());
        this.navFirstAction = new Action("First", 1){

            public void run() {
                StaticHTMLViewer.this.currentPageNum = 1L;
                StaticHTMLViewer.this.renderWithoutAskingForParams();
            }
        };
        this.navFirstAction.setToolTipText("First");
        this.navFirstAction.setImageDescriptor(StaticHTMLPrviewPlugin.getDefault().getImageRegistry().getDescriptor("FirstPage.gif"));
        this.form.getToolBarManager().add((org.eclipse.jface.action.IAction)this.navFirstAction);
        this.navPreAction = new Action("Previous", 1){

            public void run() {
                if (StaticHTMLViewer.this.currentPageNum > 1L) {
                    --StaticHTMLViewer.this.currentPageNum;
                    StaticHTMLViewer.this.renderWithoutAskingForParams();
                }
            }
        };
        this.navPreAction.setToolTipText("Previous");
        this.navPreAction.setImageDescriptor(StaticHTMLPrviewPlugin.getDefault().getImageRegistry().getDescriptor("PreviousPage.gif"));
        this.form.getToolBarManager().add((org.eclipse.jface.action.IAction)this.navPreAction);
        this.navNextAction = new Action("Next", 1){

            public void run() {
                if (StaticHTMLViewer.this.currentPageNum < StaticHTMLViewer.this.totalPageNum) {
                    ++StaticHTMLViewer.this.currentPageNum;
                    StaticHTMLViewer.this.renderWithoutAskingForParams();
                }
            }
        };
        this.navNextAction.setToolTipText("Next");
        this.navNextAction.setImageDescriptor(StaticHTMLPrviewPlugin.getDefault().getImageRegistry().getDescriptor("NextPage.gif"));
        this.form.getToolBarManager().add((org.eclipse.jface.action.IAction)this.navNextAction);
        this.navLastAction = new Action("Last", 1){

            public void run() {
                StaticHTMLViewer.this.currentPageNum = StaticHTMLViewer.this.totalPageNum;
                StaticHTMLViewer.this.renderWithoutAskingForParams();
            }
        };
        this.navLastAction.setToolTipText("Last");
        this.navLastAction.setImageDescriptor(StaticHTMLPrviewPlugin.getDefault().getImageRegistry().getDescriptor("LastPage.gif"));
        this.form.getToolBarManager().add((org.eclipse.jface.action.IAction)this.navLastAction);
        this.form.getToolBarManager().add((IContributionItem)new Separator());
        ContributionItem inputText = new ContributionItem(){

            public void fill(ToolBar parent, int index) {
                ToolItem toolitem = new ToolItem(parent, 2, index);
                Composite container = new Composite((Composite)parent, 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                layout.marginHeight = 1;
                layout.marginWidth = 1;
                container.setLayout((Layout)layout);
                Label label = new Label(container, 0);
                label.setFont(container.getFont());
                label.setText("Go to page:");
                StaticHTMLViewer.this.goPageInput = StaticHTMLViewer.this.toolkit.createText(container, "", 2048);
                StaticHTMLViewer.this.goPageInput.setFont(container.getFont());
                StaticHTMLViewer.this.goPageInput.setLayoutData((Object)new GridData(1808));
                StaticHTMLViewer.this.goPageInput.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if ((e.character == '\n' || e.character == '\r') && (this).StaticHTMLViewer.this.navGoAction.isEnabled()) {
                            (this).StaticHTMLViewer.this.currentPageNum = Long.parseLong((this).StaticHTMLViewer.this.goPageInput.getText());
                            StaticHTMLViewer.this.renderWithoutAskingForParams();
                        }
                    }
                });
                StaticHTMLViewer.this.goPageInput.addModifyListener(new ModifyListener(){
                    private boolean isValid = true;

                    public void modifyText(ModifyEvent e) {
                        block6: {
                            if (!"".equals((this).StaticHTMLViewer.this.goPageInput.getText())) {
                                try {
                                    long page = Long.parseLong((this).StaticHTMLViewer.this.goPageInput.getText());
                                    if (page > 0L && page <= (this).StaticHTMLViewer.this.totalPageNum) {
                                        if (!this.isValid) {
                                            (this).StaticHTMLViewer.this.form.setMessage(null);
                                            this.isValid = true;
                                        }
                                        (this).StaticHTMLViewer.this.navGoAction.setEnabled(true);
                                        break block6;
                                    }
                                    (this).StaticHTMLViewer.this.form.setMessage("Page Number '" + page + "' is invalid!", 3);
                                    this.isValid = false;
                                    (this).StaticHTMLViewer.this.navGoAction.setEnabled(false);
                                }
                                catch (NumberFormatException e1) {
                                    (this).StaticHTMLViewer.this.form.setMessage("Page Number '" + (this).StaticHTMLViewer.this.goPageInput.getText() + "' is invalid!", 3);
                                    this.isValid = false;
                                    (this).StaticHTMLViewer.this.navGoAction.setEnabled(false);
                                }
                            } else {
                                (this).StaticHTMLViewer.this.form.setMessage(null);
                                this.isValid = true;
                            }
                        }
                    }
                });
                toolitem.setWidth(label.computeSize((int)-1, (int)-1).x + 40);
                toolitem.setControl((Control)container);
            }
        };
        inputText.setVisible(true);
        this.form.getToolBarManager().add((IContributionItem)inputText);
        this.navGoAction = new Action("Go to page", 1){

            public void run() {
                if (StaticHTMLViewer.this.goPageInput != null && !StaticHTMLViewer.this.goPageInput.isDisposed()) {
                    StaticHTMLViewer.this.currentPageNum = Long.parseLong(StaticHTMLViewer.this.goPageInput.getText());
                    StaticHTMLViewer.this.renderWithoutAskingForParams();
                }
            }
        };
        this.navGoAction.setToolTipText("Go to page");
        this.navGoAction.setImageDescriptor(StaticHTMLPrviewPlugin.getDefault().getImageRegistry().getDescriptor("Go.gif"));
        this.form.getToolBarManager().add((org.eclipse.jface.action.IAction)this.navGoAction);
        this.form.updateToolBar();
        this.sashForm = new SashForm(this.form.getBody(), 0);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setLayout((Layout)layout);
        this.toolkit.adapt((Control)this.sashForm, false, false);
        this.createTOCSection((Composite)this.sashForm);
        this.createBrowserSection((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{2, 8});
        this.toolkit.paintBordersFor(this.form.getBody());
        return this.form;
    }

    private void createBrowserSection(Composite parent) {
        this.browserContainer = this.toolkit.createComposite(parent);
        this.browserContainer.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        this.browserContainer.setLayout((Layout)layout);
        this.browser = new Browser(this.browserContainer, 0);
        this.browser.setLayoutData((Object)new GridData(1808));
        this.browser.addLocationListener((LocationListener)new ReportLocationListener(this));
        this.sashForm.setMaximizedControl((Control)this.browserContainer);
    }

    private void createTOCSection(Composite parent) {
        Composite toc = this.toolkit.createComposite(parent);
        toc.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        toc.setLayout((Layout)new GridLayout());
        this.toolkit.createLabel(toc, "Table of Contents:");
        Tree t = this.toolkit.createTree(toc, 0);
        t.setLayoutData((Object)new GridData(1808));
        this.tocViewer = new TreeViewer(t);
        this.tocViewer.setLabelProvider((IBaseLabelProvider)new TOCLableProvider(){});
        this.tocViewer.setContentProvider((IContentProvider)new TOCContentProvider(){});
        this.tocViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (StaticHTMLViewer.this.reportDocumentFile != null) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    TOCNode node = (TOCNode)selection.getFirstElement();
                    try {
                        IReportDocument document = StaticHTMLViewer.this.openReportDocument(StaticHTMLViewer.this.reportDocumentFile);
                        StaticHTMLViewer.this.setCurrentPage(document.getPageNumber(node.getBookmark()));
                        document.close();
                        StaticHTMLViewer.this.renderWithoutAskingForParams();
                    }
                    catch (EngineException e) {
                        ExceptionUtil.handle((Throwable)e);
                    }
                }
            }
        });
        this.toolkit.paintBordersFor(toc);
    }

    protected void refreshTOC() {
        if (!this.isTocUpdate) {
            if (this.reportDocumentFile != null) {
                try {
                    IReportDocument document = this.openReportDocument(this.reportDocumentFile);
                    this.tocViewer.setInput((Object)document.getTOCTree("viewer", ULocale.getDefault()).getRoot());
                    document.close();
                }
                catch (EngineException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            this.isTocUpdate = true;
        }
    }

    public Control getUI() {
        return this.form;
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public IRenderOption getRenderOption() {
        if (this.isDrillThrough) {
            this.isDrillThrough = false;
            return this.drillRenderOption;
        }
        return this.renderOption;
    }

    public void setInput(Object input) {
        if (input instanceof String) {
            this.setReportDesignFile((String)input);
        }
    }

    public void setParamValues(Map paramValues) {
        this.paramValues = paramValues;
        this.assignParamValues = true;
        this.isDrillThrough = true;
        this.drillRenderOption.setOption("Format", paramValues.get("__format"));
    }

    public void setReportDesignFile(String reportDesignFile) {
        this.reportDesignFile = reportDesignFile;
        this.isTocUpdate = false;
    }

    public String getReportDesignFile() {
        return this.reportDesignFile;
    }

    public void getParameterValues(List params) {
        if (params != null && params.size() > 0) {
            this.hasParas = true;
            if (this.assignParamValues && this.checkParamsValues(params)) {
                return;
            }
            InputParameterDialog dialog = new InputParameterDialog(Display.getCurrent().getActiveShell(), params, this.paramValues);
            if (dialog.open() == 0) {
                this.paramValues = dialog.getParameters();
                this.assignParamValues = true;
            }
        } else {
            this.hasParas = false;
            this.paramAction.setToolTipText("No Parameters");
        }
    }

    private boolean checkParamsValues(List params) {
        for (Object obj : params) {
            if (obj instanceof ScalarParam && !((ScalarParam)obj).getHandle().isHidden()) {
                if (this.paramValues.containsKey(((ScalarParam)obj).getHandle().getName())) continue;
                return false;
            }
            if (!(obj instanceof AbstractParamGroup)) continue;
            AbstractParamGroup group = (AbstractParamGroup)obj;
            this.checkParamsValues(group.getChildren());
        }
        return true;
    }

    public void renderReport(IProgressMonitor monitor) {
        if (this.hasParas && !this.assignParamValues) {
            return;
        }
        this.assignParamValues = false;
        monitor.subTask("Collecting parameters");
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        monitor.subTask("Rendering report");
        if (monitor.isCanceled()) {
            return;
        }
        File reportFile = new File(this.reportDesignFile);
        String outputFolder = this.getOutputFolder(reportFile);
        String outputFormat = "html";
        if (this.isDrillThrough) {
            outputFormat = this.drillRenderOption.getOutputFormat();
        }
        this.outputLocation = outputFolder + File.separator + reportFile.getName() + "." + outputFormat;
        try {
            if (this.currentPageNum > 0L) {
                try {
                    this.reportDocumentFile = this.createReportDocument(this.reportDesignFile, outputFolder, this.paramValues);
                    this.totalPageNum = this.createReportOutput(this.reportDocumentFile, this.outputLocation, this.currentPageNum);
                }
                catch (EngineException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(3);
    }

    private String getOutputFolder(File file) {
        return StaticHTMLPrviewPlugin.getDefault().getTempFolder() + File.separator + file.getName();
    }

    private void setControlStatus() {
        this.form.setText("Running report...");
        this.form.setBusy(true);
        this.paramAction.setEnabled(false);
        this.reRunReportAction.setEnabled(false);
        this.tocAction.setEnabled(false);
        this.navFirstAction.setEnabled(false);
        this.navPreAction.setEnabled(false);
        this.navNextAction.setEnabled(false);
        this.navLastAction.setEnabled(false);
        this.navGoAction.setEnabled(false);
    }

    public void render() {
        this.setControlStatus();
        RenderJobRule jobRule = new RenderJobRule(this.reportDesignFile);
        this.initJob(jobRule);
        this.getParamValuesJob(jobRule);
        this.renderJob(jobRule);
        this.showReportOutputJob(jobRule);
        this.updateFormJob(jobRule);
    }

    public void renderWithoutAskingForParams() {
        this.setControlStatus();
        RenderJobRule jobRule = new RenderJobRule(this.reportDesignFile);
        this.renderJob(jobRule);
        this.showReportOutputJob(jobRule);
        this.updateFormJob(jobRule);
    }

    private void initJob(RenderJobRule jobRule) {
        AbstractJob initJob = new AbstractJob("Initialize engine", this.reportDesignFile){

            @Override
            public void work(IProgressMonitor monitor) {
                if (!StaticHTMLViewer.this.isInitialize) {
                    monitor.subTask("Initialize engine");
                    StaticHTMLViewer.this.init();
                    StaticHTMLViewer.this.isInitialize = true;
                }
                monitor.subTask("Prepair collect parameters");
                StaticHTMLViewer.this.setParameters(StaticHTMLViewer.this.getInputParameters(StaticHTMLViewer.this.reportDesignFile));
            }
        };
        RenderJobRunner.runRenderJob(initJob, jobRule);
    }

    private void getParamValuesJob(RenderJobRule jobRule) {
        AbstractUIJob getParameterJob = new AbstractUIJob("Collecting parameters", this.reportDesignFile){

            @Override
            public void work(IProgressMonitor monitor) {
                monitor.subTask("Collecting parameters");
                StaticHTMLViewer.this.getParameterValues(StaticHTMLViewer.this.inputParameters);
            }
        };
        getParameterJob.setSystem(true);
        RenderJobRunner.runRenderJob((Job)getParameterJob, jobRule);
    }

    private void renderJob(RenderJobRule jobRule) {
        AbstractJob renderJob = new AbstractJob("Rendering report", this.reportDesignFile){

            @Override
            public void work(IProgressMonitor monitor) {
                monitor.subTask(StaticHTMLViewer.this.reportDesignFile);
                StaticHTMLViewer.this.renderReport(monitor);
            }
        };
        RenderJobRunner.runRenderJob(renderJob, jobRule);
    }

    private void showReportOutputJob(RenderJobRule jobRule) {
        AbstractUIJob showJob = new AbstractUIJob("Showing report", this.reportDesignFile){

            @Override
            public void work(IProgressMonitor monitor) {
                monitor.subTask("Show report in Browser");
                if (!StaticHTMLViewer.this.form.isDisposed()) {
                    StaticHTMLViewer.this.browser.setUrl(StaticHTMLViewer.this.outputLocation);
                    if (StaticHTMLViewer.this.currentPageNum < StaticHTMLViewer.this.totalPageNum) {
                        StaticHTMLViewer.this.navNextAction.setEnabled(true);
                        StaticHTMLViewer.this.navLastAction.setEnabled(true);
                    } else {
                        StaticHTMLViewer.this.navNextAction.setEnabled(false);
                        StaticHTMLViewer.this.navLastAction.setEnabled(false);
                    }
                    if (StaticHTMLViewer.this.currentPageNum > 1L) {
                        StaticHTMLViewer.this.navPreAction.setEnabled(true);
                        StaticHTMLViewer.this.navFirstAction.setEnabled(true);
                    } else {
                        StaticHTMLViewer.this.navPreAction.setEnabled(false);
                        StaticHTMLViewer.this.navFirstAction.setEnabled(false);
                    }
                    StaticHTMLViewer.this.goPageInput.setText("" + StaticHTMLViewer.this.currentPageNum);
                    StaticHTMLViewer.this.refreshTOC();
                }
            }
        };
        showJob.setSystem(true);
        RenderJobRunner.runRenderJob((Job)showJob, jobRule);
    }

    private void updateFormJob(RenderJobRule jobRule) {
        AbstractUIJob updateFormJob = new AbstractUIJob("Update", ""){

            @Override
            public void work(IProgressMonitor monitor) {
                if (!StaticHTMLViewer.this.form.isDisposed()) {
                    StaticHTMLViewer.this.form.setBusy(false);
                    StaticHTMLViewer.this.form.setText(MessageFormat.format(StaticHTMLViewer.TITLE_MESSAGE, StaticHTMLViewer.this.currentPageNum, StaticHTMLViewer.this.totalPageNum));
                    StaticHTMLViewer.this.reRunReportAction.setEnabled(true);
                    StaticHTMLViewer.this.paramAction.setEnabled(StaticHTMLViewer.this.hasParas);
                    StaticHTMLViewer.this.navGoAction.setEnabled(true);
                    StaticHTMLViewer.this.tocAction.setEnabled(true);
                    if (StaticHTMLViewer.this.hasParas && !StaticHTMLViewer.this.assignParamValues && StaticHTMLViewer.this.paramValues.isEmpty()) {
                        StaticHTMLViewer.this.navGoAction.setEnabled(false);
                        StaticHTMLViewer.this.tocAction.setEnabled(false);
                    }
                }
            }
        };
        updateFormJob.setSystem(true);
        RenderJobRunner.runRenderJob((Job)updateFormJob, jobRule);
    }

    protected void setParameters(List inputParameters) {
        this.inputParameters = inputParameters;
    }

    public void setCurrentPage(long page) {
        this.currentPageNum = page;
    }

    public long getCurrentPage() {
        return this.currentPageNum;
    }
}

