/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;

public class PropertyDescriptorProvider
extends AbstractDescriptorProvider {
    protected String property;
    protected String element;
    protected Object input;

    public PropertyDescriptorProvider(String property, String element) {
        this.property = property;
        this.element = element;
    }

    @Override
    public Object load() {
        String value = null;
        if (this.input instanceof GroupElementHandle) {
            value = ((GroupElementHandle)this.input).getStringProperty(this.property);
        } else if (this.input instanceof List) {
            value = DEUtil.getGroupElementHandle((List)((List)this.input)).getStringProperty(this.property);
        }
        return value == null ? "" : value;
    }

    public boolean hasLocalValue() {
        return DEUtil.getGroupElementHandle((List)((List)this.input)).getLocalStringProperty(this.property) != null;
    }

    @Override
    public void save(Object value) throws SemanticException {
        if (this.isReadOnly()) {
            return;
        }
        GroupElementHandle groupElementHandle = null;
        if (this.input instanceof GroupElementHandle) {
            groupElementHandle = (GroupElementHandle)this.input;
        } else if (this.input instanceof List) {
            groupElementHandle = DEUtil.getGroupElementHandle((List)((List)this.input));
        }
        if (groupElementHandle != null) {
            GroupPropertyHandle handle = groupElementHandle.getPropertyHandle(this.property);
            if (handle != null && handle.getValue() != null && (value instanceof String ? handle.getStringValue().equals(value) : handle.getValue().equals(value))) {
                return;
            }
            groupElementHandle.setProperty(this.property, value);
        }
    }

    @Override
    public String getDisplayName() {
        String name = null;
        if (this.input instanceof GroupElementHandle) {
            IElementPropertyDefn propertyDefn = ((GroupElementHandle)this.input).getPropertyHandle(this.property).getPropertyDefn();
            if (propertyDefn != null) {
                name = propertyDefn.getDisplayName();
            }
        } else if (this.input instanceof List) {
            IElementPropertyDefn propertyDefn = DEUtil.getGroupElementHandle((List)((List)this.input)).getPropertyHandle(this.property).getPropertyDefn();
            if (propertyDefn != null) {
                name = propertyDefn.getDisplayName();
            }
        } else {
            IElementPropertyDefn propertyDefn = DesignEngine.getMetaDataDictionary().getElement(this.element).getProperty(this.property);
            if (propertyDefn != null) {
                name = Messages.getString((String)propertyDefn.getDisplayNameID());
            }
        }
        if (name == null) {
            return "";
        }
        return name;
    }

    public String getLocalStringValue() {
        String value = null;
        if (this.input instanceof GroupElementHandle) {
            value = ((GroupElementHandle)this.input).getLocalStringProperty(this.property);
        } else if (this.input instanceof List) {
            value = DEUtil.getGroupElementHandle((List)((List)this.input)).getLocalStringProperty(this.property);
        }
        if (value == null) {
            return "";
        }
        return value;
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
    }

    protected String getElement() {
        return this.element;
    }

    protected String getProperty() {
        return this.property;
    }

    public boolean isReadOnly() {
        GroupPropertyHandle propertyHandle = null;
        if (this.input instanceof GroupElementHandle) {
            propertyHandle = ((GroupElementHandle)this.input).getPropertyHandle(this.property);
        } else if (this.input instanceof List) {
            propertyHandle = DEUtil.getGroupElementHandle((List)((List)this.input)).getPropertyHandle(this.property);
        }
        if (propertyHandle != null) {
            return propertyHandle.isReadOnly();
        }
        return false;
    }
}

