/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;

public class LogicalPageSequence {
    private long[][] visiblePages;
    private long totalVisiblePageCount;
    private long totalPhysicalPageCount;

    public LogicalPageSequence(long[][] visiblePages) {
        this.visiblePages = visiblePages;
        this.totalVisiblePageCount = this.calculateTotalPageCount(visiblePages);
    }

    public LogicalPageSequence(ArrayList<long[][]> pages) {
        this(pages, -1L);
    }

    public LogicalPageSequence(ArrayList<long[][]> pages, long totalPhysicalPageNumber) {
        this.totalPhysicalPageCount = totalPhysicalPageNumber;
        this.visiblePages = this.mergeVisiblePages(pages.get(0));
        int i = 1;
        while (i < pages.size()) {
            this.visiblePages = this.mergeVisiblePages(this.visiblePages, pages.get(i));
            ++i;
        }
        this.totalVisiblePageCount = this.calculateTotalPageCount(this.visiblePages);
    }

    public long getTotalVisiblePageCount() {
        return this.totalVisiblePageCount;
    }

    public long[][] getVisiblePages() {
        return this.visiblePages;
    }

    public long getLogicalPageNumber(long physicalPageNumber) {
        assert (this.visiblePages != null);
        long logicalPageNumber = 0L;
        int i = 0;
        while (i < this.visiblePages.length) {
            long firstPage = this.visiblePages[i][0];
            long lastPage = this.visiblePages[i][1];
            if (firstPage > physicalPageNumber) {
                return -1L;
            }
            if (lastPage >= physicalPageNumber) {
                return logicalPageNumber + physicalPageNumber - firstPage + 1L;
            }
            logicalPageNumber += lastPage - firstPage + 1L;
            ++i;
        }
        return -1L;
    }

    public long[][] getPhysicalPageNumbers(long[][] logicalPages) {
        ArrayList<long[]> physicalPages = new ArrayList<long[]>();
        long logicalPageNumber = 0L;
        int j = 0;
        int i = 0;
        while (i < this.visiblePages.length) {
            long[] range;
            long firstPhysicalPage = this.visiblePages[i][0];
            long lastPhysicalPage = this.visiblePages[i][1];
            long firstLogicalPage = logicalPageNumber + 1L;
            long lastLogicalPage = logicalPageNumber + lastPhysicalPage - firstPhysicalPage + 1L;
            while (j < logicalPages.length) {
                range = logicalPages[j];
                if (range[1] >= firstLogicalPage) break;
                ++j;
            }
            while (j < logicalPages.length) {
                range = logicalPages[j];
                if (range[0] > lastLogicalPage) break;
                long firstPage = firstPhysicalPage + Math.max(firstLogicalPage, range[0]) - firstLogicalPage;
                long lastPage = firstPhysicalPage + Math.min(lastLogicalPage, range[1]) - firstLogicalPage;
                physicalPages.add(new long[]{firstPage, lastPage});
                if (range[1] > lastLogicalPage) break;
                ++j;
            }
            if (j >= logicalPages.length) break;
            logicalPageNumber += lastPhysicalPage - firstPhysicalPage + 1L;
            ++i;
        }
        return (long[][])physicalPages.toArray((T[])new long[physicalPages.size()][]);
    }

    private long[][] mergeVisiblePages(long[][] pages) {
        if (this.totalPhysicalPageCount == -1L) {
            return pages;
        }
        ArrayList<long[]> visiblePages = new ArrayList<long[]>();
        int i = 0;
        while (i < pages.length) {
            long firstPage = pages[i][0];
            long lastPage = pages[i][1];
            if (lastPage <= this.totalPhysicalPageCount) {
                visiblePages.add(pages[i]);
            } else if (firstPage <= this.totalPhysicalPageCount) {
                visiblePages.add(new long[]{firstPage, this.totalPhysicalPageCount});
            }
            ++i;
        }
        return (long[][])visiblePages.toArray((T[])new long[visiblePages.size()][]);
    }

    /*
     * Unable to fully structure code
     */
    private long[][] mergeVisiblePages(long[][] pages1, long[][] pages2) {
        pages = new ArrayList<long[]>();
        i = 0;
        j = 0;
        ** GOTO lbl23
        {
            ++j;
            do {
                if (j < pages2.length && pages1[i][0] > pages2[j][1]) continue block0;
                if (j < pages2.length) ** GOTO lbl20
                break block0;
lbl-1000:
                // 1 sources

                {
                    firstPage = Math.max(pages1[i][0], pages2[j][0]);
                    lastPage = Math.min(pages1[i][1], pages2[j][1]);
                    if (this.totalPhysicalPageCount == -1L) {
                        pages.add(new long[]{firstPage, lastPage});
                    } else if (lastPage <= this.totalPhysicalPageCount) {
                        pages.add(new long[]{firstPage, lastPage});
                    }
                    ++j;
lbl20:
                    // 2 sources

                    ** while (j < pages2.length && pages1[i][1] >= pages2[j][0])
                }
lbl21:
                // 1 sources

                if (j >= pages2.length) break block0;
                ++i;
lbl23:
                // 2 sources

            } while (i < pages1.length);
        }
        return (long[][])pages.toArray((T[])new long[pages.size()][]);
    }

    private long calculateTotalPageCount(long[][] pages) {
        long totalPage = 0L;
        int i = 0;
        while (i < pages.length) {
            totalPage += pages[i][1] - pages[i][0] + 1L;
            ++i;
        }
        return totalPage;
    }
}

