/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.AggregationCrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.BaseCrosstabAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabHeaderHandleAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.HeaderCrosstabCellHandleAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.ICrosstabCellAdapterFactory;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.NormalCrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.TotalCrosstabCellHandleAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;

public class CrosstabHandleAdapter
extends BaseCrosstabAdapter {
    private static final String COLUMNAREA_COLUMN = "columnarea_column";
    private static final String COLUMNAREA_ROW = "columnarea_row";
    private static final String ROWAREA_COLUMN = "rowarea_column";
    private static final String ROWAREA_ROW = "rowarea_row";
    public static final String DEFAULT_WIDTH = "100.0%";
    public static final String LEFT_CONNER = "left_conner";
    private ICrosstabCellAdapterFactory factory = this.createCrosstabCellAdapterFactory();
    private int columnAndMeasureColumnNumber = -1;
    private List oldModelList = new ArrayList();
    private int adjustGrandColumn;
    private int adjustGrandRow;
    private HashMap map = new HashMap();

    public CrosstabHandleAdapter(CrosstabReportItemHandle handle) {
        super((AbstractCrosstabItemHandle)handle);
    }

    protected ICrosstabCellAdapterFactory createCrosstabCellAdapterFactory() {
        return new DefaultCrocsstabCellAdapterFactory();
    }

    @Override
    public List getModelList() {
        this.init();
        ArrayList list = new ArrayList();
        List columns = this.buildColumnArea();
        List rows = this.buildRowArea();
        List details = this.buildMeasures();
        this.adjustDirection(columns, rows);
        this.buildModel(list, columns, rows, details);
        this.adjustColumn(columns, details);
        this.adjustRow(rows, details);
        ArrayList leftConner = new ArrayList();
        this.buildLeftConner(leftConner);
        list.addAll(leftConner);
        this.adjustGrandTotal(list, (CrosstabCellAdapter)leftConner.get(leftConner.size() - 1));
        Collections.sort(list, new ModelComparator());
        this.oldModelList = list;
        return list;
    }

    private void adjustGrandTotal(List list, CrosstabCellAdapter first) {
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        int i = 0;
        while (i < list.size()) {
            CrosstabCellAdapter cellAdapter = (CrosstabCellAdapter)list.get(i);
            if (this.adjustGrandColumn > 0) {
                int beforeColumnNumber = columnCount - this.adjustGrandColumn;
                int cellColumnNumber = cellAdapter.getColumnNumber();
                if (cellColumnNumber > first.getColumnNumber() + first.getColumnSpan() - 1) {
                    if (cellColumnNumber <= beforeColumnNumber) {
                        cellAdapter.setColumnNumber(cellColumnNumber + this.adjustGrandColumn);
                    } else {
                        cellAdapter.setColumnNumber(cellColumnNumber - beforeColumnNumber + first.getColumnNumber() + first.getColumnSpan() - 1);
                    }
                }
            }
            if (this.adjustGrandRow > 0) {
                int beforeRowNumber = rowCount - this.adjustGrandRow;
                int cellRowNumber = cellAdapter.getRowNumber();
                if (cellRowNumber > first.getRowNumber() + first.getRowSpan() - 1) {
                    if (cellRowNumber <= beforeRowNumber) {
                        cellAdapter.setRowNumber(cellRowNumber + this.adjustGrandRow);
                    } else {
                        cellAdapter.setRowNumber(cellRowNumber - beforeRowNumber + first.getRowNumber() + first.getRowSpan() - 1);
                    }
                }
            }
            ++i;
        }
    }

    private void buildLeftConner(List list) {
        int rowBase = (Integer)this.map.get(COLUMNAREA_ROW);
        int columnBase = (Integer)this.map.get(ROWAREA_COLUMN);
        CrosstabReportItemHandle handle = this.getCrosstabReportItemHandle();
        CrosstabCellAdapter first = null;
        if (handle.getHeader() == null) {
            first = this.factory.createCrosstabCellAdapter(LEFT_CONNER, null, 1, rowBase, 1, columnBase, false);
        } else {
            List columnList = CrosstabUtil.getLevelList((CrosstabReportItemHandle)handle, (int)1);
            List rowList = CrosstabUtil.getLevelList((CrosstabReportItemHandle)handle, (int)0);
            if (handle.getHeaderCount() > 1) {
                int temp = rowBase;
                int rowCount = rowBase;
                int columnCount = columnBase;
                int needSpan = 0;
                if (columnList.size() == 0 && rowBase == 2) {
                    --temp;
                    rowCount = 1;
                    needSpan = 1;
                } else if (rowList.size() == 0 && columnBase == 2) {
                    temp = columnBase - 1;
                    columnCount = 1;
                    needSpan = 2;
                }
                if (rowCount * columnCount == handle.getHeaderCount()) {
                    int i = 0;
                    while (i < rowCount) {
                        int j = 0;
                        while (j < columnCount) {
                            int rowSpan = 1;
                            int columnSpan = 1;
                            if (needSpan == 1) {
                                rowSpan = 2;
                            } else if (needSpan == 2) {
                                columnSpan = 2;
                            }
                            CrosstabCellAdapter cellAdapter = this.factory.createCrosstabCellAdapter("crosstab_header", handle.getHeader(i * columnCount + j), i + 1, rowSpan, j + 1, columnSpan, false);
                            list.add(cellAdapter);
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    first = this.factory.createCrosstabCellAdapter("crosstab_header", handle.getHeader(), 1, rowBase, 1, columnBase, false);
                }
            } else {
                first = this.factory.createCrosstabCellAdapter("crosstab_header", handle.getHeader(), 1, rowBase, 1, columnBase, false);
            }
        }
        if (first != null) {
            list.add(0, first);
        }
    }

    private void adjustDirection(List columns, List rows) {
        String otherArea;
        String area;
        List workList = null;
        if (this.isVertical()) {
            workList = rows;
            area = ROWAREA_ROW;
            otherArea = ROWAREA_COLUMN;
        } else {
            workList = columns;
            area = COLUMNAREA_COLUMN;
            otherArea = COLUMNAREA_ROW;
        }
        if (workList.size() != 1) {
            return;
        }
        Object obj = workList.get(0);
        if (!(obj instanceof VirtualCrosstabCellAdapter)) {
            return;
        }
        CrosstabCellAdapter adapter = (CrosstabCellAdapter)obj;
        List measures = this.getMeasreViewHandleList();
        if (measures.size() > 0) {
            int number;
            if (this.isVertical()) {
                number = this.addMesureHeaderToVirtual(workList, 1, 1, 2, 1, measures);
                adapter.setRowSpan(number);
            } else {
                number = this.addMesureHeaderToVirtual(workList, 2, 1, 1, 1, measures);
                adapter.setColumnSpan(number);
            }
            if (number == 0) {
                number = 1;
            }
            this.map.put(area, number);
            if (this.isHideHeader()) {
                this.map.put(otherArea, 1);
            } else {
                this.map.put(otherArea, 2);
            }
        }
    }

    private void adjustColumn(List columns, List details) {
        int i = 0;
        while (i < columns.size()) {
            CrosstabCellAdapter adapter = (CrosstabCellAdapter)columns.get(i);
            int row = adapter.getRowNumber();
            int column = adapter.getColumnNumber();
            int columnSpan = adapter.getColumnSpan();
            if (adapter.getPositionType().equals("sub_total") && this.isBefore(adapter.getCrosstabCellHandle())) {
                int tempColumnNumber;
                CrosstabCellAdapter tempAdapter;
                CrosstabCellAdapter beforeAdapter = this.getCell(row, column - 1, columns);
                int beforeColumn = beforeAdapter.getColumnNumber();
                int beforeColumnSpan = beforeAdapter.getColumnSpan();
                int j = 0;
                while (j < columns.size()) {
                    tempAdapter = (CrosstabCellAdapter)columns.get(j);
                    if (tempAdapter.getRowNumber() >= row) {
                        tempColumnNumber = tempAdapter.getColumnNumber();
                        if (tempColumnNumber >= beforeColumn && tempColumnNumber < beforeColumn + beforeColumnSpan) {
                            tempAdapter.setColumnNumber(tempColumnNumber + columnSpan);
                        } else if (tempColumnNumber >= column && tempColumnNumber < column + columnSpan) {
                            tempAdapter.setColumnNumber(tempColumnNumber - beforeColumnSpan);
                        }
                    }
                    ++j;
                }
                j = 0;
                while (j < details.size()) {
                    tempAdapter = (CrosstabCellAdapter)details.get(j);
                    tempColumnNumber = tempAdapter.getColumnNumber();
                    if (tempColumnNumber >= beforeColumn && tempColumnNumber < beforeColumn + beforeColumnSpan) {
                        tempAdapter.setColumnNumber(tempColumnNumber + columnSpan);
                    } else if (tempColumnNumber >= column && tempColumnNumber < column + columnSpan) {
                        tempAdapter.setColumnNumber(tempColumnNumber - beforeColumnSpan);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void adjustRow(List rows, List details) {
        int i = 0;
        while (i < rows.size()) {
            CrosstabCellAdapter adapter = (CrosstabCellAdapter)rows.get(i);
            int row = adapter.getRowNumber();
            int rowSpan = adapter.getRowSpan();
            int column = adapter.getColumnNumber();
            if (adapter.getPositionType().equals("sub_total") && this.isBefore(adapter.getCrosstabCellHandle())) {
                int tempRowNumber;
                CrosstabCellAdapter tempAdapter;
                CrosstabCellAdapter beforeAdapter = this.getCell(row - 1, column, rows);
                int beforeRow = beforeAdapter.getRowNumber();
                int beforeRowSpan = beforeAdapter.getRowSpan();
                int j = 0;
                while (j < rows.size()) {
                    tempAdapter = (CrosstabCellAdapter)rows.get(j);
                    if (tempAdapter.getColumnNumber() >= column) {
                        tempRowNumber = tempAdapter.getRowNumber();
                        if (tempRowNumber >= beforeRow && tempRowNumber < beforeRow + beforeRowSpan) {
                            tempAdapter.setRowNumber(tempRowNumber + rowSpan);
                        } else if (tempRowNumber >= row && tempRowNumber < row + rowSpan) {
                            tempAdapter.setRowNumber(tempRowNumber - beforeRowSpan);
                        }
                    }
                    ++j;
                }
                j = 0;
                while (j < details.size()) {
                    tempAdapter = (CrosstabCellAdapter)details.get(j);
                    tempRowNumber = tempAdapter.getRowNumber();
                    if (tempRowNumber >= beforeRow && tempRowNumber < beforeRow + beforeRowSpan) {
                        tempAdapter.setRowNumber(tempRowNumber + rowSpan);
                    } else if (tempRowNumber >= row && tempRowNumber < row + rowSpan) {
                        tempAdapter.setRowNumber(tempRowNumber - beforeRowSpan);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void init() {
        this.adjustGrandColumn = 0;
        this.adjustGrandRow = 0;
        this.columnAndMeasureColumnNumber = -1;
        this.map.clear();
    }

    private void buildModel(List ori, List columns, List rows, List details) {
        int rowBase = (Integer)this.map.get(COLUMNAREA_ROW);
        int columnBase = (Integer)this.map.get(ROWAREA_COLUMN);
        this.adjustSpan(columns, rows, details);
        this.addToModel(ori, columns, 0, columnBase);
        this.addToModel(ori, rows, rowBase, 0);
        this.addToModel(ori, details, rowBase, columnBase);
    }

    private void adjustSpan(List columns, List rows, List details) {
        Object obj;
        int columnSpanBase = (Integer)this.map.get(COLUMNAREA_COLUMN);
        int measureBase = this.getCrosstabReportItemHandle().getMeasureCount();
        int rowBase = (Integer)this.map.get(ROWAREA_ROW);
        if (columnSpanBase > 1 && details.size() == 1 && (obj = details.get(0)) instanceof VirtualCrosstabCellAdapter) {
            ((VirtualCrosstabCellAdapter)obj).setColumnSpan(columnSpanBase);
        }
        if (!this.isVertical() && measureBase > 1 && columns.size() == 1) {
            obj = columns.get(0);
            if (obj instanceof VirtualCrosstabCellAdapter) {
                ((VirtualCrosstabCellAdapter)obj).setColumnSpan(measureBase);
                this.columnAndMeasureColumnNumber = measureBase;
            } else {
                this.columnAndMeasureColumnNumber = -1;
            }
        }
        if (this.isVertical() && measureBase > 1 && rows.size() == 1) {
            obj = rows.get(0);
            if (obj instanceof VirtualCrosstabCellAdapter) {
                ((VirtualCrosstabCellAdapter)obj).setRowSpan(measureBase);
                this.columnAndMeasureColumnNumber = measureBase;
            } else {
                this.columnAndMeasureColumnNumber = -1;
            }
        }
        if (rowBase > 1 && details.size() == 1 && (obj = details.get(0)) instanceof VirtualCrosstabCellAdapter) {
            ((VirtualCrosstabCellAdapter)obj).setRowSpan(rowBase);
        }
    }

    private void addToModel(List ori, List add, int rowBase, int columnBase) {
        int size = add.size();
        int i = 0;
        while (i < size) {
            CrosstabCellAdapter adapter = (CrosstabCellAdapter)add.get(i);
            adapter.setRowNumber(rowBase + adapter.getRowNumber());
            adapter.setColumnNumber(columnBase + adapter.getColumnNumber());
            this.addToModel(ori, adapter);
            ++i;
        }
    }

    private List buildMeasures() {
        ArrayList<CrosstabCellAdapter> retValue = new ArrayList<CrosstabCellAdapter>();
        CrosstabReportItemHandle crosstab = this.getCrosstabReportItemHandle();
        int count = crosstab.getMeasureCount();
        int i = 0;
        while (i < count) {
            MeasureViewHandle measureHandle = crosstab.getMeasure(i);
            AggregationCellHandle handle = measureHandle.getCell();
            CrosstabCellAdapter adapter = this.factory.createCrosstabCellAdapter("cell_measure", (CrosstabCellHandle)handle, 1, -1, i + 1, -1, this.isVertical());
            retValue.add(adapter);
            int addregationCellCount = measureHandle.getAggregationCount();
            int j = 0;
            while (j < addregationCellCount) {
                List measuresHandles;
                Integer temp;
                AggregationCellHandle cell = measureHandle.getAggregationCell(j);
                LevelViewHandle levelViewHandle = cell.getLevelView(this.getWorkArea(1));
                if (levelViewHandle == null) {
                    temp = (Integer)this.map.get(this.getWorkArea(COLUMNAREA_COLUMN));
                    measuresHandles = crosstab.getAggregationMeasures(this.getWorkArea(1));
                } else {
                    temp = (Integer)this.map.get(levelViewHandle);
                    measuresHandles = levelViewHandle.getAggregationMeasures();
                }
                if (temp == null) {
                    throw new RuntimeException("build error");
                }
                int measureCount = measuresHandles.size();
                int position = measuresHandles.indexOf(measureHandle);
                if (temp <= count) {
                    measureCount = count;
                    position = i;
                }
                int tempPosition = temp >= measureCount ? temp : measureCount;
                int column = tempPosition - (measureCount - position) + 1;
                levelViewHandle = cell.getLevelView(this.getWorkArea(0));
                temp = levelViewHandle == null ? (Integer)this.map.get(this.getWorkArea(ROWAREA_ROW)) : (Integer)this.map.get(levelViewHandle);
                if (temp == null) {
                    throw new RuntimeException("build error");
                }
                int row = temp;
                CrosstabCellAdapter aggregationCell = this.factory.createCrosstabCellAdapter("measure_aggregation", (CrosstabCellHandle)cell, row, 1, column, 1, this.isVertical());
                retValue.add(aggregationCell);
                ++j;
            }
            ++i;
        }
        if (retValue.isEmpty()) {
            CrosstabCellAdapter first = this.factory.createCrosstabCellAdapter("measure_virtual", null, 1, -1, 1, -1, false);
            retValue.add(first);
        }
        return retValue;
    }

    private List buildRowArea() {
        List list;
        int size;
        int columnNumber;
        ArrayList<CrosstabCellAdapter> retValue = new ArrayList<CrosstabCellAdapter>();
        CrosstabReportItemHandle handle = this.getCrosstabReportItemHandle();
        int count = handle.getDimensionCount(0);
        int measureCount = handle.getMeasureCount();
        int n = columnNumber = measureCount == 0 ? 1 : 2;
        if (!this.isVertical() || this.isHideHeader()) {
            columnNumber = 1;
        }
        List measureHandleList = this.getMeasreViewHandleList();
        int rowNumber = 0;
        if (count != 0) {
            LevelViewHandle lastHandle = this.findLastLevelViewHandle(0);
            if (lastHandle == null) {
                throw new RuntimeException("lasthandle is null");
            }
            rowNumber = this.addMesureHeader(retValue, 0, 0, measureHandleList, lastHandle);
        }
        if (rowNumber == 0) {
            rowNumber = 1;
        }
        int i = count - 1;
        while (i >= 0) {
            DimensionViewHandle dimensionHandle = handle.getDimension(0, i);
            int levelCount = dimensionHandle.getLevelCount();
            int j = levelCount - 1;
            while (j >= 0) {
                List list2;
                LevelViewHandle levelHandle = dimensionHandle.getLevel(j);
                CrosstabCellHandle cellHandle = levelHandle.getCell();
                String type = j == 0 ? "first_level_handle" : "level_handle";
                CrosstabCellAdapter cellAdapter = this.factory.createCrosstabCellAdapter(type, cellHandle, 1, rowNumber, columnNumber, -1, false);
                retValue.add(cellAdapter);
                this.map.put(levelHandle, rowNumber);
                LevelViewHandle preLevelHandle = this.getPreviousLevelViewHandle(dimensionHandle, levelHandle);
                if (preLevelHandle != null && preLevelHandle.getAggregationHeader() != null && (list2 = preLevelHandle.getAggregationMeasures()).size() != 0) {
                    int preMeasureCount = list2.size();
                    CrosstabCellHandle preCellHandle = preLevelHandle.getAggregationHeader();
                    CrosstabCellAdapter preCellAdapter = this.factory.createCrosstabCellAdapter("sub_total", preCellHandle, rowNumber + 1, this.isVertical() ? preMeasureCount : 1, columnNumber, columnNumber - (this.isVertical() && !this.isHideHeader() ? 1 : 0), false);
                    retValue.add(preCellAdapter);
                    int addCount = this.addMesureHeader(retValue, rowNumber, 0, list2, preLevelHandle);
                    rowNumber += addCount == 0 ? 1 : addCount;
                }
                if (j != 0 || i != 0) {
                    ++columnNumber;
                }
                --j;
            }
            --i;
        }
        CrosstabCellHandle grandCell = handle.getGrandTotal(0);
        if (grandCell != null && !retValue.isEmpty() && (size = (list = handle.getAggregationMeasures(0)).size()) > 0) {
            CrosstabCellAdapter grandCellAdapter = this.factory.createCrosstabCellAdapter("grand_total", grandCell, rowNumber + 1, this.isVertical() ? size : 1, columnNumber, columnNumber - (this.isVertical() && !this.isHideHeader() ? 1 : 0), false);
            retValue.add(grandCellAdapter);
            int beforeRowNumber = rowNumber;
            int addCount = this.addMesureHeader(retValue, rowNumber, 0, list, null);
            rowNumber += addCount == 0 ? 1 : addCount;
            if (this.isGrandBefore(0)) {
                this.adjustGrandRow = rowNumber - beforeRowNumber;
            }
        }
        if (retValue.isEmpty()) {
            CrosstabCellAdapter columnVirtual = this.factory.createCrosstabCellAdapter("row_virtual", null, 1, -1, 1, -1, false);
            retValue.add(columnVirtual);
            columnNumber = 1;
            rowNumber = 1;
        }
        this.map.put(ROWAREA_COLUMN, columnNumber);
        this.map.put(ROWAREA_ROW, rowNumber);
        this.covertColumnNumber(columnNumber, retValue);
        return retValue;
    }

    private List buildColumnArea() {
        List list;
        int size;
        int rowNumber;
        ArrayList<CrosstabCellAdapter> retValue = new ArrayList<CrosstabCellAdapter>();
        CrosstabReportItemHandle handle = this.getCrosstabReportItemHandle();
        int count = handle.getDimensionCount(1);
        int measureCount = handle.getMeasureCount();
        int n = rowNumber = measureCount == 0 ? 1 : 2;
        if (this.isVertical() || this.isHideHeader()) {
            rowNumber = 1;
        }
        List measureHandleList = this.getMeasreViewHandleList();
        int columnNumber = 0;
        if (count != 0) {
            LevelViewHandle lastHandle = this.findLastLevelViewHandle(1);
            if (lastHandle == null) {
                throw new RuntimeException("lasthandle is null");
            }
            columnNumber = this.addMesureHeader(retValue, 0, 1, measureHandleList, lastHandle);
        }
        if (columnNumber == 0) {
            columnNumber = 1;
        }
        int i = count - 1;
        while (i >= 0) {
            DimensionViewHandle dimensionHandle = handle.getDimension(1, i);
            int levelCount = dimensionHandle.getLevelCount();
            int j = levelCount - 1;
            while (j >= 0) {
                List list2;
                LevelViewHandle levelHandle = dimensionHandle.getLevel(j);
                CrosstabCellHandle cellHandle = levelHandle.getCell();
                String type = j == 0 ? "first_level_handle" : "level_handle";
                CrosstabCellAdapter cellAdapter = this.factory.createCrosstabCellAdapter(type, cellHandle, rowNumber, 1, 1, columnNumber, false);
                retValue.add(cellAdapter);
                this.map.put(levelHandle, columnNumber);
                LevelViewHandle preLevelHandle = this.getPreviousLevelViewHandle(dimensionHandle, levelHandle);
                if (preLevelHandle != null && preLevelHandle.getAggregationHeader() != null && (list2 = preLevelHandle.getAggregationMeasures()).size() != 0) {
                    int preMeasureCount = list2.size();
                    CrosstabCellHandle preCellHandle = preLevelHandle.getAggregationHeader();
                    CrosstabCellAdapter preCellAdapter = this.factory.createCrosstabCellAdapter("sub_total", preCellHandle, rowNumber, rowNumber - (this.isVertical() || this.isHideHeader() ? 0 : 1), columnNumber + 1, this.isVertical() ? 1 : preMeasureCount, false);
                    retValue.add(preCellAdapter);
                    int addCount = this.addMesureHeader(retValue, columnNumber, 1, list2, preLevelHandle);
                    columnNumber += addCount == 0 ? 1 : addCount;
                }
                if (j != 0 || i != 0) {
                    ++rowNumber;
                }
                --j;
            }
            --i;
        }
        CrosstabCellHandle grandCell = handle.getGrandTotal(1);
        if (grandCell != null && !retValue.isEmpty() && (size = (list = handle.getAggregationMeasures(1)).size()) > 0) {
            CrosstabCellAdapter grandCellAdapter = this.factory.createCrosstabCellAdapter("grand_total", grandCell, rowNumber, rowNumber - (this.isVertical() || this.isHideHeader() ? 0 : 1), columnNumber + 1, this.isVertical() ? 1 : size, false);
            retValue.add(grandCellAdapter);
            int addCount = this.addMesureHeader(retValue, columnNumber, 1, list, null);
            int beforeColumnNumber = columnNumber;
            columnNumber += addCount == 0 ? 1 : addCount;
            if (this.isGrandBefore(1)) {
                this.adjustGrandColumn = columnNumber - beforeColumnNumber;
            }
        }
        if (retValue.isEmpty()) {
            CrosstabCellAdapter columnVirtual = this.factory.createCrosstabCellAdapter("column_virtual", null, 1, -1, 1, -1, false);
            retValue.add(columnVirtual);
            columnNumber = 1;
            rowNumber = 1;
        }
        this.map.put(COLUMNAREA_COLUMN, columnNumber);
        this.map.put(COLUMNAREA_ROW, rowNumber);
        this.covertRowNumber(rowNumber, retValue);
        return retValue;
    }

    private void covertRowNumber(int rowNumber, List cells) {
        CrosstabCellAdapter adapter;
        int size = cells.size();
        int i = 0;
        while (i < size) {
            adapter = (CrosstabCellAdapter)cells.get(i);
            adapter.setRowNumber(rowNumber - adapter.getRowNumber() + 1);
            ++i;
        }
        if (this.isPageLayoutOver()) {
            i = 0;
            while (i < size) {
                adapter = (CrosstabCellAdapter)cells.get(i);
                int row = adapter.getRowNumber();
                int rowSpan = adapter.getRowSpan();
                int column = adapter.getColumnNumber();
                int columnSpan = adapter.getColumnSpan();
                if (adapter.getPositionType().equals("sub_total")) {
                    adapter.setRowNumber(row - 1);
                    adapter.setRowSpan(rowSpan + 1);
                    CrosstabCellAdapter levelAdapter = this.getCell(row - 1, column - 1, cells);
                    levelAdapter.setColumnSpan(levelAdapter.getColumnSpan() - columnSpan);
                }
                ++i;
            }
        }
    }

    private CrosstabCellAdapter getCell(int rowNumber, int columnNumber, List list) {
        int i = 0;
        while (i < list.size()) {
            CrosstabCellAdapter adapter = (CrosstabCellAdapter)list.get(i);
            if (rowNumber >= adapter.getRowNumber() && rowNumber < adapter.getRowNumber() + adapter.getRowSpan() && columnNumber >= adapter.getColumnNumber() && columnNumber < adapter.getColumnNumber() + adapter.getColumnSpan()) {
                return adapter;
            }
            ++i;
        }
        return null;
    }

    private void covertColumnNumber(int columnNumber, List cells) {
        CrosstabCellAdapter adapter;
        int size = cells.size();
        int i = 0;
        while (i < size) {
            adapter = (CrosstabCellAdapter)cells.get(i);
            adapter.setColumnNumber(columnNumber - adapter.getColumnNumber() + 1);
            ++i;
        }
        if (this.isPageLayoutOver()) {
            i = 0;
            while (i < size) {
                adapter = (CrosstabCellAdapter)cells.get(i);
                int row = adapter.getRowNumber();
                int rowSpan = adapter.getRowSpan();
                int column = adapter.getColumnNumber();
                int columnSpan = adapter.getColumnSpan();
                if (adapter.getPositionType().equals("sub_total")) {
                    adapter.setColumnNumber(column - 1);
                    adapter.setColumnSpan(columnSpan + 1);
                    CrosstabCellAdapter levelAdapter = this.getCell(row - 1, column - 1, cells);
                    levelAdapter.setRowSpan(levelAdapter.getRowSpan() - rowSpan);
                }
                ++i;
            }
        }
    }

    private int addMesureHeaderToVirtual(List list, int rowNumber, int rowSpan, int columnNumber, int columnSpan, List measures) {
        int measureCount = measures.size();
        if (this.isHideHeader()) {
            return measureCount;
        }
        int k = 0;
        while (k < measureCount) {
            MeasureViewHandle preMmeasureHandle = (MeasureViewHandle)measures.get(k);
            CrosstabCellHandle preMeasureCellHandle = preMmeasureHandle.getHeader();
            CrosstabCellAdapter measureCellAdapt = this.factory.createCrosstabCellAdapter("measure_header", preMeasureCellHandle, rowNumber, rowSpan, columnNumber, columnSpan, false);
            if (this.isVertical()) {
                ++rowNumber;
            } else {
                ++columnNumber;
            }
            list.add(measureCellAdapt);
            ++k;
        }
        return measureCount;
    }

    private int addMesureHeader(List list, int baseColumn, int area, List measures, LevelViewHandle levelHandle) {
        if (this.isVertical() && area == 1) {
            return 0;
        }
        if (!this.isVertical() && area == 0) {
            return 0;
        }
        int measureCount = measures.size();
        if (this.isHideHeader()) {
            return measureCount;
        }
        int k = 0;
        while (k < measureCount) {
            MeasureViewHandle preMmeasureHandle = (MeasureViewHandle)measures.get(k);
            CrosstabCellHandle preMeasureCellHandle = preMmeasureHandle.getHeader(levelHandle);
            CrosstabCellAdapter measureCellAdapt = this.factory.createCrosstabCellAdapter("measure_header", preMeasureCellHandle, 1, -1, baseColumn + k + 1, -1, this.isVertical());
            list.add(measureCellAdapt);
            ++k;
        }
        return measureCount;
    }

    private LevelViewHandle getPreviousLevelViewHandle(DimensionViewHandle dimensionHandle, LevelViewHandle levelHandle) {
        int index = levelHandle.getIndex();
        if (index > 0) {
            return dimensionHandle.getLevel(index - 1);
        }
        int dimIndex = dimensionHandle.getIndex();
        if (dimIndex <= 0) {
            return null;
        }
        DimensionViewHandle preDimsionViewHandle = this.getCrosstabReportItemHandle().getDimension(dimensionHandle.getAxisType(), dimIndex - 1);
        return preDimsionViewHandle.getLevel(preDimsionViewHandle.getLevelCount() - 1);
    }

    private void addToModel(List list, BaseCrosstabAdapter adapter) {
        if (!list.contains(adapter)) {
            if (this.oldModelList.contains(adapter)) {
                int index = this.oldModelList.indexOf(adapter);
                BaseCrosstabAdapter copy = (BaseCrosstabAdapter)this.oldModelList.get(index);
                list.add(adapter.copyToTarget(copy));
            } else {
                list.add(adapter);
            }
        }
    }

    private CrosstabReportItemHandle getCrosstabReportItemHandle() {
        return (CrosstabReportItemHandle)this.getCrosstabItemHandle();
    }

    public String toString() {
        return super.toString();
    }

    public int getRowCount() {
        Integer columnRow = (Integer)this.map.get(COLUMNAREA_ROW);
        if (columnRow == null) {
            throw new RuntimeException("model don't build");
        }
        Integer rowRow = (Integer)this.map.get(ROWAREA_ROW);
        if (columnRow == null) {
            throw new RuntimeException("model don't build");
        }
        int value = rowRow;
        if (this.getAdjustNumber(0) > value) {
            value = this.getAdjustNumber(0);
        }
        return columnRow + value;
    }

    public int getColumnCount() {
        Integer rowColumn = (Integer)this.map.get(ROWAREA_COLUMN);
        if (rowColumn == null) {
            throw new RuntimeException("model don't build");
        }
        Integer columnColumn = (Integer)this.map.get(COLUMNAREA_COLUMN);
        if (columnColumn == null) {
            throw new RuntimeException("model don't build");
        }
        int value = columnColumn;
        if (this.getAdjustNumber(1) > value) {
            value = this.getAdjustNumber(1);
        }
        return rowColumn + value;
    }

    private int getAdjustNumber(int type) {
        if (!this.isVertical() && type == 1 || this.isVertical() && type == 0) {
            return this.columnAndMeasureColumnNumber;
        }
        return -1;
    }

    public DimensionHandle getRowHeight(int number) {
        CrosstabCellHandle handle = this.getRowOprationCell(number);
        if (handle == null) {
            return null;
        }
        try {
            return this.getCrosstabReportItemHandle().getRowHeight(handle);
        }
        catch (CrosstabException e) {
            return null;
        }
    }

    public void setRowHeight(int number, int value) {
        CrosstabCellHandle handle = this.getRowOprationCell(number);
        if (handle == null) {
            return;
        }
        try {
            CrosstabCellHandle cell = CrosstabModelUtil.locateRowHeightCell((CrosstabReportItemHandle)this.getCrosstabReportItemHandle(), (CrosstabCellHandle)handle);
            MetricUtility.updateDimension((DimensionHandle)cell.getHeight(), (double)value);
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    public CrosstabCellHandle getRowOprationCell(int rowNumber) {
        int size = this.oldModelList.size();
        int i = 0;
        while (i < size) {
            CrosstabCellAdapter cellAdapter = (CrosstabCellAdapter)this.oldModelList.get(i);
            if (!(cellAdapter.getRowNumber() != rowNumber || cellAdapter.getRowSpan() != 1 || cellAdapter.getCrosstabCellHandle() == null || this.isVertical() && cellAdapter.getPositionType().equals("measure_header"))) {
                return cellAdapter.getCrosstabCellHandle();
            }
            ++i;
        }
        return null;
    }

    public CrosstabCellHandle getColumnOprationCell(int columnNumber) {
        int size = this.oldModelList.size();
        int i = 0;
        while (i < size) {
            CrosstabCellAdapter cellAdapter = (CrosstabCellAdapter)this.oldModelList.get(i);
            if (cellAdapter.getColumnNumber() == columnNumber && cellAdapter.getColumnSpan() == 1 && cellAdapter.getCrosstabCellHandle() != null && (this.isVertical() || !cellAdapter.getPositionType().equals("measure_header"))) {
                return cellAdapter.getCrosstabCellHandle();
            }
            ++i;
        }
        return null;
    }

    public DimensionHandle getColumnWidth(int number) {
        CrosstabCellHandle handle = this.getColumnOprationCell(number);
        if (handle == null) {
            return null;
        }
        try {
            return this.getCrosstabReportItemHandle().getColumnWidth(handle);
        }
        catch (CrosstabException e) {
            return null;
        }
    }

    public void setColumnWidth(int number, int value) {
        CrosstabCellHandle handle = this.getColumnOprationCell(number);
        if (handle == null) {
            return;
        }
        try {
            CrosstabCellHandle cell = CrosstabModelUtil.locateColumnWidthCell((CrosstabReportItemHandle)this.getCrosstabReportItemHandle(), (CrosstabCellHandle)handle);
            MetricUtility.updateDimension((DimensionHandle)cell.getWidth(), (double)value);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    public void setWidth(double value, String units) {
    }

    public void setWidth(int value) {
        this.setWidth(value, "px");
    }

    public String getDefinedWidth() {
        return DEFAULT_WIDTH;
    }

    public int hashCode() {
        return this.getCrosstabItemHandle().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this.getCrosstabItemHandle()) {
            return true;
        }
        if (obj instanceof CrosstabHandleAdapter) {
            return this.getCrosstabItemHandle() == ((CrosstabHandleAdapter)obj).getCrosstabItemHandle();
        }
        if (obj instanceof ExtendedItemHandle) {
            try {
                return this.getCrosstabItemHandle() == ((ExtendedItemHandle)obj).getReportItem();
            }
            catch (ExtendedElementException e) {
                return false;
            }
        }
        return super.equals(obj);
    }

    private String getWorkArea(String type) {
        if (this.isVertical()) {
            if (type.equals(COLUMNAREA_COLUMN)) {
                return ROWAREA_ROW;
            }
            if (type.equals(ROWAREA_ROW)) {
                return COLUMNAREA_COLUMN;
            }
        }
        return type;
    }

    private int getWorkArea(int type) {
        if (this.isVertical()) {
            if (type == 1) {
                return 0;
            }
            if (type == 0) {
                return 1;
            }
        }
        return type;
    }

    private boolean isVertical() {
        return "vertical".equals(this.getCrosstabReportItemHandle().getMeasureDirection());
    }

    private List getMeasreViewHandleList() {
        ArrayList<MeasureViewHandle> retValue = new ArrayList<MeasureViewHandle>();
        CrosstabReportItemHandle handle = this.getCrosstabReportItemHandle();
        int measureCount = handle.getMeasureCount();
        int k = 0;
        while (k < measureCount) {
            MeasureViewHandle preMmeasureHandle = handle.getMeasure(k);
            retValue.add(preMmeasureHandle);
            ++k;
        }
        return retValue;
    }

    private boolean isBefore(CrosstabCellHandle cellHandle) {
        CrosstabCellHandle parent = cellHandle;
        while (parent != null) {
            if (parent instanceof LevelViewHandle) {
                return "before".equals(((LevelViewHandle)parent).getAggregationHeaderLocation());
            }
            parent = parent.getContainer();
        }
        return false;
    }

    private boolean isGrandBefore(int type) {
        CrosstabReportItemHandle handle = this.getCrosstabReportItemHandle();
        return "before".equals(handle.getCrosstabView(type).getGrandTotalLocation());
    }

    private boolean isPageLayoutOver() {
        return this.getCrosstabReportItemHandle().getPageLayout().equals("down then over");
    }

    private boolean isHideHeader() {
        return this.getCrosstabReportItemHandle().isHideMeasureHeader();
    }

    private LevelViewHandle findLastLevelViewHandle(int type) {
        CrosstabReportItemHandle handle = this.getCrosstabReportItemHandle();
        int count = handle.getDimensionCount(type);
        if (count == 0) {
            return null;
        }
        DimensionViewHandle dimensionHandle = handle.getDimension(type, count - 1);
        int levelCount = dimensionHandle.getLevelCount();
        if (levelCount == 0) {
            return null;
        }
        LevelViewHandle levelHandle = dimensionHandle.getLevel(levelCount - 1);
        return levelHandle;
    }

    public boolean layoutCheck() {
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        CrosstabCellAdapter[][] adapters = new CrosstabCellAdapter[rowCount][columnCount];
        int i = 0;
        while (i < this.oldModelList.size()) {
            CrosstabCellAdapter adapter = (CrosstabCellAdapter)this.oldModelList.get(i);
            int rowNumber = adapter.getRowNumber();
            int rowSpan = adapter.getRowSpan();
            int columnNumber = adapter.getColumnNumber();
            int columnSpan = adapter.getColumnSpan();
            int j = 0;
            while (j < rowSpan) {
                int adapterRow = rowNumber + j;
                if (adapterRow > rowCount) {
                    return false;
                }
                int k = 0;
                while (k < columnSpan) {
                    int adapterColumn = columnNumber + k;
                    if (adapterColumn > columnCount) {
                        return false;
                    }
                    if (adapters[adapterRow - 1][adapterColumn - 1] == null) {
                        adapters[adapterRow - 1][adapterColumn - 1] = adapter;
                    } else {
                        CrosstabCellAdapter cfr_ignored_0 = adapters[adapterRow - 1][adapterColumn - 1];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < adapters.length) {
            int j = 0;
            while (j < adapters[i].length) {
                if (adapters[i][j] == null) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected class DefaultCrocsstabCellAdapterFactory
    implements ICrosstabCellAdapterFactory {
        protected DefaultCrocsstabCellAdapterFactory() {
        }

        @Override
        public CrosstabCellAdapter createCrosstabCellAdapter(String type, CrosstabCellHandle handle, int rowNumber, int rowSpan, int columnNumber, int columnSpan, boolean isConvert) {
            CrosstabCellAdapter retValue = null;
            if ("level_handle".equals(type) || "first_level_handle".equals(type)) {
                retValue = new NormalCrosstabCellAdapter(handle);
            } else if ("measure_header".equals(type)) {
                retValue = new HeaderCrosstabCellHandleAdapter(handle);
            } else if ("row_virtual".equals(type)) {
                retValue = new VirtualCrosstabCellAdapter(handle);
                ((VirtualCrosstabCellAdapter)retValue).setCrosstabReportItemHandle(CrosstabHandleAdapter.this.getCrosstabReportItemHandle());
                ((VirtualCrosstabCellAdapter)retValue).setType(0);
            } else if ("column_virtual".equals(type)) {
                retValue = new VirtualCrosstabCellAdapter(handle);
                ((VirtualCrosstabCellAdapter)retValue).setCrosstabReportItemHandle(CrosstabHandleAdapter.this.getCrosstabReportItemHandle());
                ((VirtualCrosstabCellAdapter)retValue).setType(1);
            } else if ("measure_virtual".equals(type)) {
                retValue = new VirtualCrosstabCellAdapter(handle);
                ((VirtualCrosstabCellAdapter)retValue).setCrosstabReportItemHandle(CrosstabHandleAdapter.this.getCrosstabReportItemHandle());
                ((VirtualCrosstabCellAdapter)retValue).setType(2);
            } else if (CrosstabHandleAdapter.LEFT_CONNER.equals(type)) {
                retValue = new VirtualCrosstabCellAdapter(handle);
                ((VirtualCrosstabCellAdapter)retValue).setCrosstabReportItemHandle(CrosstabHandleAdapter.this.getCrosstabReportItemHandle());
                ((VirtualCrosstabCellAdapter)retValue).setType(-1);
            } else if ("sub_total".equals(type)) {
                retValue = new TotalCrosstabCellHandleAdapter(handle);
                ((TotalCrosstabCellHandleAdapter)retValue).setType(0);
            } else if ("crosstab_header".equals(type)) {
                retValue = new CrosstabHeaderHandleAdapter(handle, 2);
            } else if ("grand_total".equals(type)) {
                retValue = new TotalCrosstabCellHandleAdapter(handle);
                ((TotalCrosstabCellHandleAdapter)retValue).setType(1);
            } else if ("measure_aggregation".equals(type) || "cell_measure".equals(type)) {
                retValue = new AggregationCrosstabCellAdapter((AggregationCellHandle)handle);
            }
            if (retValue == null) {
                return retValue;
            }
            if (isConvert) {
                int temp = rowNumber;
                rowNumber = columnNumber;
                columnNumber = temp;
                temp = rowSpan;
                rowSpan = columnSpan;
                columnSpan = temp;
            }
            if (rowNumber >= 1) {
                retValue.setRowNumber(rowNumber);
            }
            if (rowSpan >= 1) {
                retValue.setRowSpan(rowSpan);
            }
            if (columnNumber >= 1) {
                retValue.setColumnNumber(columnNumber);
            }
            if (columnSpan >= 1) {
                retValue.setColumnSpan(columnSpan);
            }
            retValue.setPositionType(type);
            return retValue;
        }
    }

    private static class ModelComparator
    implements Comparator {
        private ModelComparator() {
        }

        public int compare(Object o1, Object o2) {
            int part2Row;
            CrosstabCellAdapter part1 = (CrosstabCellAdapter)o1;
            CrosstabCellAdapter part2 = (CrosstabCellAdapter)o2;
            int part1Row = part1.getRowNumber();
            if (part1Row != (part2Row = part2.getRowNumber())) {
                return part1Row - part2Row;
            }
            return part1.getColumnNumber() - part2.getColumnNumber();
        }
    }
}

