/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalVariance
extends AggrFunction {
    public String getName() {
        return "VARIANCE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 3;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    public String getDescription() {
        return Messages.getString("TotalVariance.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalVariance.displayName");
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private Number sum = 0.0;
        private Number squareSum = 0.0;
        private int count = 0;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() {
            super.start();
            this.sum = 0.0;
            this.squareSum = 0.0;
            this.count = 0;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                Object obj = this.calculator.getTypedObject(args[0]);
                this.sum = this.calculator.add(this.sum, obj);
                this.squareSum = this.calculator.add(this.squareSum, this.calculator.multiply(obj, obj));
                ++this.count;
            }
        }

        @Override
        public Object getSummaryValue() throws DataException {
            if (this.count <= 1) {
                return null;
            }
            Object cnt = this.calculator.getTypedObject(this.count);
            return this.calculator.divide(this.calculator.subtract(this.calculator.multiply(cnt, this.squareSum), this.calculator.multiply(this.sum, this.sum)), this.calculator.multiply(cnt, this.calculator.subtract(cnt, this.calculator.getTypedObject(1))));
        }
    }
}

