/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartNumberEditor;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class LocalizedNumberEditorComposite
extends AbstractChartNumberEditor
implements ModifyListener,
KeyListener,
FocusListener {
    public static final int TEXT_MODIFIED = 0;
    public static final int TEXT_FRACTION_CONVERTED = 1;
    protected transient Text txtValue;
    protected transient Vector<ModifyListener> vModifyListeners;
    private transient Vector<Listener> vFractionListeners;
    private transient double dValue;
    private transient boolean bTextModified = false;
    private transient boolean bValueIsSet = false;
    private transient boolean bOriginalValueIsSet = false;
    protected transient boolean bEnabled = true;
    protected transient int iStyle = 0;
    private transient NumberFormat numberFormat;
    protected String sUnit;
    protected Label lblUnit;

    public LocalizedNumberEditorComposite(Composite parent, int iStyle) {
        this(parent, iStyle, null);
    }

    public LocalizedNumberEditorComposite(Composite parent, int iStyle, String unit) {
        super(parent, 0);
        this.iStyle = iStyle;
        this.sUnit = unit;
        this.vModifyListeners = new Vector();
        this.vFractionListeners = new Vector();
        this.setLayout((Layout)new FillLayout());
        this.numberFormat = ChartUIUtil.getDefaultNumberFormatInstance();
        this.placeComponents();
        this.initAccessible();
    }

    protected void placeComponents() {
        GridLayout gl = new GridLayout(1, false);
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        if (this.sUnit != null) {
            gl.numColumns = 2;
        }
        this.txtValue = new Text((Composite)this, this.iStyle);
        GridData gd = new GridData(768);
        this.txtValue.setLayoutData((Object)gd);
        this.txtValue.setToolTipText(Messages.getString("TextEditorComposite.Tooltip.EnterDecimalOrFractionValue"));
        this.txtValue.addModifyListener((ModifyListener)this);
        this.txtValue.addFocusListener((FocusListener)this);
        this.txtValue.addKeyListener((KeyListener)this);
        if (this.sUnit != null) {
            this.lblUnit = new Label((Composite)this, 0);
            if (this.lblUnit != null) {
                this.lblUnit.setText(this.sUnit);
            }
        }
    }

    public void setEnabled(boolean bState) {
        this.bEnabled = bState;
        this.txtValue.setEnabled(bState);
        if (this.lblUnit != null) {
            this.lblUnit.setEnabled(bState);
        }
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public boolean isSetValue() {
        return this.bValueIsSet;
    }

    public void unsetValue() {
        this.bValueIsSet = false;
        this.txtValue.setText("");
    }

    public void setValue(double value) {
        this.bOriginalValueIsSet = true;
        this.bValueIsSet = true;
        this.dValue = value;
        this.txtValue.setText(this.numberFormat.format(value));
    }

    public double getValue() {
        return this.dValue;
    }

    public void setToolTipText(String string) {
        this.txtValue.setToolTipText(string);
    }

    public void addModifyListener(ModifyListener listener) {
        this.vModifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.vModifyListeners.remove(listener);
    }

    public void addFractionListener(Listener listener) {
        this.vFractionListeners.add(listener);
    }

    public void modifyText(ModifyEvent e) {
        this.bTextModified = true;
        this.fireEvent(true);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.bTextModified) {
            this.bTextModified = false;
            this.fireEvent();
        }
    }

    public void keyPressed(KeyEvent e) {
        if ((e.keyCode == 13 || e.keyCode == 0x1000050) && this.bTextModified) {
            this.bTextModified = false;
            this.fireEvent();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private void handleFormatError(String value) {
        MessageBox mbox = new MessageBox(this.getShell(), 40);
        mbox.setText(Messages.getString("LocalizedNumberEditorComposite.error.Title"));
        mbox.setMessage(MessageFormat.format((String)Messages.getString("LocalizedNumberEditorComposite.error.Message"), (Object[])new Object[]{value}));
        mbox.open();
        if (this.bOriginalValueIsSet) {
            this.txtValue.setText(String.valueOf((int)this.dValue));
        } else {
            this.txtValue.setText("");
        }
    }

    protected void fireEvent() {
        this.fireEvent(false);
    }

    protected void fireEvent(boolean bByModifyText) {
        Event e;
        String sText;
        boolean isFractionConverted;
        block13: {
            isFractionConverted = false;
            sText = this.txtValue.getText();
            if (sText == null || sText.trim().length() == 0) {
                this.bValueIsSet = false;
                this.dValue = 0.0;
            } else {
                int iDelimiter = sText.indexOf(47);
                if (iDelimiter < 0) {
                    iDelimiter = sText.indexOf(58);
                }
                if (iDelimiter > 0) {
                    isFractionConverted = true;
                    String numerator = sText.substring(0, iDelimiter);
                    String denominator = sText.substring(iDelimiter + 1);
                    try {
                        Number nume = this.numberFormat.parse(numerator);
                        Number deno = this.numberFormat.parse(denominator);
                        this.dValue = nume.doubleValue() / deno.doubleValue();
                        this.bValueIsSet = true;
                        sText = this.numberFormat.format(this.dValue);
                        if (!bByModifyText) {
                            this.txtValue.setText(sText);
                        }
                        break block13;
                    }
                    catch (ParseException e2) {
                        if (!this.bTextModified) {
                            this.handleFormatError(sText);
                        }
                        break block13;
                    }
                }
                try {
                    Number num = this.numberFormat.parse(sText);
                    this.dValue = num.doubleValue();
                    this.bValueIsSet = true;
                    sText = this.numberFormat.format(this.dValue);
                }
                catch (ParseException e3) {
                    if (this.bTextModified) break block13;
                    this.handleFormatError(sText);
                }
            }
        }
        int i = 0;
        while (i < this.vModifyListeners.size()) {
            e = new Event();
            e.data = bByModifyText ? Boolean.FALSE : Boolean.TRUE;
            e.widget = this;
            e.type = 0;
            this.vModifyListeners.get(i).modifyText(new ModifyEvent(e));
            ++i;
        }
        if (isFractionConverted) {
            i = 0;
            while (i < this.vFractionListeners.size()) {
                e = new Event();
                e.data = sText;
                e.widget = this;
                e.type = 1;
                this.vFractionListeners.get(i).handleEvent(e);
                ++i;
            }
        }
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = LocalizedNumberEditorComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = LocalizedNumberEditorComposite.this.txtValue.getCaretPosition();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = LocalizedNumberEditorComposite.this.toControl(new Point(e.x, e.y));
                if (LocalizedNumberEditorComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = LocalizedNumberEditorComposite.this.getBounds();
                Point pt = LocalizedNumberEditorComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = LocalizedNumberEditorComposite.this.txtValue.getText();
            }
        });
        ChartUIUtil.addScreenReaderAccessibility((Control)this, (Control)this.txtValue);
    }

    public Text getTextControl() {
        return this.txtValue;
    }

    public void setEObjectParent(EObject eParent) {
    }

    public Label getUnitLabel() {
        return this.lblUnit;
    }
}

