/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.FilterModelProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.dialogs.CrosstabFilterConditionBuilder;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class CrosstabFilterModelProvider
extends FilterModelProvider {
    private static final String[] EMPTY = new String[0];
    private static final String EMPTY_STRING = "";

    public boolean doEditItem(Object item, int pos) {
        if (item instanceof ExtendedItemHandle && ((ExtendedItemHandle)item).getExtensionName().equals("Crosstab")) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(item);
            Object[] levelArray = this.getElements(list);
            if (levelArray == null || levelArray.length <= 0) {
                return true;
            }
            TargetFilterConditionHandle targetFilterHandle = (TargetFilterConditionHandle)Arrays.asList(levelArray).get(pos);
            if (targetFilterHandle == null) {
                return false;
            }
            Object target = targetFilterHandle.getTarget();
            FilterConditionElementHandle filterHandle = targetFilterHandle.getfilterConditionHandle();
            CrosstabFilterConditionBuilder dialog = new CrosstabFilterConditionBuilder(UIUtil.getDefaultShell(), CrosstabFilterConditionBuilder.DLG_TITLE_EDIT, CrosstabFilterConditionBuilder.DLG_MESSAGE_EDIT);
            dialog.setDesignHandle((DesignElementHandle)item);
            dialog.setInput(filterHandle, target);
            return dialog.open() != 1;
        }
        return false;
    }

    public boolean deleteItem(Object item, int pos) throws PropertyValueException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(item);
        Object[] levelArray = this.getElements(list);
        if (levelArray == null || levelArray.length <= 0) {
            return true;
        }
        TargetFilterConditionHandle targetfilterKeyHandle = (TargetFilterConditionHandle)Arrays.asList(levelArray).get(pos);
        FilterConditionElementHandle filterCondition = targetfilterKeyHandle.getfilterConditionHandle();
        try {
            filterCondition.drop();
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean doAddItem(Object item, int pos) throws SemanticException {
        if (item instanceof ExtendedItemHandle && ((ExtendedItemHandle)item).getExtensionName().equals("Crosstab")) {
            CrosstabFilterConditionBuilder dialog = new CrosstabFilterConditionBuilder(UIUtil.getDefaultShell(), CrosstabFilterConditionBuilder.DLG_TITLE_NEW, CrosstabFilterConditionBuilder.DLG_MESSAGE_NEW);
            dialog.setDesignHandle((DesignElementHandle)item);
            return dialog.open() != 1;
        }
        return super.doAddItem(item, pos);
    }

    public String getText(Object element, String key) {
        FilterConditionElementHandle tmpElement;
        String value;
        if (!(element instanceof TargetFilterConditionHandle)) {
            return EMPTY_STRING;
        }
        if (key.equals("level")) {
            Object target = ((TargetFilterConditionHandle)element).getTarget();
            if (target instanceof LevelViewHandle) {
                LevelHandle cubeLevel = ((LevelViewHandle)target).getCubeLevel();
                if (cubeLevel == null) {
                    return EMPTY_STRING;
                }
                return cubeLevel.getFullName();
            }
            if (target instanceof MeasureViewHandle) {
                MeasureHandle cubeMeasure = ((MeasureViewHandle)target).getCubeMeasure();
                if (cubeMeasure == null) {
                    return EMPTY_STRING;
                }
                return cubeMeasure.getFullName();
            }
            if (target instanceof CrosstabReportItemHandle) {
                CubeHandle cube = ((CrosstabReportItemHandle)target).getCube();
                if (cube == null) {
                    return EMPTY_STRING;
                }
                return cube.getFullName();
            }
        }
        if ((value = (tmpElement = ((TargetFilterConditionHandle)element).getfilterConditionHandle()).getStringProperty(key)) == null) {
            value = EMPTY_STRING;
        }
        if (key.equals("operator")) {
            IChoice choice = choiceSet.findChoice(value);
            if (choice != null) {
                return choice.getDisplayName();
            }
        } else {
            return value;
        }
        return EMPTY_STRING;
    }

    public String[] getColumnNames(String[] keys) {
        assert (keys != null);
        String[] columnNames = new String[keys.length];
        columnNames[0] = Messages.getString("CrosstabFilterModelProvider.ColumnName.GroupLevelOrMeasure");
        int i = 1;
        while (i < keys.length) {
            IElementDefn ElementDefn = DEUtil.getMetaDataDictionary().getElement("FilterConditionElement");
            columnNames[i] = ElementDefn.getProperty(keys[i]).getDisplayName();
            ++i;
        }
        return columnNames;
    }

    public Object[] getElements(List input) {
        DesignElementHandle elementHandle;
        ArrayList<TargetFilterConditionHandle> list = new ArrayList<TargetFilterConditionHandle>();
        Object obj = input.get(0);
        if (!(obj instanceof ExtendedItemHandle)) {
            return EMPTY;
        }
        ExtendedItemHandle element = (ExtendedItemHandle)obj;
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTab == null) {
            return list.toArray();
        }
        if (crossTab.getCrosstabView(1) != null) {
            elementHandle = crossTab.getCrosstabView(1).getModelHandle();
            list.addAll(this.getLevel((ExtendedItemHandle)elementHandle));
        }
        if (crossTab.getCrosstabView(0) != null) {
            elementHandle = crossTab.getCrosstabView(0).getModelHandle();
            list.addAll(this.getLevel((ExtendedItemHandle)elementHandle));
        }
        int measureCount = crossTab.getMeasureCount();
        int i = 0;
        while (i < measureCount) {
            MeasureViewHandle measureView = crossTab.getMeasure(i);
            Iterator iter = measureView.filtersIterator();
            while (iter.hasNext()) {
                TargetFilterConditionHandle levelSortKeyHandle = new TargetFilterConditionHandle(measureView, (FilterConditionElementHandle)iter.next());
                list.add(levelSortKeyHandle);
            }
            ++i;
        }
        Iterator iter = crossTab.filtersIterator();
        while (iter.hasNext()) {
            TargetFilterConditionHandle levelSortKeyHandle = new TargetFilterConditionHandle(crossTab, (FilterConditionElementHandle)iter.next());
            list.add(levelSortKeyHandle);
        }
        return list.toArray();
    }

    private List getLevel(ExtendedItemHandle handle) {
        CrosstabViewHandle crossTabViewHandle = null;
        try {
            crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        ArrayList<TargetFilterConditionHandle> list = new ArrayList<TargetFilterConditionHandle>();
        if (crossTabViewHandle == null) {
            return list;
        }
        int dimensionCount = crossTabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crossTabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                Iterator iter = levelHandle.filtersIterator();
                while (iter.hasNext()) {
                    TargetFilterConditionHandle levelSortKeyHandle = new TargetFilterConditionHandle(levelHandle, (FilterConditionElementHandle)iter.next());
                    list.add(levelSortKeyHandle);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public boolean moveItem(Object item, int oldPos, int newPos) throws PropertyValueException {
        return false;
    }

    static class TargetFilterConditionHandle {
        protected FilterConditionElementHandle filterHandle;
        protected Object target;

        public TargetFilterConditionHandle(Object target, FilterConditionElementHandle filterCondition) {
            this.target = target;
            this.filterHandle = filterCondition;
        }

        public FilterConditionElementHandle getfilterConditionHandle() {
            return this.filterHandle;
        }

        public void setFilterConditionHandle(FilterConditionElementHandle filterCondition) {
            this.filterHandle = filterCondition;
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }
    }
}

