/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.util.ChartUtil;

public class AxisTickCoordinates
implements Cloneable {
    private int size;
    private double dStart;
    private double dEnd;
    private double dStep;
    private boolean isTickBetweenCategory;

    AxisTickCoordinates(int size, double dStart, double dEnd, double dStep, boolean isTickBetweenCategory) {
        this.size = size;
        this.dStart = dStart;
        this.dEnd = dEnd;
        this.dStep = dStep;
        this.isTickBetweenCategory = isTickBetweenCategory;
    }

    AxisTickCoordinates(int size, double dStart, double dEnd, double dStep) {
        this(size, dStart, dEnd, dStep, true);
    }

    void setEndPoints(double dStart, double dEnd) {
        this.dStart = dStart;
        this.dEnd = dEnd;
        this.dStep = this.isTickBetweenCategory ? (dEnd - dStart) / (double)(this.size - 1) : (dEnd - dStart) / (double)(this.size - 2);
    }

    public int size() {
        return this.size;
    }

    public double getStart() {
        return this.dStart;
    }

    public double getEnd() {
        return this.dEnd;
    }

    public double getStep() {
        return this.dStep;
    }

    public double getCoordinate(int index) {
        if (index == 0) {
            return this.dStart;
        }
        if (index == this.size - 1) {
            return this.dEnd;
        }
        return this.dStart + (double)index * this.dStep - (this.isTickBetweenCategory ? 0.0 : this.dStep / 2.0);
    }

    public int getTickSlot(double value) {
        double dTop = Math.max(this.dStart, this.dEnd);
        double dBottom = Math.min(this.dStart, this.dEnd);
        if (ChartUtil.mathLT(value, dBottom) && ChartUtil.mathGT(value, dTop)) {
            return -1;
        }
        double dStart1 = this.isTickBetweenCategory ? this.dStart : this.dStart - this.dStep / 2.0;
        int id = this.dStep > 0.0 ? (int)((value - dStart1 + 1.0E-9) / this.dStep) : (int)((value - dStart1 - 1.0E-9) / this.dStep);
        return id;
    }

    public double getNormalizedCoordinate(int index) {
        return this.getCoordinate(index) - this.dStart;
    }

    public Object clone() {
        try {
            AxisTickCoordinates cl = (AxisTickCoordinates)super.clone();
            cl.size = this.size;
            cl.dStart = this.dStart;
            cl.dEnd = this.dEnd;
            cl.dStep = this.dStep;
            cl.isTickBetweenCategory = this.isTickBetweenCategory;
            return cl;
        }
        catch (CloneNotSupportedException e) {
            return new AxisTickCoordinates(this.size, this.dStart, this.dEnd, this.dStep, this.isTickBetweenCategory);
        }
    }
}

