/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.cache.BasicCachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.aggregation.AggrExprInfo;
import org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

class AggregateCalculator {
    private List[] aggrValues;
    private Object[][] aggrArgs;
    private List aggrExprInfoList;
    private int aggrCount;
    private IResultIterator odiResult;
    private AccumulatorManager[] accumulatorManagers;
    private Set invalidAggrSet;
    private Map invalidAggrMsg;
    private static Logger logger = Logger.getLogger(AggregateCalculator.class.getName());

    AggregateCalculator(String tempDir, List aggrExprInfoList, IResultIterator odiResult) {
        Object[] params = new Object[]{aggrExprInfoList, odiResult};
        logger.entering(AggregateCalculator.class.getName(), "AggregateCalculator", params);
        assert (aggrExprInfoList != null);
        assert (odiResult != null);
        this.aggrExprInfoList = aggrExprInfoList;
        this.odiResult = odiResult;
        this.aggrCount = aggrExprInfoList.size();
        if (this.aggrCount > 0) {
            this.aggrValues = new List[this.aggrCount];
            this.aggrArgs = new Object[this.aggrCount][];
            int i = 0;
            while (i < this.aggrCount) {
                this.aggrValues[i] = new BasicCachedList(tempDir, DataEngineSession.getCurrentClassLoader());
                AggrExprInfo aggrInfo = this.getAggrInfo(i);
                this.aggrArgs[i] = new Object[aggrInfo.aggregation.getParameterDefn().length];
                ++i;
            }
            this.accumulatorManagers = new AccumulatorManager[this.aggrCount];
        }
        logger.exiting(AggregateCalculator.class.getName(), "AggregateCalculator");
    }

    void calculate(Scriptable scope, ScriptContext cx) throws DataException {
        ArrayList<Integer> validAggregations = new ArrayList<Integer>();
        boolean[] populateAggrValue = new boolean[this.aggrCount];
        int count = 1;
        int i = 0;
        while (i < this.aggrCount) {
            validAggregations.add(i);
            populateAggrValue[i] = this.getAggrInfo((int)i).aggregation.getNumberOfPasses() <= 1;
            this.accumulatorManagers[i] = new AccumulatorManager(this.getAggrInfo((int)i).aggregation);
            ++i;
        }
        while (validAggregations.size() > 0) {
            int[] validAggregationArray = new int[validAggregations.size()];
            int i2 = 0;
            while (i2 < validAggregations.size()) {
                validAggregationArray[i2] = (Integer)validAggregations.get(i2);
                ++i2;
            }
            assert (this.odiResult.getCurrentResultIndex() == 0);
            if (this.odiResult.getCurrentResult() == null) {
                return;
            }
            this.pass(scope, cx, populateAggrValue, validAggregationArray);
            this.odiResult.first(0);
            this.prepareNextIteration(validAggregations, populateAggrValue, ++count);
        }
    }

    private void pass(Scriptable scope, ScriptContext cx, boolean[] populateAggrValue, int[] validAggregationArray) throws DataException {
        do {
            int startingGroupLevel = this.odiResult.getStartingGroupLevel();
            int endingGroupLevel = this.odiResult.getEndingGroupLevel();
            int i = 0;
            while (i < validAggregationArray.length) {
                int index = validAggregationArray[i];
                if (this.invalidAggrSet != null && this.invalidAggrSet.contains(index)) {
                    this.addInvalidAggrMsg(index, endingGroupLevel);
                } else if (!this.onRow(index, startingGroupLevel, endingGroupLevel, scope, cx, populateAggrValue[index])) {
                    this.addInvalidAggrMsg(index, endingGroupLevel);
                    if (this.invalidAggrSet == null) {
                        this.invalidAggrSet = new HashSet();
                    }
                    this.invalidAggrSet.add(index);
                }
                ++i;
            }
        } while (this.odiResult.next());
    }

    private void addInvalidAggrMsg(int index, int endingGroupLevel) {
        assert (this.invalidAggrMsg != null);
        if (this.getAggrInfo((int)index).aggregation.getType() == 1 || endingGroupLevel <= this.getAggrInfo((int)index).groupLevel) {
            this.aggrValues[index].add(this.invalidAggrMsg.get(index));
        }
    }

    private boolean onRow(int aggrIndex, int startingGroupLevel, int endingGroupLevel, Scriptable scope, ScriptContext cx, boolean populateValue) throws DataException {
        Object value;
        boolean isRunning;
        AggrExprInfo aggrInfo = this.getAggrInfo(aggrIndex);
        Accumulator acc = null;
        boolean newGroup = false;
        if (startingGroupLevel <= aggrInfo.groupLevel) {
            newGroup = true;
            acc = this.accumulatorManagers[aggrIndex].next();
            acc.start();
        } else {
            acc = this.accumulatorManagers[aggrIndex].getCurrentAccumulator();
        }
        boolean accepted = true;
        if (aggrInfo.filter != null) {
            try {
                Object filterResult = ExprEvaluateUtil.evaluateCompiledExpression(aggrInfo.filter, this.odiResult, scope, cx);
                accepted = filterResult == null ? true : DataTypeUtil.toBoolean((Object)filterResult);
            }
            catch (BirtException e) {
                if (this.invalidAggrMsg == null) {
                    this.invalidAggrMsg = new HashMap();
                }
                this.invalidAggrMsg.put(aggrIndex, e);
                return false;
            }
        }
        if (aggrInfo.calculateLevel > 0 && startingGroupLevel > aggrInfo.calculateLevel) {
            accepted = false;
        }
        if (accepted) {
            IParameterDefn[] argDefs = aggrInfo.aggregation.getParameterDefn();
            assert (argDefs.length == this.aggrArgs[aggrIndex].length);
            try {
                this.calculateArguments(aggrIndex, scope, cx, aggrInfo, newGroup, argDefs);
                acc.onRow(this.aggrArgs[aggrIndex]);
            }
            catch (DataException e) {
                if (this.invalidAggrMsg == null) {
                    this.invalidAggrMsg = new HashMap();
                }
                this.invalidAggrMsg.put(aggrIndex, e);
                return false;
            }
        }
        boolean bl = isRunning = aggrInfo.aggregation.getType() == 1;
        if (isRunning && populateValue) {
            value = acc.getValue();
            this.aggrValues[aggrIndex].add(value);
        }
        if (endingGroupLevel <= aggrInfo.groupLevel) {
            acc.finish();
            if (!isRunning && populateValue) {
                value = acc.getValue();
                this.aggrValues[aggrIndex].add(value);
            }
        }
        return true;
    }

    private void calculateArguments(int aggrIndex, Scriptable scope, ScriptContext cx, AggrExprInfo aggrInfo, boolean newGroup, IParameterDefn[] argDefs) throws DataException {
        if (aggrInfo.args == null || aggrInfo.args.length == 0) {
            this.aggrArgs[aggrIndex] = null;
        } else {
            int i = 0;
            while (i < argDefs.length) {
                if (!argDefs[i].isOptional() || newGroup) {
                    this.aggrArgs[aggrIndex][i] = ExprEvaluateUtil.evaluateCompiledExpression(aggrInfo.args[i], this.odiResult, scope, cx);
                }
                ++i;
            }
        }
    }

    private void prepareNextIteration(List validAggregations, boolean[] populateAggrValue, int count) {
        validAggregations.clear();
        int i = 0;
        while (i < this.aggrCount) {
            this.accumulatorManagers[i].restart();
            IAggrFunction temp = this.getAggrInfo((int)i).aggregation;
            populateAggrValue[i] = false;
            int passesNumber = temp.getNumberOfPasses();
            if (count <= passesNumber) {
                validAggregations.add(i);
                if (count == passesNumber) {
                    populateAggrValue[i] = true;
                }
            }
            ++i;
        }
    }

    private AggrExprInfo getAggrInfo(int i) {
        return (AggrExprInfo)this.aggrExprInfoList.get(i);
    }

    Scriptable getJSAggrValueObject() {
        return new JSAggrValueObject(this.aggrExprInfoList, this.odiResult, this.aggrValues);
    }

    private static class AccumulatorManager {
        private IAggrFunction aggregation;
        private int cursor;
        private List cachedAcc;
        private Accumulator accumulator;

        AccumulatorManager(IAggrFunction aggregation) {
            this.aggregation = aggregation;
            this.cursor = -1;
            int passNum = aggregation.getNumberOfPasses();
            if (passNum < 2) {
                this.accumulator = aggregation.newAccumulator();
            } else {
                this.cachedAcc = new ArrayList();
            }
        }

        Accumulator getCurrentAccumulator() {
            if (this.accumulator != null) {
                return this.accumulator;
            }
            if (this.cachedAcc.size() == 0) {
                this.cachedAcc.add(this.aggregation.newAccumulator());
            }
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        Accumulator next() {
            if (this.accumulator != null) {
                return this.accumulator;
            }
            ++this.cursor;
            if (this.cachedAcc.size() > this.cursor) {
                return (Accumulator)this.cachedAcc.get(this.cursor);
            }
            this.cachedAcc.add(this.aggregation.newAccumulator());
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        void restart() {
            this.cursor = -1;
        }
    }
}

