/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.eclipse.birt.core.btree.BTreeConstants;
import org.eclipse.birt.core.btree.BTreeUtils;
import org.eclipse.birt.core.btree.NodeFile;

public class NodeOutputStream
extends OutputStream
implements BTreeConstants {
    private NodeFile file;
    private int blockId;
    private int offset;
    private byte[] bytes;
    private int blockCount;
    private int[] usedBlocks;

    public NodeOutputStream(NodeFile file) throws IOException {
        this(file, new int[]{file.allocBlock()});
    }

    public NodeOutputStream(NodeFile file, int[] usedBlocks) {
        this.file = file;
        this.bytes = new byte[4096];
        this.offset = 4096;
        this.usedBlocks = usedBlocks;
        this.blockId = -1;
        this.blockCount = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureCapacity();
        this.bytes[this.offset] = (byte)(b & 0xFF);
        ++this.offset;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            this.ensureCapacity();
            int copySize = 4096 - this.offset;
            if (copySize > len) {
                copySize = len;
            }
            System.arraycopy(b, off, this.bytes, this.offset, copySize);
            off += copySize;
            this.offset += copySize;
            len -= copySize;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.blockId != -1) {
            BTreeUtils.integerToBytes(-1, this.bytes);
            this.file.writeBlock(this.blockId, this.bytes);
        }
        int i = this.blockCount;
        while (i < this.usedBlocks.length) {
            int freeBlock = this.usedBlocks[i];
            if (freeBlock != -1) {
                this.file.freeBlock(freeBlock);
            }
            ++i;
        }
    }

    private void ensureCapacity() throws IOException {
        if (this.offset >= 4096) {
            int nextBlockId;
            if (this.blockCount >= this.usedBlocks.length) {
                int[] blocks = new int[this.blockCount * 2];
                System.arraycopy(this.usedBlocks, 0, blocks, 0, this.usedBlocks.length);
                Arrays.fill(blocks, this.usedBlocks.length, blocks.length, -1);
                this.usedBlocks = blocks;
            }
            if ((nextBlockId = this.usedBlocks[this.blockCount]) == -1) {
                this.usedBlocks[this.blockCount] = nextBlockId = this.file.allocBlock();
            }
            if (this.blockId != -1) {
                BTreeUtils.integerToBytes(nextBlockId, this.bytes);
                this.file.writeBlock(this.blockId, this.bytes);
            }
            this.blockId = nextBlockId;
            ++this.blockCount;
            Arrays.fill(this.bytes, (byte)0);
            this.offset = 4;
        }
    }

    public int[] getUsedBlocks() {
        int[] blocks = new int[this.blockCount];
        System.arraycopy(this.usedBlocks, 0, blocks, 0, this.blockCount);
        return blocks;
    }
}

