/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.ShiftLibraryRecord;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class ShiftLibraryCommand
extends AbstractElementCommand {
    public ShiftLibraryCommand(Module module) {
        super(module, module);
        assert (module instanceof ReportDesign);
    }

    public void shiftLibrary(Library library, int newPosn) throws SemanticException {
        int adjustedNewPosn;
        List<Library> libraries = this.module.getLibraries();
        assert (!libraries.isEmpty());
        if (!libraries.contains(library)) {
            throw new LibraryException(library, new String[]{library.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        int oldPosn = libraries.indexOf(library);
        if (oldPosn == (adjustedNewPosn = ShiftLibraryCommand.checkAndAdjustPosition(oldPosn, newPosn, libraries.size()))) {
            return;
        }
        ActivityStack stack = this.getActivityStack();
        ShiftLibraryRecord record = new ShiftLibraryRecord(this.module, oldPosn, adjustedNewPosn);
        stack.startTrans(record.getLabel());
        this.getActivityStack().execute(record);
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, this.module);
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("libraries");
        cmd.moveItem(new StructureContext(this.module, propDefn, null), oldPosn, newPosn);
        stack.commit();
    }
}

