/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.model.IMixedHandle;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.actions.PasteAction;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.util.CopyUtil;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.ui.actions.Clipboard;

public class PasteHandler
extends SelectionHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        Object selection = this.getFirstSelectVariable();
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Paste action >> Paste " + String.valueOf(this.getClipBoardContents()));
        }
        if (selection instanceof IMixedHandle) {
            Object cbContents = this.sortClipboardContents(this.getClipBoardContents(), selection);
            if (cbContents instanceof Object[]) {
                Object[] contents = (Object[])cbContents;
                if (PasteAction.validateCanPaste(((IMixedHandle)selection).getSlotHandle(), contents[0], null)) {
                    DNDUtil.copyHandles((Object)contents[0], (Object)((IMixedHandle)selection).getSlotHandle());
                }
                if (PasteAction.validateCanPaste(((IMixedHandle)selection).getPropertyHandle(), contents[1], null)) {
                    DNDUtil.copyHandles((Object)contents[1], (Object)((IMixedHandle)selection).getPropertyHandle());
                }
            }
        } else {
            DNDUtil.copyHandles((Object)this.getClipBoardContents(), (Object)selection);
        }
        return null;
    }

    protected Object getClipBoardContents() {
        return Clipboard.getDefault().getContents();
    }

    protected Object sortClipboardContents(Object transferData, Object targetObj) {
        if (transferData instanceof Object[] && targetObj instanceof IMixedHandle) {
            Object[] array = (Object[])transferData;
            ArrayList<Object> sHandle = new ArrayList<Object>();
            ArrayList<Object> pHandle = new ArrayList<Object>();
            int i = 0;
            while (i < array.length) {
                if (array[i] instanceof IElementCopy) {
                    if (CopyUtil.canPaste((IElementCopy)((IElementCopy)array[i]), (DesignElementHandle)((IMixedHandle)targetObj).getSlotHandle().getElementHandle(), (int)((IMixedHandle)targetObj).getSlotHandle().getSlotID()).canPaste()) {
                        sHandle.add(array[i]);
                    } else if (CopyUtil.canPaste((IElementCopy)((IElementCopy)array[i]), (DesignElementHandle)((IMixedHandle)targetObj).getPropertyHandle().getElementHandle(), (String)((IMixedHandle)targetObj).getPropertyHandle().getPropertyDefn().getName()).canPaste()) {
                        pHandle.add(array[i]);
                    }
                }
                ++i;
            }
            return new Object[]{sHandle.toArray(), pHandle.toArray()};
        }
        return transferData;
    }
}

