/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.style;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.odf.style.StyleConstant;

public class StyleEntry
implements StyleConstant,
Serializable,
Cloneable {
    private static final long serialVersionUID = 6959747237392429540L;
    public static final String ENTRYNAME_HYPERLINK = "Hyperlink";
    private int type;
    private transient IStyle originalStyle;
    private String name = null;
    private Object[] props = null;
    private Integer hashCode;

    StyleEntry(StyleEntry entry) {
        this(entry.getType());
        int i = 0;
        while (i < this.props.length) {
            this.props[i] = entry.props[i];
            ++i;
        }
        if (entry.hashCode != null) {
            this.hashCode = new Integer(entry.hashCode);
        }
        this.name = entry.name;
    }

    StyleEntry(IStyle originalStyle, int type) {
        this.originalStyle = originalStyle;
        this.type = type;
        this.props = new Object[66];
        this.name = null;
    }

    StyleEntry(int type) {
        this(null, type);
    }

    @Deprecated
    public IStyle getStyle() {
        return this.originalStyle;
    }

    public void setProperty(int id, Object value) {
        this.props[id] = value;
        this.hashCode = null;
    }

    public Object getProperty(int id) {
        return this.props[id];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StyleEntry)) {
            return false;
        }
        StyleEntry tar = (StyleEntry)obj;
        return tar.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int code = 0;
            code += Integer.valueOf(this.type).hashCode() * 2 + 1;
            this.hashCode = code += Arrays.deepHashCode(this.props);
        }
        return this.hashCode;
    }

    public static boolean isNull(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return "NULL".equalsIgnoreCase((String)value);
        }
        return false;
    }

    public Object clone() {
        StyleEntry o = null;
        try {
            o = (StyleEntry)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        int i = 0;
        while (i < this.props.length) {
            o.setProperty(i, this.getProperty(i));
            ++i;
        }
        return o;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Double getDoubleProperty(int index) {
        Object o = this.getProperty(index);
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        return null;
    }

    public Integer getIntegerProperty(int index) {
        Object o = this.getProperty(index);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return null;
    }

    public String getStringProperty(int index) {
        Object o = this.getProperty(index);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public Boolean getBoolProperty(int index) {
        Object o = this.getProperty(index);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAdded() {
        return this.name != null;
    }
}

