/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.ibm.icu.text.Bidi;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.WordWidth;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;

public class TextArea
extends AbstractArea
implements ITextArea {
    protected String text;
    protected String cachedText = null;
    private static final char SOFT_HYPHEN = '\u00ad';
    private boolean removeSoftHyphens = "true".equals(System.getProperty("org.eclipse.birt.softhyphen.remove", "true"));
    private boolean firstInLine = false;
    private boolean lastInLine = false;
    protected int runLevel;
    protected TextStyle style;
    protected int textLength;
    protected int offset;
    protected boolean lineBreak;
    protected boolean blankLine = false;
    protected int maxWidth;
    protected int whiteSpaceCount = 0;
    protected int characterCount = 0;
    protected boolean needClip = false;
    private int softHyphenWidth = 0;

    public void markAsFirstInLine() {
        this.firstInLine = true;
    }

    public void markAsLastInLine() {
        this.lastInLine = true;
    }

    @Override
    public int getWidth() {
        if (this.lastInLine) {
            return this.width + this.softHyphenWidth;
        }
        return this.width;
    }

    public int getSoftHyphenWidth() {
        return this.softHyphenWidth;
    }

    TextArea(TextArea area) {
        super(area);
        this.text = area.text;
        this.runLevel = area.runLevel;
        this.style = area.style;
        this.textLength = area.textLength;
        this.offset = area.offset;
    }

    @Override
    public int getBaseLine() {
        if (this.style != null) {
            return this.style.getFontInfo().getBaseline();
        }
        return super.getBaseLine();
    }

    public TextArea(String text, TextStyle style) {
        this.text = text;
        this.style = style;
        this.height = (int)(style.getFontInfo().getWordHeight() * 1000.0f);
    }

    public TextArea(TextStyle style) {
        this.style = style;
        this.height = (int)(style.getFontInfo().getWordHeight() * 1000.0f);
    }

    public void setRunLevel(int runLevel) {
        this.runLevel = runLevel;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(boolean lineBreak) {
        this.lineBreak = lineBreak;
    }

    public int getTextLength() {
        return this.textLength;
    }

    private String calculateText() {
        if (this.blankLine || this.text == null) {
            return "";
        }
        Object textResult = this.text.substring(this.offset, this.offset + this.textLength);
        if (this.removeSoftHyphens) {
            int indxSoftHyphen = ((String)textResult).indexOf(173);
            while (indxSoftHyphen >= 0) {
                String remaining = ((String)textResult).substring(indxSoftHyphen + 1);
                if (this.lastInLine && remaining.strip().length() == 0) break;
                textResult = ((String)textResult).substring(0, indxSoftHyphen) + remaining;
                indxSoftHyphen = ((String)textResult).indexOf(173);
            }
        }
        return textResult;
    }

    public void addWord(int textLength, WordWidth wordWidth) {
        this.textLength += textLength;
        this.width += wordWidth.width;
        this.softHyphenWidth = wordWidth.softHyphenWidth;
    }

    public void addWordUsingMaxWidth(int textLength) {
        this.textLength += textLength;
        this.width = this.maxWidth;
        this.needClip = true;
    }

    public void addWordSpacing(int wordSpacing) {
        this.width += wordSpacing;
    }

    public boolean hasSpace(int width) {
        return this.maxWidth - this.width > width;
    }

    public boolean isEmpty() {
        return this.textLength == 0;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setStyle(TextStyle style) {
        this.style = style;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    @Override
    public String getLogicalOrderText() {
        return this.calculateText();
    }

    @Override
    public String getText() {
        if (this.cachedText == null) {
            this.cachedText = (this.runLevel & 1) == 0 ? this.calculateText() : this.flip(this.calculateText());
        }
        return this.cachedText;
    }

    public void setText(String text) {
        this.cachedText = text;
    }

    public void setTextLength(int textLength) {
        this.textLength = textLength;
    }

    private String flip(String text) {
        return Bidi.writeReverse((String)text, (int)18);
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    @Override
    public TextStyle getTextStyle() {
        return this.style;
    }

    @Override
    public void accept(IAreaVisitor visitor) {
        visitor.visitText(this);
    }

    public int getTextWidth(String text) {
        FontInfo fontInfo = this.style.getFontInfo();
        if (fontInfo != null) {
            return (int)(this.style.getFontInfo().getWordWidth(text) * 1000.0f);
        }
        return 0;
    }

    @Override
    public TextArea cloneArea() {
        return new TextArea(this);
    }

    public int getWhiteSpaceCount() {
        return this.whiteSpaceCount;
    }

    public int getCharacterCount() {
        return this.characterCount;
    }

    public void countCharactersAndWhiteSpace() {
        this.whiteSpaceCount = 0;
        this.characterCount = 0;
        String text = this.getText();
        if (text == null) {
            return;
        }
        int len = text.length();
        int countWhiteSpace = 0;
        int countCharacters = 0;
        boolean atStart = true;
        int i = 0;
        while (i < len) {
            if (text.charAt(i) <= ' ') {
                if (!this.firstInLine || !atStart) {
                    ++countWhiteSpace;
                    ++countCharacters;
                }
            } else {
                atStart = false;
                ++countCharacters;
            }
            ++i;
        }
        if (this.lastInLine) {
            i = len - 1;
            while (i >= 0) {
                if (text.charAt(i) > ' ') break;
                --countWhiteSpace;
                --countCharacters;
                --i;
            }
        }
        this.whiteSpaceCount = countWhiteSpace;
        this.characterCount = countCharacters;
    }

    @Override
    public boolean needClip() {
        return this.needClip;
    }

    public String toString() {
        return "TextArea [removeSoftHyphens=" + this.removeSoftHyphens + ",firstInLine=" + this.firstInLine + ", lastInLine=" + this.lastInLine + ", runLevel=" + this.runLevel + ", textLength=" + this.textLength + ", text=" + (this.text != null ? this.text.substring(this.offset, this.offset + this.textLength) : "(null)") + ", lineBreak=" + this.lineBreak + ", blankLine=" + this.blankLine + ", maxWidth=" + this.maxWidth + ", whiteSpaceCount" + this.whiteSpaceCount + ", characterCount=" + this.characterCount + ", needClip=" + this.needClip + "]";
    }

    public boolean isFirstInLine() {
        return this.firstInLine;
    }

    public boolean isLastInLine() {
        return this.lastInLine;
    }
}

