/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.properties.Document;
import aQute.bnd.properties.IDocument;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginClassCodeGenerator;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.IBundleContentWizard;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IFragmentFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.IPluginFieldData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.osgi.service.prefs.BackingStoreException;

public class NewProjectCreationOperation
extends WorkspaceModifyOperation {
    private final IPluginContentWizard fContentWizard;
    private final IFieldData fData;
    private PluginClassCodeGenerator fGenerator;
    private WorkspacePluginModelBase fModel;
    private final IProjectProvider fProjectProvider;
    private boolean fResult;

    public NewProjectCreationOperation(IFieldData data, IProjectProvider provider, IPluginContentWizard contentWizard) {
        this.fData = data;
        this.fProjectProvider = provider;
        this.fContentWizard = contentWizard;
    }

    protected void adjustManifests(IProgressMonitor monitor, IProject project, IPluginBase bundle) throws CoreException {
        IPluginLibrary[] libs = this.fModel.getPluginBase().getLibraries();
        TreeSet<String> packages = new TreeSet<String>();
        IPluginLibrary[] iPluginLibraryArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary lib = iPluginLibraryArray[n2];
            String[] filters = lib.getContentFilters();
            if (filters.length == 1 && filters[0].equals("**")) {
                this.addAllSourcePackages(project, packages);
                break;
            }
            String[] stringArray = filters;
            int n3 = filters.length;
            int n4 = 0;
            while (n4 < n3) {
                String filter = stringArray[n4];
                if (filter.endsWith(".*")) {
                    packages.add(filter.substring(0, filter.length() - 2));
                }
                ++n4;
            }
            ++n2;
        }
        if (!packages.isEmpty()) {
            IBundle iBundle = ((WorkspaceBundlePluginModelBase)this.fModel).getBundleModel().getBundle();
            iBundle.setHeader("Export-Package", this.getCommaValuesFromPackagesSet(packages, this.fData.getVersion()));
        }
    }

    private void createBuildPropertiesFile(IProject project) throws CoreException {
        IFile file = PDEProject.getBuildProperties((IProject)project);
        if (!file.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(file);
            IBuildModelFactory factory = model.getFactory();
            IBuildEntry binEntry = factory.createEntry("bin.includes");
            this.fillBinIncludes(project, binEntry);
            this.createSourceOutputBuildEntries(model, factory);
            model.getBuild().add(binEntry);
            model.save();
        }
    }

    protected void createSourceOutputBuildEntries(WorkspaceBuildModel model, IBuildModelFactory factory) throws CoreException {
        String srcFolder = this.fData.getSourceFolderName();
        if (!this.fData.isSimple() && srcFolder != null) {
            String libraryName = this.fData.getLibraryName();
            if (libraryName == null) {
                libraryName = ".";
            }
            IBuildEntry entry = factory.createEntry("source." + libraryName);
            if (srcFolder.length() > 0) {
                entry.addToken(IPath.fromOSString((String)srcFolder).addTrailingSeparator().toString());
            } else {
                entry.addToken(".");
            }
            model.getBuild().add(entry);
            entry = factory.createEntry("output." + libraryName);
            String outputFolder = this.fData.getOutputFolderName().trim();
            if (outputFolder.length() > 0) {
                entry.addToken(IPath.fromOSString((String)outputFolder).addTrailingSeparator().toString());
            } else {
                entry.addToken(".");
            }
            model.getBuild().add(entry);
        }
    }

    protected void createContents(IProgressMonitor monitor, IProject project) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {
    }

    private void createManifest(IProject project) throws CoreException {
        IPluginReference[] dependencies;
        IFile fragmentXml = PDEProject.getFragmentXml((IProject)project);
        IFile pluginXml = PDEProject.getPluginXml((IProject)project);
        if (this.fData.hasBundleStructure()) {
            IFile manifest = PDEProject.getManifest((IProject)project);
            this.fModel = this.fData instanceof IFragmentFieldData ? new WorkspaceBundleFragmentModel(manifest, fragmentXml) : new WorkspaceBundlePluginModel(manifest, pluginXml);
        } else {
            this.fModel = this.fData instanceof IFragmentFieldData ? new WorkspaceFragmentModel(fragmentXml, false) : new WorkspacePluginModel(pluginXml, false);
        }
        IPluginBase pluginBase = this.fModel.getPluginBase();
        String targetVersion = ((AbstractFieldData)this.fData).getTargetVersion();
        pluginBase.setSchemaVersion(TargetPlatformHelper.getSchemaVersionForTargetVersion((String)targetVersion));
        pluginBase.setId(this.fData.getId());
        pluginBase.setVersion(this.fData.getVersion());
        pluginBase.setName(this.fData.getName());
        pluginBase.setProviderName(this.fData.getProvider());
        WorkspacePluginModelBase workspacePluginModelBase = this.fModel;
        if (workspacePluginModelBase instanceof IBundlePluginModelBase) {
            IBundlePluginModelBase bmodel = (IBundlePluginModelBase)workspacePluginModelBase;
            ((IBundlePluginBase)bmodel.getPluginBase()).setTargetVersion(targetVersion);
            bmodel.getBundleModel().getBundle().setHeader("Bundle-ManifestVersion", "2");
        }
        if (pluginBase instanceof IFragment) {
            IFragment fragment = (IFragment)pluginBase;
            IFragmentFieldData data = (IFragmentFieldData)this.fData;
            fragment.setPluginId(data.getPluginId());
            fragment.setPluginVersion(data.getPluginVersion());
            fragment.setRule(data.getMatch());
        } else if (((IPluginFieldData)this.fData).doGenerateClass()) {
            ((IPlugin)pluginBase).setClassName(((IPluginFieldData)this.fData).getClassname());
        }
        if (!this.fData.isSimple()) {
            this.setPluginLibraries(this.fModel);
        }
        IPluginReference[] iPluginReferenceArray = dependencies = this.getDependencies();
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginReference ref = iPluginReferenceArray[n2];
            IPluginImport iimport = this.fModel.getPluginFactory().createImport();
            iimport.setId(ref.getId());
            iimport.setVersion(ref.getVersion());
            iimport.setMatch(ref.getMatch());
            pluginBase.add(iimport);
            ++n2;
        }
        if (pluginBase instanceof BundlePluginBase) {
            String[] newFiles;
            IBundle bundle = ((BundlePluginBase)pluginBase).getBundle();
            String header = bundle.getHeader("Bundle-SymbolicName");
            bundle.setHeader("Automatic-Module-Name", NewProjectCreationOperation.determineAutomaticModuleNameFromBSN(header));
            String value = this.getCommaValuesFromPackagesSet(this.getImportPackagesSet(), this.fData.getVersion());
            if (value.length() > 0) {
                bundle.setHeader("Import-Package", value);
            }
            if (this.fData instanceof AbstractFieldData) {
                String framework;
                String exeEnvironment = ((AbstractFieldData)this.fData).getExecutionEnvironment();
                if (exeEnvironment != null) {
                    bundle.setHeader("Bundle-RequiredExecutionEnvironment", exeEnvironment);
                }
                if ((framework = ((AbstractFieldData)this.fData).getOSGiFramework()) != null && !framework.equals("Equinox")) {
                    return;
                }
            }
            if (this.fData instanceof IPluginFieldData && ((IPluginFieldData)this.fData).doGenerateClass()) {
                if (targetVersion.equals("3.1")) {
                    bundle.setHeader("Eclipse-AutoStart", "true");
                } else {
                    double version = Double.parseDouble(targetVersion);
                    if (version >= 3.4) {
                        bundle.setHeader("Bundle-ActivationPolicy", "lazy");
                    } else {
                        bundle.setHeader("Eclipse-LazyStart", "true");
                    }
                }
            }
            if (this.fContentWizard != null && (newFiles = this.fContentWizard.getNewFiles()) != null) {
                String[] stringArray = newFiles;
                int n3 = newFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    String newFile = stringArray[n4];
                    if ("plugin.properties".equals(newFile)) {
                        bundle.setHeader("Bundle-Localization", "plugin");
                        break;
                    }
                    ++n4;
                }
            }
        }
    }

    public static String determineAutomaticModuleNameFromBSN(String name) {
        int start = 0;
        int end = name.length();
        int index = start;
        while (index < end - 1) {
            block9: {
                if (name.charAt(index) == '-' && name.charAt(index + 1) >= '0' && name.charAt(index + 1) <= '9') {
                    int index2 = index + 2;
                    while (index2 < end) {
                        char c = name.charAt(index2);
                        if (c == '.') break;
                        if (c >= '0' && c <= '9') {
                            ++index2;
                            continue;
                        }
                        break block9;
                    }
                    end = index;
                    break;
                }
            }
            ++index;
        }
        StringBuilder sb = new StringBuilder(end - start);
        boolean needDot = false;
        int i = start;
        while (i < end) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                if (needDot) {
                    sb.append('.');
                    needDot = false;
                }
                sb.append(c);
            } else if (sb.length() > 0) {
                needDot = true;
            }
            ++i;
        }
        return sb.toString();
    }

    private IProject createProject() throws CoreException {
        IFolder folder;
        IProject project = this.fProjectProvider.getProject();
        if (!project.exists()) {
            CoreUtility.createProject((IProject)project, (IPath)this.fProjectProvider.getLocationPath(), null);
            project.open(null);
        }
        if (this.isAutomaticMetadata()) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.BndNature", null);
        } else {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", null);
        }
        if (!this.fData.isSimple() && !project.hasNature("org.eclipse.jdt.core.javanature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        }
        if (!this.fData.isSimple() && this.fData.getSourceFolderName() != null && this.fData.getSourceFolderName().trim().length() > 0 && !(folder = project.getFolder(this.fData.getSourceFolderName())).exists()) {
            CoreUtility.createFolder((IFolder)folder);
        }
        return project;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IEclipsePreferences pref;
        String framework;
        IFieldData iFieldData;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.NewProjectCreationOperation_creating, (int)this.getNumberOfWorkUnits());
        subMonitor.subTask(PDEUIMessages.NewProjectCreationOperation_project);
        IProject project = this.createProject();
        this.createContents((IProgressMonitor)subMonitor.split(1), project);
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            subMonitor.subTask(PDEUIMessages.NewProjectCreationOperation_setClasspath);
            this.setClasspath(project, this.fData);
            subMonitor.worked(1);
        }
        if ((iFieldData = this.fData) instanceof PluginFieldData) {
            PluginFieldData data = (PluginFieldData)iFieldData;
            if (data.doGenerateClass()) {
                this.generateTopLevelPluginClass(project, (IProgressMonitor)subMonitor.split(1));
            }
            if (data.doEnableAPITooling()) {
                this.addApiAnalysisNature();
            }
        }
        if (this.isAutomaticMetadata()) {
            subMonitor.subTask(PDEUIMessages.NewProjectCreationOperation_manifestFile);
            this.createBnd(project, (IProgressMonitor)subMonitor.split(1));
        } else {
            subMonitor.subTask(PDEUIMessages.NewProjectCreationOperation_manifestFile);
            this.createManifest(project);
            subMonitor.worked(1);
            subMonitor.subTask(PDEUIMessages.NewProjectCreationOperation_buildPropertiesFile);
            this.createBuildPropertiesFile(project);
            subMonitor.worked(1);
        }
        boolean contentWizardResult = true;
        if (this.fContentWizard != null) {
            contentWizardResult = this.fContentWizard.performFinish(project, (IPluginModelBase)this.fModel, (IProgressMonitor)subMonitor.split(1));
        }
        if (this.fData instanceof AbstractFieldData && (framework = ((AbstractFieldData)this.fData).getOSGiFramework()) != null && (pref = new ProjectScope(project).getNode("org.eclipse.pde.core")) != null) {
            pref.putBoolean("resolve.requirebundle", false);
            pref.putBoolean("pluginProject.extensions", false);
            if (!"Equinox".equals(framework)) {
                pref.putBoolean("pluginProject.equinox", false);
            }
            try {
                pref.flush();
            }
            catch (BackingStoreException e) {
                PDEPlugin.logException(e);
            }
        }
        if (this.fData.hasBundleStructure() && this.fModel instanceof WorkspaceBundlePluginModelBase) {
            this.adjustManifests((IProgressMonitor)subMonitor.split(1), project, this.fModel.getPluginBase());
        }
        if (this.fModel != null) {
            this.fModel.save();
            this.openFile((IFile)this.fModel.getUnderlyingResource());
        } else {
            IFile file = project.getFile("pde.bnd");
            if (file.exists()) {
                this.openFile(file);
            }
        }
        subMonitor.worked(1);
        this.fResult = contentWizardResult;
    }

    private boolean isAutomaticMetadata() {
        IFieldData iFieldData = this.fData;
        if (iFieldData instanceof PluginFieldData) {
            PluginFieldData d = (PluginFieldData)iFieldData;
            String framework = d.getOSGiFramework();
            return d.isAutomaticMetadataGeneration() && framework != null && !"Equinox".equals(framework);
        }
        return false;
    }

    private void createBnd(IProject project, IProgressMonitor monitor) throws CoreException {
        Document document = new Document("");
        BndEditModel model = new BndEditModel();
        model.setBundleSymbolicName(this.fData.getId());
        model.setBundleName(this.fData.getName());
        model.setBundleVendor(this.fData.getProvider());
        model.setBundleVersion(this.fData.getVersion());
        IFile file = project.getFile("pde.bnd");
        try {
            file.create(model.toAsciiStream((IDocument)document), true, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)"Can't create bnd properties file", (Throwable)e));
        }
    }

    private Set<String> getImportPackagesSet() {
        String[] packages;
        TreeSet<String> set = new TreeSet<String>();
        if (this.fGenerator != null) {
            packages = this.fGenerator.getImportPackages();
            Collections.addAll(set, packages);
        }
        if (this.fContentWizard instanceof IBundleContentWizard) {
            packages = ((IBundleContentWizard)this.fContentWizard).getImportPackages();
            Collections.addAll(set, packages);
        }
        return set;
    }

    protected void fillBinIncludes(IProject project, IBuildEntry binEntry) throws CoreException {
        if (!(this.fData.hasBundleStructure() && this.fContentWizard == null || ((AbstractFieldData)this.fData).getOSGiFramework() != null)) {
            binEntry.addToken(this.fData instanceof IFragmentFieldData ? "fragment.xml" : "plugin.xml");
        }
        if (this.fData.hasBundleStructure()) {
            binEntry.addToken("META-INF/");
        }
        if (!this.fData.isSimple()) {
            String libraryName = this.fData.getLibraryName();
            binEntry.addToken(libraryName == null ? "." : libraryName);
        }
        if (this.fContentWizard != null) {
            String[] files = this.fContentWizard.getNewFiles();
            int j = 0;
            while (j < files.length) {
                if (!binEntry.contains(files[j])) {
                    binEntry.addToken(files[j]);
                }
                ++j;
            }
        }
    }

    private void generateTopLevelPluginClass(IProject project, IProgressMonitor monitor) throws CoreException {
        PluginFieldData data = (PluginFieldData)this.fData;
        this.fGenerator = new PluginClassCodeGenerator(project, data.getClassname(), data, this.fContentWizard != null);
        this.fGenerator.generate(monitor);
    }

    private IClasspathEntry[] getClassPathEntries(IJavaProject project, IFieldData data) {
        IClasspathEntry[] internalClassPathEntries = this.getInternalClassPathEntries(project, data);
        IClasspathEntry[] entries = new IClasspathEntry[internalClassPathEntries.length + 2];
        System.arraycopy(internalClassPathEntries, 0, entries, 2, internalClassPathEntries.length);
        String executionEnvironment = null;
        if (data instanceof AbstractFieldData) {
            executionEnvironment = ((AbstractFieldData)data).getExecutionEnvironment();
        }
        ClasspathComputer.setComplianceOptions((IJavaProject)project, executionEnvironment);
        entries[0] = ClasspathComputer.createJREEntry((String)executionEnvironment);
        entries[1] = ClasspathComputer.createContainerEntry();
        return entries;
    }

    private IPluginReference[] getDependencies() {
        IPluginReference[] refs;
        ArrayList<IPluginReference> result = new ArrayList<IPluginReference>();
        if (this.fGenerator != null) {
            refs = this.fGenerator.getDependencies();
            Collections.addAll(result, refs);
        }
        if (this.fContentWizard != null) {
            refs = this.fContentWizard.getDependencies(this.fData.isLegacy() ? null : "3.0");
            int j = 0;
            while (j < refs.length) {
                if (!result.contains(refs[j])) {
                    result.add(refs[j]);
                }
                ++j;
            }
        }
        return result.toArray(new IPluginReference[result.size()]);
    }

    protected IClasspathEntry[] getInternalClassPathEntries(IJavaProject project, IFieldData data) {
        if (data.getSourceFolderName() == null) {
            return new IClasspathEntry[0];
        }
        IClasspathEntry[] entries = new IClasspathEntry[1];
        IPath path = project.getProject().getFullPath().append(data.getSourceFolderName());
        boolean isTestPlugin = ClasspathComputer.hasTestPluginName((IProject)project.getProject());
        if (isTestPlugin) {
            IClasspathAttribute testAttribute = JavaCore.newClasspathAttribute((String)"test", (String)"true");
            entries[0] = JavaCore.newSourceEntry((IPath)path, null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{testAttribute});
        } else {
            entries[0] = JavaCore.newSourceEntry((IPath)path);
        }
        return entries;
    }

    protected int getNumberOfWorkUnits() {
        IFieldData iFieldData;
        int numUnits = 4;
        if (this.fData.hasBundleStructure()) {
            ++numUnits;
        }
        if ((iFieldData = this.fData) instanceof IPluginFieldData) {
            IPluginFieldData data = (IPluginFieldData)iFieldData;
            if (data.doGenerateClass()) {
                ++numUnits;
            }
            if (this.fContentWizard != null) {
                ++numUnits;
            }
        }
        return numUnits;
    }

    public boolean getResult() {
        return this.fResult;
    }

    private void openFile(IFile file) {
        Display.getDefault().asyncExec(() -> {
            IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
            IWorkbenchPage page = ww.getActivePage();
            if (page == null) {
                return;
            }
            IWorkbenchPart focusPart = page.getActivePart();
            if (focusPart instanceof ISetSelectionTarget) {
                StructuredSelection selection = new StructuredSelection((Object)file);
                ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
            }
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        });
    }

    private void setClasspath(IProject project, IFieldData data) throws JavaModelException, CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (data.getOutputFolderName() != null) {
            IPath path = project.getFullPath().append(data.getOutputFolderName());
            javaProject.setOutputLocation(path, null);
        }
        IClasspathEntry[] entries = this.getClassPathEntries(javaProject, data);
        javaProject.setRawClasspath(entries, null);
    }

    protected void setPluginLibraries(WorkspacePluginModelBase model) throws CoreException {
        String libraryName = this.fData.getLibraryName();
        if (libraryName == null && !this.fData.hasBundleStructure()) {
            libraryName = ".";
        }
        if (libraryName != null) {
            IPluginLibrary library = model.getPluginFactory().createLibrary();
            library.setName(libraryName);
            library.setExported(!this.fData.hasBundleStructure());
            this.fModel.getPluginBase().add(library);
        }
    }

    protected String getCommaValuesFromPackagesSet(Set<String> values, String version) {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> iter = values.iterator();
        while (iter.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append("," + TextUtil.getDefaultLineDelimiter() + " ");
            }
            String value = iter.next().toString();
            buffer.append(value);
            if (value.contains(";version=") || version == null || values.size() != 1) continue;
            buffer.append(";version=\"").append(version).append("\"");
        }
        return buffer.toString();
    }

    private void addAllSourcePackages(IProject project, Set<String> list) {
        try {
            IClasspathEntry[] classpath;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (path = entry.getPath().removeFirstSegments(1)).segmentCount() > 0) {
                    IJavaElement[] children;
                    IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)project.getFolder(path));
                    IJavaElement[] iJavaElementArray = children = root.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement element = iJavaElementArray[n4];
                        IPackageFragment frag = (IPackageFragment)element;
                        if (frag.getChildren().length > 0 || frag.getNonJavaResources().length > 0) {
                            list.add(element.getElementName());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void addApiAnalysisNature() {
        try {
            IProject project = this.fProjectProvider.getProject();
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.pde.api.tools.apiAnalysisNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

