/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ExpressionComposite
extends Composite {
    protected Text text;
    private ExpressionButton button;

    public ExpressionComposite(Composite parent, boolean isFormStyle) {
        super(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 3;
        this.setLayout((Layout)layout);
        this.text = isFormStyle ? FormWidgetFactory.getInstance().createText((Composite)this, "", 10) : new Text((Composite)this, 2058);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.heightHint = this.text.computeSize((int)-1, (int)-1).y - (isFormStyle ? 0 : this.text.getBorderWidth() * 2);
        this.text.setLayoutData((Object)data);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ExpressionComposite.this.notifyListeners(24, null);
            }
        };
        this.button = ExpressionButtonUtil.createExpressionButton((Composite)this, (Control)this.text, null, null, (Listener)listener, (boolean)false, (int)(isFormStyle ? 0x800000 : 8), (ExpressionButtonUtil.ExpressionHelper)new ExpressionButtonUtil.ExpressionHelper());
        this.initAccessible();
    }

    public void setInput(Object input) {
        ExpressionButtonUtil.ExpressionHelper helper = (ExpressionButtonUtil.ExpressionHelper)this.button.getExpressionHelper();
        helper.setContextObject(DEUtil.getInputFirstElement((Object)input));
    }

    void initAccessible() {
        ((ExpressionButton)this.text.getData("exprButton")).getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = ((ExpressionButton)ExpressionComposite.this.text.getData("exprButton")).getControl().getToolTipText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = ExpressionComposite.this.text.getEditable() ? 42 : 41;
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = ExpressionComposite.this.text.getCaretPosition();
            }

            public void getSelectionRange(AccessibleTextEvent e) {
                Point sel = ExpressionComposite.this.text.getSelection();
                e.offset = sel.x;
                e.length = sel.y - sel.x;
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = ExpressionComposite.this.toControl(e.x, e.y);
                if (ExpressionComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ExpressionComposite.this.getBounds();
                Point pt = ExpressionComposite.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = ExpressionComposite.this.text.getText();
            }
        });
    }

    public void setExpression(Expression expression) {
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.text, (Expression)expression);
    }

    public Expression getExpression() {
        return ExpressionButtonUtil.getExpression((Control)this.text);
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        ((ExpressionButton)this.text.getData("exprButton")).setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setExpressionProvider(IExpressionProvider provider) {
        ExpressionButtonUtil.ExpressionHelper helper = (ExpressionButtonUtil.ExpressionHelper)this.button.getExpressionHelper();
        helper.setProvider(provider);
    }
}

