/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.HashMap;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.area.style.BorderInfo;
import org.w3c.dom.css.CSSValue;

public class BorderConflictResolver {
    static final int POSITION_LEFT = 0;
    static final int POSITION_TOP = 1;
    static final int POSITION_RIGHT = 2;
    static final int POSITION_BOTTOM = 3;
    static HashMap<Value, Integer> styleMap = null;
    static final int[] BORDER_COLOR_POPERTIES;
    static final int[] BORDER_WIDTH_POPERTIES;
    static final int[] BORDER_STYLE_POPERTIES;
    protected BorderCache tableLeftBorderCache = new BorderCache(4);
    protected BorderCache tableTopBorderCache = new BorderCache(4);
    protected BorderCache tableBottomBorderCache = new BorderCache(4);
    protected BorderCache pagenatedTableTopBorderCache = new BorderCache(4);
    protected BorderCache pagenatedTableBottomBorderCache = new BorderCache(4);
    protected BorderCache tableRightBorderCache = new BorderCache(4);
    protected BorderCache cellLeftBorderCache = new BorderCache(4);
    protected BorderCache cellTopBorderCache = new BorderCache(4);

    static {
        styleMap = new HashMap();
        styleMap.put(IStyle.NONE_VALUE, 0);
        styleMap.put(IStyle.INSET_VALUE, 1);
        styleMap.put(IStyle.GROOVE_VALUE, 2);
        styleMap.put(IStyle.OUTSET_VALUE, 3);
        styleMap.put(IStyle.RIDGE_VALUE, 4);
        styleMap.put(IStyle.DOTTED_VALUE, 5);
        styleMap.put(IStyle.DASHED_VALUE, 6);
        styleMap.put(IStyle.SOLID_VALUE, 7);
        styleMap.put(IStyle.DOUBLE_VALUE, 8);
        BORDER_COLOR_POPERTIES = new int[]{47, 24, 4, 5};
        BORDER_WIDTH_POPERTIES = new int[]{50, 27, 9, 10};
        BORDER_STYLE_POPERTIES = new int[]{58, 49, 20, 21};
    }

    public BorderInfo resolveTableLeftBorder(IStyle tableLeft, IStyle rowLeft, IStyle columnLeft, IStyle cellLeft) {
        return this.resolveBorder(this.tableLeftBorderCache, new BorderStyleInfo[]{new BorderStyleInfo(cellLeft, 0), new BorderStyleInfo(columnLeft, 0), new BorderStyleInfo(rowLeft, 0), new BorderStyleInfo(tableLeft, 0)});
    }

    public BorderInfo resolveTableTopBorder(IStyle tableTop, IStyle rowTop, IStyle columnTop, IStyle cellTop) {
        return this.resolveBorder(this.tableTopBorderCache, new BorderStyleInfo[]{new BorderStyleInfo(cellTop, 1), new BorderStyleInfo(rowTop, 1), new BorderStyleInfo(columnTop, 1), new BorderStyleInfo(tableTop, 1)});
    }

    public BorderInfo resolveTableBottomBorder(IStyle tableBottom, IStyle rowBottom, IStyle columnBottom, IStyle cellBottom) {
        return this.resolveBorder(this.tableBottomBorderCache, new BorderStyleInfo[]{new BorderStyleInfo(cellBottom, 3), new BorderStyleInfo(rowBottom, 3), new BorderStyleInfo(columnBottom, 3), new BorderStyleInfo(tableBottom, 3)});
    }

    public BorderInfo resolvePagenatedTableTopBorder(IStyle rowTop, IStyle cellTop) {
        return this.resolveBorder(this.pagenatedTableTopBorderCache, new BorderStyleInfo[]{new BorderStyleInfo(cellTop, 1), new BorderStyleInfo(rowTop, 1)});
    }

    public BorderInfo resolvePagenatedTableBottomBorder(IStyle rowBottom, IStyle cellBottom, IStyle usedStyle) {
        return this.resolveBorder(this.pagenatedTableBottomBorderCache, new BorderStyleInfo[]{new BorderStyleInfo(cellBottom, 3), new BorderStyleInfo(rowBottom, 3)});
    }

    public BorderInfo resolveTableRightBorder(IStyle tableRight, IStyle rowRight, IStyle columnRight, IStyle cellRight) {
        return this.resolveBorder(this.tableRightBorderCache, new BorderStyleInfo[]{new BorderStyleInfo(cellRight, 2), new BorderStyleInfo(columnRight, 2), new BorderStyleInfo(rowRight, 2), new BorderStyleInfo(tableRight, 2)});
    }

    public BorderInfo resolveCellLeftBorder(IStyle preColumnRight, IStyle columnLeft, IStyle preCellRight, IStyle cellLeft) {
        return this.resolveBorder(this.cellLeftBorderCache, new BorderStyleInfo[]{new BorderStyleInfo(preCellRight, 2), new BorderStyleInfo(cellLeft, 0), new BorderStyleInfo(preColumnRight, 2), new BorderStyleInfo(columnLeft, 0)});
    }

    public BorderInfo resolveCellTopBorder(IStyle preRowBottom, IStyle rowTop, IStyle preCellBottom, IStyle cellTop) {
        return this.resolveBorder(this.cellTopBorderCache, new BorderStyleInfo[]{new BorderStyleInfo(preCellBottom, 3), new BorderStyleInfo(cellTop, 1), new BorderStyleInfo(preRowBottom, 3), new BorderStyleInfo(rowTop, 1)});
    }

    private BorderInfo resolveBorder(BorderCache cache, BorderStyleInfo[] styles) {
        if (cache.isSame(styles)) {
            return cache.border;
        }
        CSSValue[] borderStyles = new CSSValue[styles.length];
        int i = 0;
        while (i < styles.length) {
            borderStyles[i] = styles[i].getBorderStyle();
            if (IStyle.HIDDEN_VALUE.equals(borderStyles[i])) {
                cache.setValues(styles, null);
                return null;
            }
            ++i;
        }
        int maxWidth = 0;
        int maxCount = 1;
        int maxFirstIndex = 0;
        int[] ws = new int[styles.length];
        CSSValue[] borderWidths = new CSSValue[styles.length];
        int i2 = 0;
        while (i2 < styles.length) {
            borderWidths[i2] = styles[i2].getBorderWidth();
            ws[i2] = PropertyUtil.getDimensionValue(styles[i2].getBorderWidth());
            if (ws[i2] > maxWidth) {
                maxWidth = ws[i2];
                maxCount = 1;
                maxFirstIndex = i2;
            } else if (ws[i2] == maxWidth) {
                ++maxCount;
            }
            ++i2;
        }
        BorderInfo border = null;
        if (maxWidth == 0 || maxCount == 1) {
            CSSValue color = styles[maxFirstIndex].getBorderColor();
            int width = PropertyUtil.getDimensionValue(borderWidths[maxFirstIndex]);
            if (width > 0) {
                border = new BorderInfo(color, borderStyles[maxFirstIndex], borderWidths[maxFirstIndex]);
            }
        } else {
            int max = 0;
            int maxStyleIndex = 0;
            int[] ss = new int[styles.length];
            int i3 = 0;
            while (i3 < styles.length) {
                if (ws[i3] == maxWidth) {
                    ss[i3] = styleMap.get(styles[i3].getBorderStyle());
                    if (ss[i3] > max) {
                        max = ss[i3];
                        maxStyleIndex = i3;
                    }
                }
                ++i3;
            }
            CSSValue color = styles[maxStyleIndex].getBorderColor();
            int width = PropertyUtil.getDimensionValue(borderWidths[maxStyleIndex]);
            if (width > 0) {
                border = new BorderInfo(color, borderStyles[maxStyleIndex], borderWidths[maxStyleIndex]);
            }
        }
        cache.setValues(styles, border);
        return border;
    }

    private static class BorderCache {
        IStyle[] styles;
        BorderInfo border;

        BorderCache(int styleCount) {
            this.styles = new IStyle[styleCount];
        }

        public void setValues(BorderStyleInfo[] stylesInfo, BorderInfo border) {
            this.border = border;
            int i = 0;
            while (i < stylesInfo.length) {
                this.styles[i] = stylesInfo[i].style;
                ++i;
            }
        }

        public boolean isSame(BorderStyleInfo[] stylesInfo) {
            if (this.styles.length == stylesInfo.length) {
                int i = 0;
                while (i < this.styles.length) {
                    if (this.styles[i] != stylesInfo[i].style) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
    }

    protected static class BorderStyleInfo {
        protected int position;
        protected IStyle style;

        public BorderStyleInfo(IStyle style, int position) {
            this.style = style;
            this.position = position;
        }

        public void setBorderColor(CSSValue value) {
            assert (this.style != null);
            this.style.setProperty(BORDER_COLOR_POPERTIES[this.position], value);
        }

        public CSSValue getBorderColor() {
            if (this.style != null) {
                return this.style.getProperty(BORDER_COLOR_POPERTIES[this.position]);
            }
            return IStyle.BLACK_RGB_VALUE;
        }

        public CSSValue getBorderStyle() {
            if (this.style != null) {
                return this.style.getProperty(BORDER_STYLE_POPERTIES[this.position]);
            }
            return IStyle.NONE_VALUE;
        }

        public CSSValue getBorderWidth() {
            if (this.style != null) {
                return this.style.getProperty(BORDER_WIDTH_POPERTIES[this.position]);
            }
            return null;
        }
    }
}

