/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.script.IDataRow;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.data.engine.api.script.IScriptDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IScriptDataSetMetaDataDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.script.DataSetJSEventHandler;

public class ScriptDataSetJSEventHandler
extends DataSetJSEventHandler
implements IScriptDataSetEventHandler {
    public ScriptDataSetJSEventHandler(ScriptContext cx, IScriptDataSetDesign design) {
        super(cx, design);
    }

    protected IScriptDataSetDesign getScriptDataSetDesign() {
        return (IScriptDataSetDesign)this.getBaseDesign();
    }

    @Override
    public void handleOpen(IDataSetInstanceHandle dataSet) throws BirtException {
        String script = this.getScriptDataSetDesign().getOpenScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSet.getScriptScope()).runScript("open", script);
        }
    }

    @Override
    public void handleClose(IDataSetInstanceHandle dataSet) throws BirtException {
        String script = this.getScriptDataSetDesign().getCloseScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSet.getScriptScope()).runScript("close", script);
        }
    }

    @Override
    public boolean handleFetch(IDataSetInstanceHandle dataSet, IDataRow row) throws BirtException {
        String script = this.getScriptDataSetDesign().getFetchScript();
        if (script != null && script.length() > 0) {
            Object result = this.getRunner(dataSet.getScriptScope()).runScript("fetch", script);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new DataException("data.engine.BadFetchScriptReturnType", new Object[]{"Fetch", result});
        }
        return false;
    }

    @Override
    public boolean handleDescribe(IDataSetInstanceHandle dataSet, IScriptDataSetMetaDataDefinition metaData) throws BirtException {
        String script = this.getScriptDataSetDesign().getDescribeScript();
        if (script != null && script.length() > 0) {
            Object result = this.getRunner(dataSet.getScriptScope()).runScript("describe", script);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new DataException("data.engine.BadFetchScriptReturnType", new Object[]{"Describe", result});
        }
        return false;
    }
}

