/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FlatVectorsReader;
import org.apache.lucene.codecs.HnswGraphProvider;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphSearcher;
import org.apache.lucene.util.hnsw.OrdinalTranslatedKnnCollector;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;
import org.apache.lucene.util.quantization.QuantizedVectorsReader;
import org.apache.lucene.util.quantization.ScalarQuantizer;

public final class Lucene99HnswVectorsReader
extends KnnVectorsReader
implements QuantizedVectorsReader,
HnswGraphProvider {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Lucene99HnswVectorsFormat.class);
    private final FieldInfos fieldInfos;
    private final Map<String, FieldEntry> fields = new HashMap<String, FieldEntry>();
    private final IndexInput vectorIndex;
    private final FlatVectorsReader flatVectorsReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene99HnswVectorsReader(SegmentReadState state, FlatVectorsReader flatVectorsReader) throws IOException {
        this.flatVectorsReader = flatVectorsReader;
        boolean success = false;
        this.fieldInfos = state.fieldInfos;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
        int versionMeta = -1;
        try {
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName, state.context);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "Lucene99HnswVectorsFormatMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    priorE = exception;
                }
                finally {
                    CodecUtil.checkFooter(meta, priorE);
                }
                this.vectorIndex = Lucene99HnswVectorsReader.openDataInput(state, versionMeta, "vex", "Lucene99HnswVectorsFormatIndex");
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.name, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
    }

    public static VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    public static VectorEncoding readVectorEncoding(DataInput input) throws IOException {
        int encodingId = input.readInt();
        if (encodingId < 0 || encodingId >= VectorEncoding.values().length) {
            throw new CorruptIndexException("Invalid vector encoding id: " + encodingId, input);
        }
        return VectorEncoding.values()[encodingId];
    }

    private FieldEntry readField(IndexInput input) throws IOException {
        VectorEncoding vectorEncoding = Lucene99HnswVectorsReader.readVectorEncoding(input);
        VectorSimilarityFunction similarityFunction = Lucene99HnswVectorsReader.readSimilarityFunction(input);
        return new FieldEntry(input, vectorEncoding, similarityFunction);
    }

    @Override
    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOfMap(this.fields, RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class)) + this.flatVectorsReader.ramBytesUsed();
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.flatVectorsReader.checkIntegrity();
        CodecUtil.checksumEntireFile(this.vectorIndex);
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.flatVectorsReader.getFloatVectorValues(field);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.flatVectorsReader.getByteVectorValues(field);
    }

    @Override
    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry.size() == 0 || knnCollector.k() == 0 || fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            return;
        }
        RandomVectorScorer scorer = this.flatVectorsReader.getRandomVectorScorer(field, target);
        OrdinalTranslatedKnnCollector collector = new OrdinalTranslatedKnnCollector(knnCollector, scorer::ordToDoc);
        Bits acceptedOrds = scorer.getAcceptOrds(acceptDocs);
        if (knnCollector.k() < scorer.maxOrd()) {
            HnswGraphSearcher.search(scorer, collector, this.getGraph(fieldEntry), acceptedOrds);
        } else {
            for (int i = 0; i < scorer.maxOrd(); ++i) {
                if (acceptedOrds != null && !acceptedOrds.get(i)) continue;
                knnCollector.incVisitedCount(1);
                knnCollector.collect(scorer.ordToDoc(i), scorer.score(i));
            }
        }
    }

    @Override
    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry.size() == 0 || knnCollector.k() == 0 || fieldEntry.vectorEncoding != VectorEncoding.BYTE) {
            return;
        }
        RandomVectorScorer scorer = this.flatVectorsReader.getRandomVectorScorer(field, target);
        OrdinalTranslatedKnnCollector collector = new OrdinalTranslatedKnnCollector(knnCollector, scorer::ordToDoc);
        Bits acceptedOrds = scorer.getAcceptOrds(acceptDocs);
        if (knnCollector.k() < scorer.maxOrd()) {
            HnswGraphSearcher.search(scorer, collector, this.getGraph(fieldEntry), acceptedOrds);
        } else {
            for (int i = 0; i < scorer.maxOrd(); ++i) {
                if (acceptedOrds != null && !acceptedOrds.get(i)) continue;
                knnCollector.incVisitedCount(1);
                knnCollector.collect(scorer.ordToDoc(i), scorer.score(i));
            }
        }
    }

    @Override
    public HnswGraph getGraph(String field) throws IOException {
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null) {
            throw new IllegalArgumentException("No such field '" + field + "'");
        }
        FieldEntry entry = this.fields.get(field);
        if (entry != null && entry.vectorIndexLength > 0L) {
            return this.getGraph(entry);
        }
        return HnswGraph.EMPTY;
    }

    private HnswGraph getGraph(FieldEntry entry) throws IOException {
        return new OffHeapHnswGraph(entry, this.vectorIndex);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.flatVectorsReader, this.vectorIndex);
    }

    @Override
    public QuantizedByteVectorValues getQuantizedVectorValues(String field) throws IOException {
        if (this.flatVectorsReader instanceof QuantizedVectorsReader) {
            return ((QuantizedVectorsReader)((Object)this.flatVectorsReader)).getQuantizedVectorValues(field);
        }
        return null;
    }

    @Override
    public ScalarQuantizer getQuantizationState(String field) {
        if (this.flatVectorsReader instanceof QuantizedVectorsReader) {
            return ((QuantizedVectorsReader)((Object)this.flatVectorsReader)).getQuantizationState(field);
        }
        return null;
    }

    private static final class OffHeapHnswGraph
    extends HnswGraph {
        final IndexInput dataIn;
        final int[][] nodesByLevel;
        final int numLevels;
        final int entryNode;
        final int size;
        int arcCount;
        int arcUpTo;
        int arc;
        private final DirectMonotonicReader graphLevelNodeOffsets;
        private final long[] graphLevelNodeIndexOffsets;
        private final int[] currentNeighborsBuffer;

        OffHeapHnswGraph(FieldEntry entry, IndexInput vectorIndex) throws IOException {
            this.dataIn = vectorIndex.slice("graph-data", entry.vectorIndexOffset, entry.vectorIndexLength);
            this.nodesByLevel = entry.nodesByLevel;
            this.numLevels = entry.numLevels;
            this.entryNode = this.numLevels > 1 ? this.nodesByLevel[this.numLevels - 1][0] : 0;
            this.size = entry.size();
            RandomAccessInput addressesData = vectorIndex.randomAccessSlice(entry.offsetsOffset, entry.offsetsLength);
            this.graphLevelNodeOffsets = DirectMonotonicReader.getInstance(entry.offsetsMeta, addressesData);
            this.currentNeighborsBuffer = new int[entry.M * 2];
            this.graphLevelNodeIndexOffsets = new long[this.numLevels];
            this.graphLevelNodeIndexOffsets[0] = 0L;
            for (int i = 1; i < this.numLevels; ++i) {
                int nodeCount = this.nodesByLevel[i - 1] == null ? this.size : this.nodesByLevel[i - 1].length;
                this.graphLevelNodeIndexOffsets[i] = this.graphLevelNodeIndexOffsets[i - 1] + (long)nodeCount;
            }
        }

        @Override
        public void seek(int level, int targetOrd) throws IOException {
            int targetIndex;
            int n = targetIndex = level == 0 ? targetOrd : Arrays.binarySearch(this.nodesByLevel[level], 0, this.nodesByLevel[level].length, targetOrd);
            assert (targetIndex >= 0);
            this.dataIn.seek(this.graphLevelNodeOffsets.get((long)targetIndex + this.graphLevelNodeIndexOffsets[level]));
            this.arcCount = this.dataIn.readVInt();
            if (this.arcCount > 0) {
                this.currentNeighborsBuffer[0] = this.dataIn.readVInt();
                for (int i = 1; i < this.arcCount; ++i) {
                    this.currentNeighborsBuffer[i] = this.currentNeighborsBuffer[i - 1] + this.dataIn.readVInt();
                }
            }
            this.arc = -1;
            this.arcUpTo = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            this.arc = this.currentNeighborsBuffer[this.arcUpTo];
            ++this.arcUpTo;
            return this.arc;
        }

        @Override
        public int numLevels() throws IOException {
            return this.numLevels;
        }

        @Override
        public int entryNode() throws IOException {
            return this.entryNode;
        }

        @Override
        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            if (level == 0) {
                return new HnswGraph.ArrayNodesIterator(this.size());
            }
            return new HnswGraph.ArrayNodesIterator(this.nodesByLevel[level], this.nodesByLevel[level].length);
        }
    }

    static class FieldEntry
    implements Accountable {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class);
        final VectorSimilarityFunction similarityFunction;
        final VectorEncoding vectorEncoding;
        final long vectorIndexOffset;
        final long vectorIndexLength;
        final int M;
        final int numLevels;
        final int dimension;
        final int size;
        final int[][] nodesByLevel;
        final DirectMonotonicReader.Meta offsetsMeta;
        final long offsetsOffset;
        final int offsetsBlockShift;
        final long offsetsLength;

        FieldEntry(IndexInput input, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) throws IOException {
            this.similarityFunction = similarityFunction;
            this.vectorEncoding = vectorEncoding;
            this.vectorIndexOffset = input.readVLong();
            this.vectorIndexLength = input.readVLong();
            this.dimension = input.readVInt();
            this.size = input.readInt();
            this.M = input.readVInt();
            this.numLevels = input.readVInt();
            this.nodesByLevel = new int[this.numLevels][];
            long numberOfOffsets = 0L;
            for (int level = 0; level < this.numLevels; ++level) {
                if (level > 0) {
                    int numNodesOnLevel = input.readVInt();
                    numberOfOffsets += (long)numNodesOnLevel;
                    this.nodesByLevel[level] = new int[numNodesOnLevel];
                    this.nodesByLevel[level][0] = input.readVInt();
                    for (int i = 1; i < numNodesOnLevel; ++i) {
                        this.nodesByLevel[level][i] = this.nodesByLevel[level][i - 1] + input.readVInt();
                    }
                    continue;
                }
                numberOfOffsets += (long)this.size;
            }
            if (numberOfOffsets > 0L) {
                this.offsetsOffset = input.readLong();
                this.offsetsBlockShift = input.readVInt();
                this.offsetsMeta = DirectMonotonicReader.loadMeta(input, numberOfOffsets, this.offsetsBlockShift);
                this.offsetsLength = input.readLong();
            } else {
                this.offsetsOffset = 0L;
                this.offsetsBlockShift = 0;
                this.offsetsMeta = null;
                this.offsetsLength = 0L;
            }
        }

        int size() {
            return this.size;
        }

        @Override
        public long ramBytesUsed() {
            return SHALLOW_SIZE + Arrays.stream(this.nodesByLevel).mapToLong(nodes -> RamUsageEstimator.sizeOf(nodes)).sum() + RamUsageEstimator.sizeOf(this.offsetsMeta);
        }
    }
}

