/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.raw.log.LogInstant;

public class LogCounter
implements LogInstant {
    public static final long INVALID_LOG_INSTANT = 0L;
    public static final long DERBY_10_0_MAX_LOGFILE_NUMBER = 0x3FFFFFL;
    public static final long MAX_LOGFILE_NUMBER = Integer.MAX_VALUE;
    private static final long FILE_NUMBER_SHIFT = 32L;
    public static final long MAX_LOGFILE_SIZE = 0xFFFFFFFL;
    private static final long FILE_POSITION_MASK = Integer.MAX_VALUE;
    private long fileNumber;
    private long filePosition;

    public LogCounter(long l) {
        this.fileNumber = LogCounter.getLogFileNumber(l);
        this.filePosition = LogCounter.getLogFilePosition(l);
    }

    public LogCounter(long l, long l2) {
        this.fileNumber = l;
        this.filePosition = l2;
    }

    public LogCounter() {
    }

    public static final long makeLogInstantAsLong(long l, long l2) {
        return l << 32 | l2;
    }

    public static final long getLogFilePosition(long l) {
        return l & Integer.MAX_VALUE;
    }

    public static final long getLogFileNumber(long l) {
        return l >>> 32;
    }

    @Override
    public boolean lessThan(DatabaseInstant databaseInstant) {
        LogCounter logCounter = (LogCounter)databaseInstant;
        return this.fileNumber == logCounter.fileNumber ? this.filePosition < logCounter.filePosition : this.fileNumber < logCounter.fileNumber;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LogCounter)) {
            return false;
        }
        LogCounter logCounter = (LogCounter)object;
        return this.fileNumber == logCounter.fileNumber && this.filePosition == logCounter.filePosition;
    }

    @Override
    public DatabaseInstant next() {
        return new LogCounter(LogCounter.makeLogInstantAsLong(this.fileNumber, this.filePosition) + 1L);
    }

    @Override
    public DatabaseInstant prior() {
        return new LogCounter(LogCounter.makeLogInstantAsLong(this.fileNumber, this.filePosition) - 1L);
    }

    public int hashCode() {
        return (int)(this.filePosition ^ this.fileNumber);
    }

    @Override
    public String toString() {
        return "(" + this.fileNumber + "," + this.filePosition + ")";
    }

    public static String toDebugString(long l) {
        return null;
    }

    public long getValueAsLong() {
        return LogCounter.makeLogInstantAsLong(this.fileNumber, this.filePosition);
    }

    public long getLogFilePosition() {
        return this.filePosition;
    }

    public long getLogFileNumber() {
        return this.fileNumber;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fileNumber = CompressedNumber.readLong(objectInput);
        this.filePosition = CompressedNumber.readLong(objectInput);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CompressedNumber.writeLong(objectOutput, this.fileNumber);
        CompressedNumber.writeLong(objectOutput, this.filePosition);
    }

    @Override
    public int getTypeFormatId() {
        return 130;
    }
}

