/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.io.FileNotFoundException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.core.runtime.ErrorStatus;
import org.eclipse.birt.report.designer.core.runtime.GUIException;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.extensions.ExceptionHandlerRegistry;
import org.eclipse.birt.report.designer.ui.extensions.IDesignerExceptionHandler;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ExceptionHandler {
    private static final String TITLE_ERROR = Messages.getString((String)"ExceptionHandler.Title.Error");
    private static final String TITLE_FILE_NOT_FOUND = Messages.getString((String)"ExceptionHandler.Title.FileNotFound");
    private static final String MSG_FILE_NOT_FOUND_PREFIX = Messages.getString((String)"ExceptionHandler.Title.FileNotFound");
    private static final String TITLE_UNKNOWN_HOST = Messages.getString((String)"ExceptionHandler.Title.UnknownHost");
    private static final String TITLE_PART_INIT_ERROR = Messages.getString((String)"ExceptionHandler.Title.PartInitError");
    private static final String MSG_UNKNOWN_HOST = Messages.getString((String)"ExceptionHandler.Message.UnknownHost");
    private static final String MSG_PART_INIT_ERROR = Messages.getString((String)"ExceptionHandler.Message.PartInitError");
    private static final String MSG_BIRT_EXCEPTION_OCURR = Messages.getString((String)"ExceptionHandler.Message.BirtExceptionOccur");
    private static final String LABEL_PLUGIN_PROVIDER = Messages.getString((String)"ExceptionHandler.Label.PluginProvider");
    private static final String LABEL_PLUGIN_NAME = Messages.getString((String)"ExceptionHandler.Label.PluginName");
    private static final String LABEL_PLUGIN_ID = Messages.getString((String)"ExceptionHandler.Label.PluginId");
    private static final String LABEL_PLUGIN_VERSION = Messages.getString((String)"ExceptionHandler.Label.PluginVersion");
    private static final String LABEL_ERROR_MESSAGE = Messages.getString((String)"ExceptionHandler.Label.ErrorMessage");
    private static final String LABEL_ERROR_CODE = Messages.getString((String)"ExceptionHandler.Label.ErrorCode");
    private static final String UNKNOWN_PLUGIN = Messages.getString((String)"ExceptionHandler.Label.UnknownPlugin");
    private static List ExpectedExceptionList = new ArrayList();

    static {
        ExpectedExceptionList.add(SemanticException.class);
    }

    public static void handle(Throwable e) {
        ExceptionHandler.handle(e, false);
    }

    public static void handle(Throwable e, boolean logOnly) {
        IDesignerExceptionHandler customizeHandler = ExceptionHandlerRegistry.getInstance().getExceptionHandler();
        if (customizeHandler != null) {
            customizeHandler.handle(e);
            return;
        }
        if (logOnly) {
            ErrorStatus status;
            if (!(e instanceof BirtException)) {
                e = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e);
            }
            if (ExceptionHandler.needLog(e) && (status = ExceptionHandler.createErrorStatus(e)) != null) {
                status.setException(e);
                ReportPlugin.getDefault().getLog().log((IStatus)status);
            }
        } else {
            String title = TITLE_ERROR;
            Object message = e.getLocalizedMessage();
            if (e instanceof UnknownHostException) {
                title = TITLE_UNKNOWN_HOST;
                message = MSG_UNKNOWN_HOST + (String)message;
            } else if (e instanceof FileNotFoundException) {
                title = TITLE_FILE_NOT_FOUND;
                message = MSG_FILE_NOT_FOUND_PREFIX + ":" + e.getLocalizedMessage();
            } else if (e instanceof PartInitException) {
                title = TITLE_PART_INIT_ERROR;
                message = MSG_PART_INIT_ERROR;
            }
            ExceptionHandler.handle(e, title, (String)message);
        }
    }

    public static void handle(Throwable e, String dialogTitle, String message) {
        ErrorStatus status;
        if (!(e instanceof BirtException)) {
            e = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e);
        }
        if ((status = ExceptionHandler.createErrorStatus(e)) != null) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)dialogTitle, (String)message, (IStatus)status);
            if (ExceptionHandler.needLog(e)) {
                status.setException(e);
                ReportPlugin.getDefault().getLog().log((IStatus)status);
            }
        } else {
            ExceptionHandler.openErrorMessageBox(dialogTitle, message);
        }
    }

    private static ErrorStatus createErrorStatus(Throwable e) {
        int severity;
        String reason = null;
        String[] detail = null;
        BirtException birtException = (BirtException)e;
        if (e instanceof DesignFileException) {
            detail = e.toString().split("\n");
            reason = detail[0];
            detail[0] = LABEL_ERROR_MESSAGE + ":" + detail[0];
        } else {
            reason = e instanceof GUIException ? ((GUIException)e).getReason() : MSG_BIRT_EXCEPTION_OCURR;
            detail = new String[]{LABEL_ERROR_MESSAGE + ":" + birtException.getLocalizedMessage()};
        }
        String id = birtException.getPluginId();
        if (id == null) {
            id = UNKNOWN_PLUGIN;
        }
        ErrorStatus status = new ErrorStatus(id, 1001, reason, null);
        if (!UNKNOWN_PLUGIN.equals(id)) {
            status.addInformation(LABEL_PLUGIN_PROVIDER + UIUtil.getPluginProvider(id));
            status.addInformation(LABEL_PLUGIN_NAME + UIUtil.getPluginName(id));
            status.addInformation(LABEL_PLUGIN_ID + id);
            status.addInformation(LABEL_PLUGIN_VERSION + UIUtil.getPluginVersion(id));
        }
        if ((severity = birtException.getSeverity()) == 5) {
            severity = 4;
        }
        status.addStatus(LABEL_ERROR_CODE + ":" + birtException.getErrorCode(), severity);
        int i = 0;
        while (i < detail.length) {
            status.addStatus(detail[i], severity);
            ++i;
        }
        return status;
    }

    private static boolean needLog(Throwable e) {
        Iterator iter = ExpectedExceptionList.iterator();
        while (iter.hasNext()) {
            if (!((Class)iter.next()).isInstance(e)) continue;
            return false;
        }
        if (e instanceof BirtException) {
            return (((BirtException)e).getSeverity() ^ 1) != 1;
        }
        return true;
    }

    public static int openMessageBox(String title, String message, int style) {
        MessageBox box = new MessageBox(UIUtil.getDefaultShell(), style);
        box.setText(title);
        box.setMessage(message);
        return box.open();
    }

    public static int openErrorMessageBox(String title, String errorMessage) {
        return ExceptionHandler.openMessageBox(title, errorMessage, 1);
    }
}

